/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.prefs.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;
import org.xissweb.prefs.PreferencesManager;
import org.xissweb.prefs.ui.ComponentConfigurator;

public class SplitPaneConfigurator {
    public static final String DIVIDER_POSITION_KEY = "divider.position";
    private static final String DIVIDER_PROPERTY = "lastDividerLocation";
    PreferencesManager prefs;
    String category;
    JSplitPane splitPane;
    String key;

    public static void configure(JSplitPane splitPane) {
        SplitPaneConfigurator.configure(ComponentConfigurator.getDefaultPreferenceManager(), splitPane, splitPane.getClass().getName(), DIVIDER_POSITION_KEY);
    }

    public static void configure(JSplitPane splitPane, String category) {
        SplitPaneConfigurator.configure(ComponentConfigurator.getDefaultPreferenceManager(), splitPane, category, DIVIDER_POSITION_KEY);
    }

    public static void configure(PreferencesManager prefs, JSplitPane splitPane) {
        SplitPaneConfigurator.configure(prefs, splitPane, splitPane.getClass().getName(), DIVIDER_POSITION_KEY);
    }

    public static void configure(PreferencesManager prefs, JSplitPane splitPane, String category) {
        SplitPaneConfigurator.configure(prefs, splitPane, splitPane.getClass().getName(), DIVIDER_POSITION_KEY);
    }

    public static void configure(JSplitPane splitPane, String category, String key) {
        SplitPaneConfigurator.configure(ComponentConfigurator.getDefaultPreferenceManager(), splitPane, category, key);
    }

    public static void configure(PreferencesManager prefs, JSplitPane splitPane, String category, String key) {
        new SplitPaneConfigurator(prefs, splitPane, category, key);
    }

    private SplitPaneConfigurator(PreferencesManager prefs, JSplitPane splitPane, String category, String key) {
        this.prefs = prefs;
        this.category = category;
        this.splitPane = splitPane;
        this.key = key;
        this.applyPreferences();
    }

    private void applyPreferences() {
        this.splitPane.setDividerLocation(this.prefs.getInt(this.key, this.category, this.splitPane.getDividerLocation()));
        this.splitPane.addPropertyChangeListener(new SplitPositionListener());
    }

    class SplitPositionListener
    implements PropertyChangeListener {
        SplitPositionListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(SplitPaneConfigurator.DIVIDER_PROPERTY)) {
                SplitPaneConfigurator.this.prefs.putInt(SplitPaneConfigurator.this.key, SplitPaneConfigurator.this.category, SplitPaneConfigurator.this.splitPane.getDividerLocation());
            }
        }
    }
}

