/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.xissweb.file.FileCopyObserver;
import org.xissweb.file.FileHelper;

public class SteppedFileCopier {
    private File fileIn;
    private File fileOut;
    private File tmpFile;
    private FileChannel inChannel = null;
    private FileChannel outChannel = null;
    private long size;
    private long position;
    private FileCopyObserver observer;

    public SteppedFileCopier(File fileIn, File fileOut) {
        this.fileIn = fileIn;
        this.fileOut = fileOut;
        this.size = fileIn.length();
        this.position = -1L;
    }

    public File getFileIn() {
        return this.fileIn;
    }

    public File getFileOut() {
        return this.fileOut;
    }

    public long getPosition() {
        return this.position;
    }

    public double progression() {
        if (this.position == -1L) {
            return -1.0;
        }
        return (double)(this.position / this.size) * 100.0;
    }

    public long getSize() {
        return this.size;
    }

    public FileCopyObserver getObserver() {
        return this.observer;
    }

    public synchronized void setObserver(FileCopyObserver observer) {
        this.observer = observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean step() throws IOException {
        if (this.position < 0L) {
            this.inChannel = new FileInputStream(this.fileIn).getChannel();
            this.tmpFile = File.createTempFile("tmp", FileHelper.fileNameExtention(this.fileOut.getName()), this.fileOut.getParentFile());
            this.outChannel = new FileOutputStream(this.tmpFile).getChannel();
            this.position = 0L;
            this.notifyProgressToObserver();
            return true;
        }
        if (this.position < this.size) {
            this.position += this.inChannel.transferTo(this.position, 1024L, this.outChannel);
            this.notifyProgressToObserver();
            return true;
        }
        if (this.position == this.size) {
            SteppedFileCopier steppedFileCopier = this;
            synchronized (steppedFileCopier) {
                this.closeAll();
                this.tmpFile.renameTo(this.fileOut);
                this.fileOut.setLastModified(this.fileIn.lastModified());
                this.notifyDoneToObserver();
            }
            return false;
        }
        return false;
    }

    public synchronized void stop() throws IOException {
        if (this.position != -1L && this.position < this.size) {
            this.position = this.size;
            this.closeAll();
            this.tmpFile.delete();
            this.notifyInterruptionToObserver();
        }
    }

    private void closeAll() throws IOException {
        if (this.inChannel != null) {
            this.inChannel.close();
            this.inChannel = null;
        }
        if (this.outChannel != null) {
            this.outChannel.close();
            this.outChannel = null;
        }
    }

    private void notifyProgressToObserver() {
        if (this.observer != null) {
            this.observer.copyProgress(this);
        }
    }

    private void notifyDoneToObserver() {
        if (this.observer != null) {
            this.observer.copyDone(this);
        }
    }

    private void notifyInterruptionToObserver() {
        if (this.observer != null) {
            this.observer.copyInterrupted(this);
        }
    }
}

