/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.content;

import org.w3c.dom.Document;
import org.xissweb.data.content.ContentInfoIdentifiable;
import org.xissweb.data.content.HtmlContentEnabled;
import org.xissweb.data.content.HtmlContentHelper;
import org.xissweb.data.content.ImageDescInfo;
import org.xissweb.data.content.ImageMetaData;
import org.xissweb.data.imetadata.ImageMetadataHelper;
import org.xissweb.image.ImageData;
import org.xissweb.xml.XMLHelper;

public class ImageInfo
implements ContentInfoIdentifiable,
HtmlContentEnabled {
    private String fileName;
    private int number;
    private String comment;
    private Document htmlComment;
    private ImageMetaData imageMetaData = null;
    private String title;
    private ImageDescInfo mainImageDesc;
    private ImageDescInfo originalImageDesc;
    private ImageDescInfo thumbnailDesc;
    private boolean imageExists;

    public ImageInfo(String fileName, int number) {
        this.fileName = fileName;
        this.number = number;
        this.comment = "";
        this.imageExists = false;
    }

    public Object clone() {
        ImageInfo info = new ImageInfo(this.fileName, this.number);
        info.comment = this.comment;
        if (this.htmlComment != null) {
            info.htmlComment = XMLHelper.cloneDoc(this.htmlComment);
        }
        info.imageExists = this.imageExists;
        if (this.imageMetaData != null) {
            info.imageMetaData = (ImageMetaData)this.imageMetaData.clone();
        }
        info.mainImageDesc = (ImageDescInfo)this.mainImageDesc.clone();
        if (this.originalImageDesc != null) {
            info.originalImageDesc = (ImageDescInfo)this.originalImageDesc.clone();
        }
        if (this.thumbnailDesc != null) {
            info.thumbnailDesc = (ImageDescInfo)this.thumbnailDesc.clone();
        }
        return info;
    }

    public boolean isHtmlContent() {
        return this.htmlComment != null;
    }

    public void setHtmlContent(boolean htmlContent, String encoding) {
        if (htmlContent) {
            this.htmlComment = HtmlContentHelper.toDocument("htmlComment", this.comment, encoding);
            this.comment = null;
        } else {
            this.comment = XMLHelper.valueOf(this.htmlComment, encoding, false);
            this.htmlComment = null;
        }
    }

    public void setHtmlValue(Document document) {
        this.htmlComment = document;
        this.comment = null;
    }

    public void setStringValue(String value) {
        this.comment = value;
        this.htmlComment = null;
    }

    public Object getIdentifier() {
        return this.getFileName();
    }

    public boolean hasOriginalImage() {
        return this.originalImageDesc != null;
    }

    public boolean isImageExists() {
        return this.imageExists;
    }

    public void setImageExist(boolean exists) {
        this.imageExists = exists;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int num) {
        this.number = num;
    }

    public String mainFileName() {
        String result = null;
        if (this.getMainImageDesc() != null) {
            result = this.getFileName() + '.' + this.getMainImageDesc().getExtension();
        }
        return result;
    }

    public String sourceFileForBuild(boolean repository) {
        if (repository) {
            return this.mainFileName();
        }
        String fileName = this.originalFileName();
        return fileName != null ? fileName : this.mainFileName();
    }

    public boolean hasComment() {
        return this.comment != null && this.comment.length() > 0 || this.htmlComment != null;
    }

    public String getComment() {
        return this.comment;
    }

    public Document getHtmlComment() {
        return this.htmlComment;
    }

    public ImageMetaData getMetaData() {
        if (this.imageMetaData == null) {
            this.imageMetaData = new ImageMetaData();
        }
        return this.imageMetaData;
    }

    public void setMetaData(ImageMetaData metaData) {
        if (this.imageMetaData == null || this.imageMetaData.getImageType() != metaData.getImageType()) {
            this.imageMetaData = metaData;
        } else {
            this.imageMetaData.updateWith(metaData);
        }
    }

    public void forceSetMetaData(ImageMetaData metaData) {
        this.imageMetaData = metaData;
    }

    public boolean isLocalizable() {
        return this.imageMetaData != null && this.imageMetaData.hasGeoLocation();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMainImageDesc(ImageDescInfo imgDesc) {
        this.mainImageDesc = imgDesc;
    }

    public ImageDescInfo getMainImageDesc() {
        return this.mainImageDesc;
    }

    public String originalFileName() {
        String result = null;
        if (this.hasOriginalImage()) {
            result = this.getFileName() + '.' + this.getOriginalImageDesc().getExtension();
        }
        return result;
    }

    public ImageDescInfo getOriginalImageDesc() {
        return this.originalImageDesc;
    }

    public void setOriginalImageDesc(ImageDescInfo originalImage) {
        this.originalImageDesc = originalImage;
    }

    public void setThumbnailDesc(ImageDescInfo imgDesc) {
        this.thumbnailDesc = imgDesc;
    }

    public ImageDescInfo getThumbnailDesc() {
        return this.thumbnailDesc;
    }

    public String thumbnailFileName() {
        String result = null;
        if (this.hasThumbnail()) {
            result = this.getFileName() + '.' + this.getThumbnailDesc().getExtension();
        }
        return result;
    }

    public boolean hasThumbnail() {
        return this.thumbnailDesc != null;
    }

    public boolean createOrUpdateMetaData(ImageData imageData) {
        boolean updated = false;
        imageData.readMetaData();
        String[] keys = null;
        String[] values = imageData.getMetaDatas();
        if (this.imageMetaData == null) {
            if (imageData.isDigitalImage()) {
                keys = ImageMetadataHelper.getImageMetaDataKeys(0);
                this.imageMetaData = new ImageMetaData(0);
            } else {
                keys = ImageMetadataHelper.getImageMetaDataKeys(3);
                this.imageMetaData = new ImageMetaData(3);
            }
            for (int i = 0; i < keys.length; ++i) {
                updated = this.imageMetaData.update(keys[i], values[i]) || updated;
            }
        }
        return updated;
    }
}

