/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.index.global.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xissweb.data.index.global.IndexInfo;
import org.xissweb.data.index.global.IndexesInfo;
import org.xissweb.data.index.global.xml.IndexSchema;
import org.xissweb.xml.XMLHelper;

public class IndexSerializer
implements IndexSchema {
    private boolean web;

    public void setWeb(boolean web) {
        this.web = web;
    }

    public void serialise(IndexesInfo indexes, String fileName) {
        this.serialize(indexes, new File(fileName));
    }

    public void serialize(IndexesInfo indexes, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            this.serialize(indexes, out);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void serialize(IndexesInfo indexes, OutputStream out) {
        Document outDoc = XMLHelper.createDocument();
        this.serialize(indexes, outDoc);
        XMLHelper.serialize(outDoc, out, "iso_8859-1");
    }

    public void serialize(IndexesInfo indexes, Document document) {
        Element root = document.createElement("indexes");
        root.setAttribute("type", indexes.getType());
        document.appendChild(root);
        Iterator i = indexes.getIndexes().iterator();
        while (i.hasNext()) {
            IndexInfo index = (IndexInfo)i.next();
            Element elt = document.createElement("index");
            elt.setAttribute("is-index", Boolean.toString(index.isIndex()));
            elt.setAttribute("path", index.getPath(this.web));
            elt.setAttribute("text", index.getText());
            root.appendChild(elt);
        }
    }
}

