/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.data.layout.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xissweb.data.imetadata.ImageMetadataHelper;
import org.xissweb.data.layout.AnimationInfo;
import org.xissweb.data.layout.ArrangementInfo;
import org.xissweb.data.layout.GoogleMapsInfo;
import org.xissweb.data.layout.ImageAreaInfo;
import org.xissweb.data.layout.LocalIndexGoogleMapsInfo;
import org.xissweb.data.layout.LocalIndexInfo;
import org.xissweb.data.layout.LocalIndexStandardInfo;
import org.xissweb.data.layout.LocationOnMapInfo;
import org.xissweb.data.layout.NavigationBarInfo;
import org.xissweb.data.layout.PageDecorationInfo;
import org.xissweb.data.layout.SkinInfo;
import org.xissweb.data.layout.SlideShowLayoutInfo;
import org.xissweb.data.layout.ThumbnailsInfo;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.data.layout.TransitionInfo;
import org.xissweb.data.layout.xml.LayoutSchema;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FullLayoutDeserialiser
extends DefaultHandler
implements LayoutSchema {
    private SlideShowLayoutInfo layout = null;
    private ArrayList arrangements = new ArrayList();
    private PageDecorationInfo pageDecoration = null;
    private Document pageDoc = null;
    private Element currentElement = null;
    private ImageAreaInfo imageArea = null;
    private Set metadata = null;
    private int imageType;

    public SlideShowLayoutInfo deserialize(File f) {
        try {
            SAXParser parser = XMLHelper.getSAXPerser(this);
            FileInputStream in = new FileInputStream(f);
            parser.parse(new InputSource(in));
            ((InputStream)in).close();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        SlideShowLayoutInfo layoutInfo = this.layout;
        layoutInfo.setFile(f);
        this.layout = null;
        this.arrangements.clear();
        return layoutInfo;
    }

    private ArrangementInfo getCurrentArrangement() {
        return (ArrangementInfo)this.arrangements.get(0);
    }

    private boolean hasCurrentArrangement() {
        return !this.arrangements.isEmpty();
    }

    private void setCurrentArrangement(ArrangementInfo a) {
        this.arrangements.add(0, a);
    }

    private void removeCurrentArrangement() {
        this.arrangements.remove(0);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String str;
        if (this.currentElement != null && (str = new String(ch, start, length)).length() > 0) {
            this.currentElement.appendChild(this.pageDoc.createTextNode(str));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("arrangement")) {
            this.removeCurrentArrangement();
        } else if (this.pageDecoration != null && localName.equals(this.pageDoc.getDocumentElement().getNodeName())) {
            this.currentElement = null;
            this.pageDoc = null;
            this.pageDecoration = null;
        } else if (this.currentElement != null) {
            this.currentElement = (Element)this.currentElement.getParentNode();
        }
        if (localName.startsWith("meta-data")) {
            String[] keys = ImageMetadataHelper.getImageMetaDataKeys(this.imageType);
            boolean[] md = new boolean[keys.length - 3];
            for (int i = 0; i < md.length; ++i) {
                md[i] = this.metadata.contains(keys[i]);
            }
            this.imageArea.setMetadata(md, this.imageType);
            this.metadata = null;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (localName.equals("slideshow-layout")) {
            this.layout = new SlideShowLayoutInfo();
            this.layout.setComment(XMLHelper.getAttributeValue(attributes, "comment"));
            if (XMLHelper.hasAttribute(attributes, "page-width")) {
                this.layout.setPageWidth(XMLHelper.getIntAttributValue(attributes, "page-width"));
            }
        } else if (localName.equals("skin")) {
            this.layout.setSkin(FullLayoutDeserialiser.createSkinfInfo(attributes));
        } else if (localName.equals("animation")) {
            this.layout.setAnimation(FullLayoutDeserialiser.createAnimationInfo(attributes));
        } else if (localName.equals("thumbnails-info")) {
            this.layout.setThumbnailsInfo(FullLayoutDeserialiser.createThunailsInfoInfo(attributes));
        } else if (localName.equals("arrangement")) {
            ArrangementInfo arrangInfo = new ArrangementInfo();
            arrangInfo.setOrientation(XMLHelper.getAttributeValue(attributes, "orientation"));
            if (XMLHelper.hasAttribute(attributes, "width")) {
                arrangInfo.setWidth(XMLHelper.getIntAttributValue(attributes, "width"));
            }
            if (this.hasCurrentArrangement()) {
                this.getCurrentArrangement().getComponents().add(arrangInfo);
            } else {
                this.layout.setArrangement(arrangInfo);
            }
            this.setCurrentArrangement(arrangInfo);
        } else if (localName.equals("navigation-bar")) {
            NavigationBarInfo navBarInfo = new NavigationBarInfo();
            navBarInfo.setType(XMLHelper.getAttributeValue(attributes, "type"));
            this.getCurrentArrangement().getComponents().add(navBarInfo);
        } else if (localName.equals("previous")) {
            ((NavigationBarInfo)this.getCurrentArrangement().getLastComponent()).setPrevious(true);
        } else if (localName.equals("backward")) {
            ((NavigationBarInfo)this.getCurrentArrangement().getLastComponent()).setBackward(true);
        } else if (localName.equals("init")) {
            ((NavigationBarInfo)this.getCurrentArrangement().getLastComponent()).setInit(true);
        } else if (localName.equals("forward")) {
            ((NavigationBarInfo)this.getCurrentArrangement().getLastComponent()).setForward(true);
        } else if (localName.equals("next")) {
            ((NavigationBarInfo)this.getCurrentArrangement().getLastComponent()).setNext(true);
        } else if (localName.equals("thumbnails")) {
            ThumbnailsInfo thumbInfo = new ThumbnailsInfo();
            if (XMLHelper.hasAttribute(attributes, "width")) {
                thumbInfo.setWidth(XMLHelper.getIntAttributValue(attributes, "width"));
            }
            thumbInfo.setRange(XMLHelper.getIntAttributValue(attributes, "range"));
            this.getCurrentArrangement().getComponents().add(thumbInfo);
        } else if (localName.equals("image-area")) {
            this.imageArea = new ImageAreaInfo();
            this.imageArea.setWidth(XMLHelper.getIntAttributValue(attributes, "width"));
            this.imageArea.setHeight(XMLHelper.getIntAttributValue(attributes, "height"));
            this.getCurrentArrangement().getComponents().add(this.imageArea);
        } else if (localName.equals("comment")) {
            this.imageArea.setCommentPosition(XMLHelper.getAttributeValue(attributes, "position"));
            this.imageArea.setNumberFormat(XMLHelper.getAttributeValue(attributes, "number-format", "@#/%+"));
        } else if (localName.equals("header")) {
            this.layout.setHeader(this.initPageDecorationElement("Header"));
        } else if (localName.equals("left-margin")) {
            this.layout.setLeftMargin(this.initPageDecorationElement("Left Margin"));
        } else if (localName.equals("right-margin")) {
            this.layout.setRightMargin(this.initPageDecorationElement("Right Margin"));
        } else if (localName.equals("footer")) {
            this.layout.setFooter(this.initPageDecorationElement("Footer"));
        } else if (this.pageDecoration != null) {
            Element e = this.pageDoc.createElement(localName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                e.setAttribute(attributes.getLocalName(i), attributes.getValue(i));
            }
            this.currentElement.appendChild(e);
            this.currentElement = e;
        } else if (localName.equals("image-location-on-map")) {
            this.imageArea.setLocationOnMap(FullLayoutDeserialiser.createLocationOnMapsInfo(attributes));
        } else if (localName.equals("meta-data")) {
            this.imageArea.setMetaDataPosition(XMLHelper.getAttributeValue(attributes, "position"));
            this.imageType = 0;
            this.metadata = new HashSet();
        } else if (localName.equals("meta-data-argentic") || localName.equals("meta-data-film")) {
            this.imageType = 1;
            this.metadata = new HashSet();
        } else if (localName.equals("meta-data-processing")) {
            this.imageType = 2;
            this.metadata = new HashSet();
        } else if (localName.equals("meta-data-unknown")) {
            this.imageType = 3;
            this.metadata = new HashSet();
        } else if (this.metadata != null) {
            if (localName.equals("iso-equivalent")) {
                this.metadata.add("iso");
            } else {
                this.metadata.add(localName);
            }
        } else if ("local-index-standard".equals(localName)) {
            this.imageArea.setLocalIndexInfo(FullLayoutDeserialiser.createLocalIndexSrandard(attributes));
        } else if ("local-index-google-maps".equals(localName)) {
            this.imageArea.setLocalIndexInfo(FullLayoutDeserialiser.createLocalIndexGoogleMaps(attributes));
        }
    }

    static SkinInfo createSkinfInfo(Attributes attributes) {
        SkinInfo skInfo = new SkinInfo();
        skInfo.setSkinName(XMLHelper.getAttributeValue(attributes, "name"));
        skInfo.setPath(XMLHelper.getAttributeValue(attributes, "path"));
        return skInfo;
    }

    static ThumbnailsInfoInfo createThunailsInfoInfo(Attributes attributes) {
        ThumbnailsInfoInfo thumbIInfo = new ThumbnailsInfoInfo();
        thumbIInfo.setQuality(XMLHelper.getAttributeValue(attributes, "quality", "high"));
        thumbIInfo.setShape(XMLHelper.getAttributeValue(attributes, "shape", "rectangle"));
        thumbIInfo.setSize(XMLHelper.getIntAttributValue(attributes, "size"));
        thumbIInfo.setUnit(XMLHelper.getAttributeValue(attributes, "unit"));
        return thumbIInfo;
    }

    static LocalIndexInfo createLocalIndexGoogleMaps(Attributes attributes) {
        LocalIndexGoogleMapsInfo iInfo = (LocalIndexGoogleMapsInfo)LocalIndexInfo.createInstance("google maps");
        iInfo.setWidth(Integer.parseInt(attributes.getValue("width")));
        iInfo.setHeight(Integer.parseInt(attributes.getValue("height")));
        iInfo.setGMapsInfo(FullLayoutDeserialiser.createGoogleMapsInfo(attributes));
        return iInfo;
    }

    static LocationOnMapInfo createLocationOnMapsInfo(Attributes attributes) {
        LocationOnMapInfo locationOnMapInfo = new LocationOnMapInfo();
        locationOnMapInfo.setMapInfo(FullLayoutDeserialiser.createGoogleMapsInfo(attributes));
        String fading = attributes.getValue("fading");
        locationOnMapInfo.setTransition(FullLayoutDeserialiser.createTransitionInfo(fading));
        String zoomLevel = attributes.getValue("zoom-level");
        locationOnMapInfo.setZoomLevel(10);
        if (zoomLevel != null) {
            locationOnMapInfo.setZoomLevel(Integer.parseInt(zoomLevel));
        }
        return locationOnMapInfo;
    }

    static AnimationInfo createAnimationInfo(Attributes attributes) {
        AnimationInfo animation = new AnimationInfo();
        animation.setKind(FullLayoutDeserialiser.toAnimationKindValue(attributes.getValue("kind")));
        animation.setWaitScreenSize(FullLayoutDeserialiser.toAnimationWaitImageSizeValue(attributes.getValue("wait-screen-size")));
        animation.setTransition(FullLayoutDeserialiser.createTransitionInfo(attributes.getValue("transition")));
        String v = attributes.getValue("control-panel");
        if (v != null) {
            animation.setControlPanel(XMLHelper.toBoolean(v));
        }
        return animation;
    }

    static int toAnimationKindValue(String value) {
        if ("scroll".equals(value) || "horizontal scroll".equals(value)) {
            return 2;
        }
        if ("vertical scroll".equals(value)) {
            return 3;
        }
        if ("superimposed fade".equals(value)) {
            return 1;
        }
        return 0;
    }

    static int toAnimationWaitImageSizeValue(String value) {
        if ("full screen".equals(value)) {
            return 2;
        }
        if ("none".equals(value)) {
            return 0;
        }
        return 1;
    }

    static TransitionInfo createTransitionInfo(String value) {
        if ("slow".equals(value)) {
            return new TransitionInfo(1);
        }
        if ("fast".equals(value)) {
            return new TransitionInfo(2);
        }
        if ("none".equals(value)) {
            return new TransitionInfo(0);
        }
        return new TransitionInfo(3);
    }

    static GoogleMapsInfo createGoogleMapsInfo(Attributes attributes) {
        GoogleMapsInfo gMapsInfo = new GoogleMapsInfo();
        gMapsInfo.setThumbnailMarker(XMLHelper.toBoolean(attributes.getValue("thumbnail-marker")));
        gMapsInfo.setMapTypeIndex(Integer.parseInt(attributes.getValue("map-type")));
        gMapsInfo.setMapTypeControl(XMLHelper.toBoolean(attributes.getValue("map-control")));
        gMapsInfo.setZoomControl(XMLHelper.toBoolean(attributes.getValue("zoom-control")));
        gMapsInfo.setOverviewControl(XMLHelper.toBoolean(attributes.getValue("overview-control")));
        return gMapsInfo;
    }

    static LocalIndexInfo createLocalIndexSrandard(Attributes attributes) {
        LocalIndexStandardInfo iInfo = (LocalIndexStandardInfo)LocalIndexInfo.createInstance("standard");
        iInfo.setWidth(Integer.parseInt(attributes.getValue("width")));
        iInfo.setHeight(Integer.parseInt(attributes.getValue("height")));
        iInfo.setDisplayDescription(XMLHelper.toBoolean(attributes.getValue("description")));
        iInfo.setDisplayExplanation(XMLHelper.toBoolean(attributes.getValue("explanation")));
        return iInfo;
    }

    private PageDecorationInfo initPageDecorationElement(String decorationType) {
        this.pageDecoration = new PageDecorationInfo(decorationType);
        this.pageDoc = this.pageDecoration.getContent();
        this.currentElement = this.pageDoc.getDocumentElement();
        return this.pageDecoration;
    }
}

