/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.xissweb.About;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWebUI;
import org.xissweb.i18n.TextDisplayer;

public class AboutDialog
extends JDialog
implements ComponentListener {
    private static final long serialVersionUID = -3800515658923474452L;
    private static final String PREFS_ID = "org.xissweb.gui.AboutDialog";
    private static final String BIG_LOGO_ICON = "/images/about/bigLogo.png";
    private static final String ABOUT_X_KEY = "about.x";
    private static final String ABOUT_Y_KEY = "about.y";
    private JPanel jContentPane = null;
    private JButton okButton = null;
    private JLabel versionLabel = null;
    private JLabel webSiteLabel = null;
    private JPanel infoPanel = null;
    private JPanel controlPanel = null;
    private JLabel xisswebIconLabel = null;
    private JLabel builtcopyrightLabel = null;
    static /* synthetic */ Class class$org$xissweb$gui$AboutDialog;

    public AboutDialog(JFrame parent) {
        super(parent, "Xiss Web... " + TextDisplayer.getString("about", class$org$xissweb$gui$AboutDialog == null ? (class$org$xissweb$gui$AboutDialog = AboutDialog.class$(PREFS_ID)) : class$org$xissweb$gui$AboutDialog), true);
        this.initialize();
        this.applyPreferences();
        this.addComponentListener(this);
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent e) {
        this.savePreferences();
    }

    public void componentResized(ComponentEvent arg0) {
    }

    public void componentShown(ComponentEvent arg0) {
    }

    private void applyPreferences() {
        int x = Main.preferences.getInt(ABOUT_X_KEY, PREFS_ID, this.getX());
        int y = Main.preferences.getInt(ABOUT_Y_KEY, PREFS_ID, this.getY());
        this.setLocation(x, y);
    }

    private void savePreferences() {
        Main.preferences.putInt(ABOUT_X_KEY, PREFS_ID, this.getX());
        Main.preferences.putInt(ABOUT_Y_KEY, PREFS_ID, this.getY());
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 400, 330));
        this.setForeground(XissWebUI.darkColor);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getInfoPanel(), "Center");
            this.jContentPane.add((Component)this.getControlPanel(), "South");
        }
        return this.jContentPane;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AboutDialog.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.anchor = 10;
            gridBagConstraints21.gridheight = 1;
            gridBagConstraints21.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints21.gridy = 3;
            this.builtcopyrightLabel = new JLabel();
            this.builtcopyrightLabel.setFont(XissWebUI.plainFont);
            this.builtcopyrightLabel.setText(About.getBuildDate() + " " + About.getLegal());
            this.xisswebIconLabel = new JLabel();
            this.xisswebIconLabel.setIcon(new ImageIcon(this.getClass().getResource(BIG_LOGO_ICON)));
            this.versionLabel = new JLabel();
            this.versionLabel.setFont(XissWebUI.labelBoldFont);
            this.versionLabel.setText("Xiss Web " + About.getVersion());
            this.versionLabel.setHorizontalTextPosition(0);
            this.versionLabel.setVerticalAlignment(0);
            this.versionLabel.setVerticalTextPosition(3);
            this.webSiteLabel = new JLabel();
            this.webSiteLabel.setHorizontalTextPosition(0);
            this.webSiteLabel.setHorizontalAlignment(0);
            this.webSiteLabel.setFont(new Font("Arial", 0, 14));
            this.webSiteLabel.setForeground(new Color(0, 56, 127));
            this.webSiteLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Main.get().openURL(About.getWebSiteUrl());
                }

                public void mouseExited(MouseEvent e) {
                    e.getComponent().setForeground(XissWebUI.mediumDarkColor);
                    e.getComponent().setCursor(new Cursor(0));
                }

                public void mouseEntered(MouseEvent e) {
                    e.getComponent().setForeground(XissWebUI.lightColor);
                    e.getComponent().setCursor(new Cursor(12));
                }
            });
            this.webSiteLabel.setText("<html><u>" + About.getWebSiteUrl() + "</u></html>");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridwidth = 1;
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 0;
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new GridBagLayout());
            this.infoPanel.add((Component)this.xisswebIconLabel, gridBagConstraints);
            this.infoPanel.add((Component)this.versionLabel, gridBagConstraints1);
            this.infoPanel.add((Component)this.webSiteLabel, gridBagConstraints3);
            this.infoPanel.add((Component)this.builtcopyrightLabel, gridBagConstraints21);
        }
        return this.infoPanel;
    }

    private JPanel getControlPanel() {
        if (this.controlPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setVgap(5);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = -1;
            gridBagConstraints2.ipady = 244;
            gridBagConstraints2.gridy = -1;
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(flowLayout);
            this.controlPanel.add((Component)this.getOkButton(), null);
        }
        return this.controlPanel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

