/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.xissweb.gui.XissWeb;

public class ProjectFileTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 2427293373637423430L;
    private static final DataFlavor fileFlavor = DataFlavor.javaFileListFlavor;
    private XissWeb xissWeb;

    public ProjectFileTransferHandler(XissWeb xissWeb) {
        this.xissWeb = xissWeb;
    }

    public boolean importData(JComponent c, Transferable t) {
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                List files = (List)t.getTransferData(fileFlavor);
                if (files.size() == 1 && ((File)files.get(0)).isDirectory()) {
                    this.xissWeb.openProject((File)files.get(0));
                    return true;
                }
                return false;
            }
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
        }
        catch (IOException ieo) {
            System.out.println("importData: I/O exception");
        }
        return false;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasFileFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!fileFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

