/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.data.content.HtmlContentEnabled;
import org.xissweb.data.content.HtmlContentHelper;
import org.xissweb.data.content.ImageInfo;
import org.xissweb.data.content.SectionInfo;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.SlideShowRefInfo;
import org.xissweb.data.layout.ThumbnailsInfoInfo;
import org.xissweb.data.layout.xml.MinimalLayoutDeserializer;
import org.xissweb.gui.XissWebUI;
import org.xissweb.project.SlideShowProject;
import org.xissweb.xml.XMLHelper;

public abstract class ContentEditorHelper {
    public static final int sectionsOffset = 1;
    static final String CONTENT_PREVIOUS_ICON = "/images/content/previous.png";
    static final String CONTENT_NEXT_ICON = "/images/content/next.png";
    static final String CONTENT_SECTION_ICON = "/images/content/section.png";
    static final String CONTENT_INFO_ICON = "/images/content/info.png";
    static final String PROJECT_ROOT_ICON = "/images/file/project-directory.png";

    private ContentEditorHelper() {
    }

    public static ThumbnailsInfoInfo getThumbnailsInfo(SlideShowProject project, File contentFile) {
        File fLayout = project.layoutFileForSlideshow(contentFile.getParentFile());
        MinimalLayoutDeserializer deserializer = new MinimalLayoutDeserializer();
        return deserializer.deserialize(fLayout).getThumbnailsInfo();
    }

    public static int sectionsOffset(SlideShowContentInfo info) {
        return 1 + info.linkCount();
    }

    public static boolean isImageInfoElement(DefaultMutableTreeNode node) {
        return node.getUserObject() instanceof ImageInfo;
    }

    public static boolean isImageInfoElements(ArrayList nodes) {
        boolean result = true;
        Iterator i = nodes.iterator();
        while (i.hasNext() && result) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.next();
            if (ContentEditorHelper.isImageInfoElement(node)) continue;
            result = false;
        }
        return result;
    }

    public static boolean isInfoElement(DefaultMutableTreeNode node) {
        return "INFO".equals(node.getUserObject());
    }

    public static boolean isTitleElement(DefaultMutableTreeNode node) {
        return node.getUserObject() instanceof SlideShowContentInfo.Title;
    }

    public static boolean isDescriptionElement(DefaultMutableTreeNode node) {
        return node.getUserObject() instanceof SlideShowContentInfo.Description;
    }

    public static boolean isLinkElement(DefaultMutableTreeNode node) {
        return node.getUserObject() instanceof SlideShowRefInfo;
    }

    public static boolean isRootElement(DefaultMutableTreeNode node) {
        return node.getUserObject() instanceof SlideShowContentInfo;
    }

    public static boolean isSectionElement(DefaultMutableTreeNode node) {
        return node.getUserObject() instanceof SectionInfo;
    }

    public static boolean isSectionElements(ArrayList nodes) {
        boolean result = true;
        Iterator i = nodes.iterator();
        while (i.hasNext() && result) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)i.next();
            if (ContentEditorHelper.isSectionElement(node)) continue;
            result = false;
        }
        return result;
    }

    public static String getCommentValue(ImageInfo iInfo, String encoding, boolean encodeOut) {
        if (!iInfo.isHtmlContent()) {
            return iInfo.getComment();
        }
        return XMLHelper.valueOf(iInfo.getHtmlComment(), encoding, encodeOut);
    }

    public static String getDescriptionValue(SlideShowContentInfo.Description description, String encoding, boolean encodeOut) {
        if (!description.isHtmlContent()) {
            return description.getStringValue();
        }
        return XMLHelper.valueOf(description.getHtmlValue(), encoding, encodeOut);
    }

    public static String getNodeTextValue(DefaultMutableTreeNode node, String encoding, boolean encodeOut) {
        String value = null;
        if (ContentEditorHelper.isImageInfoElement(node)) {
            value = ContentEditorHelper.getCommentValue((ImageInfo)node.getUserObject(), encoding, encodeOut);
        } else if (ContentEditorHelper.isDescriptionElement(node)) {
            value = ContentEditorHelper.getDescriptionValue((SlideShowContentInfo.Description)node.getUserObject(), encoding, encodeOut);
        } else if (ContentEditorHelper.isTitleElement(node)) {
            value = ((SlideShowContentInfo.Title)node.getUserObject()).getValue();
        } else if (ContentEditorHelper.isLinkElement(node)) {
            value = ((SlideShowRefInfo)node.getUserObject()).getText();
        } else if (ContentEditorHelper.isSectionElement(node)) {
            value = ((SectionInfo)node.getUserObject()).getTitle();
        } else if (ContentEditorHelper.isRootElement(node)) {
            value = ((SlideShowContentInfo)node.getUserObject()).toString();
        }
        return value == null ? node.getUserObject().toString() : value;
    }

    public static ImageIcon getContentElementIcon(DefaultMutableTreeNode node) {
        if (node.isRoot()) {
            return XissWebUI.getIcon(PROJECT_ROOT_ICON);
        }
        if (ContentEditorHelper.isInfoElement(node)) {
            return XissWebUI.getIcon(CONTENT_INFO_ICON);
        }
        if (ContentEditorHelper.isSectionElement(node)) {
            return XissWebUI.getIcon(CONTENT_SECTION_ICON);
        }
        if (ContentEditorHelper.isLinkElement(node)) {
            if (((SlideShowRefInfo)node.getUserObject()).isNextLink()) {
                return XissWebUI.getIcon(CONTENT_NEXT_ICON);
            }
            return XissWebUI.getIcon(CONTENT_PREVIOUS_ICON);
        }
        return null;
    }

    public static boolean isHtmlContent(DefaultMutableTreeNode node) {
        if (node.getUserObject() instanceof HtmlContentEnabled) {
            return ((HtmlContentEnabled)node.getUserObject()).isHtmlContent();
        }
        return false;
    }

    public static boolean updateEditedText(DefaultMutableTreeNode node, String data, String value, boolean isHtml, String encoding) {
        HtmlContentEnabled html;
        if (node.getUserObject() instanceof HtmlContentEnabled ? (html = (HtmlContentEnabled)node.getUserObject()).isHtmlContent() == isHtml && data.equals(value) : data.equals(value)) {
            return false;
        }
        if (ContentEditorHelper.isImageInfoElement(node)) {
            ImageInfo iInfo = (ImageInfo)node.getUserObject();
            if (isHtml) {
                iInfo.setHtmlValue(HtmlContentHelper.toDocument("htmlComment", value, encoding));
            } else {
                iInfo.setStringValue(value);
            }
        } else if (ContentEditorHelper.isSectionElement(node)) {
            SectionInfo section = (SectionInfo)node.getUserObject();
            section.setTitle(value);
        } else if (ContentEditorHelper.isTitleElement(node)) {
            SlideShowContentInfo.Title title = (SlideShowContentInfo.Title)node.getUserObject();
            title.setValue(value);
        } else if (ContentEditorHelper.isDescriptionElement(node)) {
            SlideShowContentInfo.Description description = (SlideShowContentInfo.Description)node.getUserObject();
            if (isHtml) {
                description.setHtmlValue(HtmlContentHelper.toDocument("htmlDescription", value, encoding));
            } else {
                description.setStringValue(value);
            }
        } else if (ContentEditorHelper.isLinkElement(node)) {
            SlideShowRefInfo link = (SlideShowRefInfo)node.getUserObject();
            link.setText(value);
        }
        return true;
    }
}

