/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.content.links;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.gui.content.links.LinksManagerDialog;
import org.xissweb.gui.content.links.LinksManagerTreeModel;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.gui.util.tree.TreeModel;

public class LinksManagerTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -8178892978929846910L;
    DataFlavor nodesFlavor;
    String nodesFlavorType = "application/x-java-jvm-local-objectref;class=java.lang.Integer";
    LinksManagerDialog linksDialog;
    JTree source = null;
    DefaultMutableTreeNode originNode = null;
    int addIndex = -1;
    int addCount = 0;

    public LinksManagerTransferHandler(LinksManagerDialog linksDialog) {
        this.linksDialog = linksDialog;
        try {
            this.nodesFlavor = new DataFlavor(this.nodesFlavorType);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ListContentTransferHandler: unable to create data flavor");
            e.printStackTrace();
        }
    }

    public boolean importData(JComponent c, Transferable t) {
        JTree target = null;
        Integer from = null;
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        try {
            target = (JTree)c;
            if (!this.hasNodeFlavor(t.getTransferDataFlavors())) {
                return false;
            }
            from = (Integer)t.getTransferData(this.nodesFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            System.out.println("importData: unsupported data flavor");
            return false;
        }
        catch (IOException e) {
            System.out.println("importData: I/O error during transfert");
            return false;
        }
        DefaultMutableTreeNode to = TreeHelper.getSelectedNode(target);
        boolean result = false;
        result = this.source.equals(target) && (to == this.originNode || this.insertOnSamePlace(to, this.originNode)) ? false : this.doImportData(target, from, to);
        if (!result) {
            this.originNode = null;
        }
        return result;
    }

    private boolean insertOnSamePlace(DefaultMutableTreeNode to, DefaultMutableTreeNode origin) {
        int i = to.isRoot() ? 0 : to.getParent().getIndex(to);
        return i == origin.getParent().getIndex(origin);
    }

    private boolean doImportData(JTree tree, Integer from, DefaultMutableTreeNode to) {
        boolean importDone = false;
        if (to.isRoot()) {
            this.insertData(tree, to, from, 0);
            importDone = true;
        } else if (to.getUserObject() instanceof SlideShowContentInfo) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)to.getParent();
            this.insertData(tree, parent, from, parent.getIndex(to) + 1);
            importDone = true;
        }
        return importDone;
    }

    private void insertData(JTree tree, DefaultMutableTreeNode parent, Integer index, int destIndex) {
        int originIndex = index;
        LinksManagerTreeModel model = (LinksManagerTreeModel)tree.getModel();
        SlideShowContentInfo current = this.linksDialog.contentInfos[originIndex];
        parent.insert(model.createNode(current), destIndex);
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        if (action == 2 && this.originNode != null) {
            JTree tree = (JTree)c;
            TreeModel treeModel = (TreeModel)tree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
            root.remove(this.originNode);
            for (int i = 0; i < this.linksDialog.contentInfos.length; ++i) {
                this.linksDialog.contentInfos[i] = (SlideShowContentInfo)((DefaultMutableTreeNode)root.getChildAt(i)).getUserObject();
            }
            treeModel.nodeStructureChanged(root);
            TreeHelper.expandAll(tree);
            this.originNode = null;
            this.linksDialog.doUpdateAllLinks();
        }
    }

    private boolean hasNodeFlavor(DataFlavor[] flavors) {
        if (this.nodesFlavor == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(this.nodesFlavor)) continue;
            return true;
        }
        return false;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasNodeFlavor(flavors);
    }

    protected Transferable createTransferable(JComponent c) {
        TreeNodeTransferable transf = null;
        this.source = (JTree)c;
        this.originNode = TreeHelper.getSelectedNode(this.source);
        if (this.originNode != null) {
            transf = new TreeNodeTransferable(new Integer(this.originNode.getParent().getIndex(this.originNode)));
        }
        return transf;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    public class TreeNodeTransferable
    implements Transferable {
        Integer data;

        public TreeNodeTransferable(Integer node) {
            this.data = node;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{LinksManagerTransferHandler.this.nodesFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return LinksManagerTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

