/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.editor.html;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.Editor;

public class HtmlEditorHelper {
    public static final String A_START = "<a href=\"\">";
    public static final String A_END = "</a>";
    public static final String BR_START = "<br/>";
    public static final String BR_END = "";
    public static final String DIV_START = "<div>";
    public static final String DIV_END = "</div>";
    public static final String EM_START = "<em>";
    public static final String EM_END = "</em>";
    public static final String IMG_START = "<img src=\"\" alt=\"\"/>";
    public static final String IMG_END = "";
    public static final String OL_LI_START = "<ol><li>";
    public static final String OL_LI_END = "</li></ol>";
    public static final String P_START = "<p>";
    public static final String P_END = "</p>";
    public static final String SPAN_START = "<span>";
    public static final String SPAN_END = "</span>";
    public static final String STRONG_START = "<strong>";
    public static final String STRONG_END = "</strong>";
    public static final String UL_LI_START = "<ul><li>";
    public static final String UL_LI_END = "</li></ul>";
    public static final String[] startElements = new String[]{"<a href=\"\">", "<br/>", "<div>", "<em>", "<img src=\"\" alt=\"\"/>", "<ol><li>", "<p>", "<span>", "<strong>", "<ul><li>"};
    public static final String[] endElements = new String[]{"</a>", "", "</div>", "</em>", "", "</li></ol>", "</p>", "</span>", "</strong>", "</li></ul>"};
    private Editor editor;
    private JTextComponent textComponent;
    private JPopupMenu popupMenu;
    private Font font;

    public HtmlEditorHelper(Editor editor, JTextComponent textPane) {
        this.editor = editor;
        this.textComponent = textPane;
        this.font = textPane.getFont().deriveFont(textPane.getFont().getSize2D() - 1.0f);
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            for (int i = 0; i < startElements.length; ++i) {
                final int j = i;
                JMenuItem item = new JMenuItem();
                item.setFont(this.font);
                item.setBackground(XissWebUI.paleColor);
                item.setText(startElements[i] + endElements[i]);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        HtmlEditorHelper.this.performeInsertElement(j);
                    }
                });
                this.popupMenu.add(item);
            }
        }
        return this.popupMenu;
    }

    public void showPopupMenu(MouseEvent event) {
        this.getPopupMenu().show(this.textComponent, event.getX(), event.getY());
    }

    void performeInsertElement(int i) {
        String selection = this.textComponent.getSelectedText();
        if (selection == null) {
            selection = "";
        }
        this.textComponent.replaceSelection(startElements[i] + selection + endElements[i]);
        this.editor.modified(false);
    }
}

