/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.editor.text;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.xerces.parsers.SAXParser;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissEditorManager;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.editor.Editor;
import org.xissweb.gui.editor.EditorsContainer;
import org.xissweb.gui.editor.ValidProcessHandler;
import org.xissweb.gui.editor.text.XmlTextEditable;
import org.xissweb.gui.editor.valid.EditorValidHandler;
import org.xissweb.gui.file.FileManager;
import org.xissweb.project.SlideShowProperties;
import org.xissweb.xml.XMLHelper;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TextEditor
extends JScrollPane
implements Editor,
ErrorHandler {
    private static final long serialVersionUID = -7504171280808574899L;
    private static final Font textFont = XissWebUI.textAreaFont;
    private static Hashtable textEditableDocs = new Hashtable();
    private File contentFile;
    private JTextPane textComponent = null;
    private boolean contentModified;
    private String encoding = null;
    private EditorsContainer editorsContainer;
    private ValidProcessHandler handler = new EditorValidHandler(this);
    private String documentContent = null;
    private boolean documentValid = true;
    private boolean valid;

    public static void registerTextEditable(String fileName, XmlTextEditable textEditable) {
        textEditableDocs.put(fileName, textEditable);
    }

    public static XmlTextEditable getTextEditable(String fileName) {
        return (XmlTextEditable)textEditableDocs.get(fileName);
    }

    public static boolean isTextEditable(String fileName) {
        return textEditableDocs.get(fileName) != null;
    }

    public TextEditor() {
        this.initialize();
    }

    public boolean isReadOnly() {
        return !this.contentFile.canWrite();
    }

    public void setEditorsContainer(EditorsContainer editorsContainer) {
        this.editorsContainer = editorsContainer;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        File f = (File)document;
        if (!f.exists()) {
            throw new DocumentException(f.getAbsolutePath());
        }
        this.contentFile = f;
        if (XissEditorManager.isMarkupFiles(this.contentFile)) {
            this.encoding = XMLHelper.getEncoding(this.contentFile);
        }
    }

    public Object getEditedDocument() {
        return this.contentFile;
    }

    public boolean isDocumentValid() {
        return this.documentValid;
    }

    public void edit() {
        this.textComponent.setEditable(!this.isReadOnly());
        this.load();
        this.contentModified = false;
        this.documentValid = true;
        this.editorsContainer.editorStatusChange(this, 0);
        boolean valid = this.validateContent();
        if (valid != this.documentValid) {
            this.documentValid = valid;
            this.editorsContainer.editorStatusChange(this, this.documentValid ? 5 : 6);
        }
    }

    public void edit(Object arg) {
        this.edit();
    }

    public ValidProcessHandler getValidProcessHandler() {
        return this.handler;
    }

    public void setValidProcessHandler(ValidProcessHandler handler) {
        this.handler = handler;
    }

    private void load() {
        try {
            FileInputStream in = new FileInputStream(this.contentFile);
            if (this.encoding != null) {
                InputStreamReader reader = new InputStreamReader((InputStream)in, this.encoding);
                this.textComponent.read(reader, null);
                reader.close();
            } else {
                this.textComponent.read((InputStream)in, (Object)null);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.documentContent = this.textComponent.getText();
    }

    public int save() {
        int saveStatus = 0;
        try {
            this.encoding = XMLHelper.getEncoding(this.textComponent.getText());
            if (this.encoding != null) {
                FileOutputStream out = new FileOutputStream(this.contentFile);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, this.encoding);
                this.textComponent.write(writer);
                ((Writer)writer).close();
                out.close();
            } else {
                FileWriter writer = new FileWriter(this.contentFile);
                this.textComponent.write(writer);
                ((Writer)writer).close();
            }
        }
        catch (IOException e) {
            XissWebUI.showErrorMessage(e, "");
            saveStatus = 1;
        }
        if (saveStatus == 0) {
            this.documentContent = this.textComponent.getText();
            this.contentModified = false;
            this.editorsContainer.editorStatusChange(this, 3);
        }
        return saveStatus;
    }

    private File getXsdFile() {
        XmlTextEditable txtEd = TextEditor.getTextEditable(this.contentFile.getName());
        String fileName = txtEd == null ? null : txtEd.getXmlSchema();
        return fileName == null ? null : new File(SlideShowProperties.getRsrcDir(), "xml" + File.separator + fileName);
    }

    private String getDocumentRootTagName() {
        XmlTextEditable txtEd = TextEditor.getTextEditable(this.contentFile.getName());
        return txtEd == null ? null : txtEd.getXmlRootElement();
    }

    boolean validateContent() {
        if (!XissEditorManager.isMarkupFiles(this.contentFile)) {
            return true;
        }
        this.handler.startValidating(this);
        this.valid = true;
        File xsdF = this.getXsdFile();
        boolean hasXsd = xsdF != null && xsdF.exists();
        String value = hasXsd ? XMLHelper.addSchemaInfo(this.textComponent.getText(), this.getDocumentRootTagName(), xsdF) : this.textComponent.getText();
        try {
            SAXParser parser = new SAXParser();
            if (hasXsd) {
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            parser.setErrorHandler((ErrorHandler)this);
            StringReader reader = new StringReader(value);
            InputSource in = new InputSource(reader);
            parser.parse(in);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.valid;
    }

    public void error(SAXParseException e) throws SAXException {
        this.handler.validError(this, e);
        this.valid = false;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.handler.validFatalError(this, e);
        this.valid = false;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.handler.validWarning(this, e);
        this.valid = false;
    }

    public void cancel() {
        this.load();
        this.contentModified = false;
        int status = 2;
        this.editorsContainer.editorStatusChange(this, status);
        boolean valid = this.validateContent();
        if (valid != this.documentValid) {
            this.documentValid = valid;
            this.editorsContainer.editorStatusChange(this, this.documentValid ? 5 : 6);
        }
    }

    public void reload() {
        if (!this.contentModified) {
            this.load();
        }
    }

    public String getDocumentName() {
        return FileHelper.relativePath((File)Main.get().getCurrentProject().getSrcDirectory(), (File)this.contentFile);
    }

    public boolean hasDocumentModified() {
        return this.contentModified;
    }

    public Component getEditorGuiComponent() {
        return this;
    }

    public Icon getIcon() {
        return FileManager.geFileIcon(this.contentFile);
    }

    public JMenuItem[] getMenuItems() {
        return null;
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setViewportView(this.getTextComponent());
    }

    private JTextPane getTextComponent() {
        if (this.textComponent == null) {
            this.textComponent = new JTextPane();
            this.textComponent.setFont(textFont);
            this.textComponent.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent e) {
                    TextEditor.this.modified(!TextEditor.this.validateContent());
                }
            });
            this.textComponent.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    TextEditor.this.onKeyTyped(e);
                }
            });
        }
        return this.textComponent;
    }

    void onKeyTyped(KeyEvent e) {
        if (e.getModifiers() != 2 && e.getModifiers() != 3) {
            this.modified(!this.validateContent());
        }
    }

    public void modified(boolean error) {
        boolean valid;
        boolean modified;
        boolean bl = modified = !this.textComponent.getText().equals(this.documentContent);
        if (this.contentModified != modified) {
            this.contentModified = modified;
            this.editorsContainer.editorStatusChange(this, this.contentModified ? 1 : 2);
        }
        boolean bl2 = valid = !error;
        if (this.documentValid != valid) {
            this.documentValid = valid;
            this.editorsContainer.editorStatusChange(this, valid ? 5 : 6);
        }
    }
}

