/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.layout.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.xissweb.data.layout.GoogleMapsInfo;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.editor.DocumentException;
import org.xissweb.gui.layout.LayoutEditor;
import org.xissweb.gui.layout.editor.AbstractLayoutElementEditor;
import org.xissweb.gui.layout.editor.GoogleMapsPreview;
import org.xissweb.i18n.TextDisplayManager;

public class GoogleMapsInfoEditor
extends AbstractLayoutElementEditor {
    private static final long serialVersionUID = 4489494345135300017L;
    private static final String MARKER_DEFAULT = "/images/layout/googlemaps/markerDefault.png";
    private static final String MARKER_ICON = "/images/layout/googlemaps/markerIcon.png";
    private static final String MAP_NORMAL = "/images/layout/googlemaps/mapNormal.jpg";
    private static final String MAP_SATELLITE = "/images/layout/googlemaps/mapSatellite.jpg";
    private static final String MAP_HYBRID = "/images/layout/googlemaps/mapHybrid.jpg";
    private static final String MAP_PHYSICAL = "/images/layout/googlemaps/mapPhysical.jpg";
    private static final String CONTROL_TYPES = "/images/layout/googlemaps/controlTypes.jpg";
    private static final String CONTROL_ZOOM = "/images/layout/googlemaps/controlZoom.png";
    private static final String CONTROL_OVERVIEW_NORMAL = "/images/layout/googlemaps/controlOverviewNormal.jpg";
    private static final String CONTROL_OVERVIEW_SATELLITE = "/images/layout/googlemaps/controlOverviewSatellite.jpg";
    private static final String CONTROL_OVERVIEW_PHYSICAL = "/images/layout/googlemaps/controlOverviewPhysical.jpg";
    private String[] maps = new String[]{"/images/layout/googlemaps/mapNormal.jpg", "/images/layout/googlemaps/mapSatellite.jpg", "/images/layout/googlemaps/mapHybrid.jpg", "/images/layout/googlemaps/mapPhysical.jpg"};
    private String[] overviews = new String[]{"/images/layout/googlemaps/controlOverviewNormal.jpg", "/images/layout/googlemaps/controlOverviewSatellite.jpg", "/images/layout/googlemaps/controlOverviewSatellite.jpg", "/images/layout/googlemaps/controlOverviewPhysical.jpg"};
    private static final int previewW = 225;
    private static final int previewH = 130;
    private static final int controlMargin = 3;
    private static final int markerX = 148;
    private static final int markerY = 61;
    private GoogleMapsInfo gMapsInfo;
    private JCheckBox mapTypeControlCheckBox = null;
    private JCheckBox zoomControlCheckBox = null;
    private JCheckBox overviewControlCheckBox = null;
    private JPanel previewPanel = null;
    private JRadioButton mapNormalRadioButton = null;
    private JRadioButton mapSatelliteRadioButton = null;
    private JRadioButton mapHybridRadioButton = null;
    private JRadioButton mapPhysicalRadioButton = null;
    private ButtonGroup mapTypesButtonGroup = null;
    private JRadioButton markerDefaultRadioButton = null;
    private JRadioButton markerThumbnailRadioButton = null;
    private ButtonGroup markerButtonGroup = null;
    private JLabel markerLabel = null;
    private JLabel mapTypesLabel = null;

    public GoogleMapsInfoEditor(LayoutEditor mainEditor) {
        super(mainEditor);
        this.textDisplayer = TextDisplayManager.createTextDisplayFor(this.getClass());
        this.initialize();
    }

    void drawPreview(Graphics2D g) {
        Image i;
        int delta = 3;
        g.drawImage(XissWebUI.getIcon(this.maps[this.getMapTypeIndexValue()]).getImage(), 0, 0, null);
        if (this.getZoomControlValue()) {
            g.drawImage(XissWebUI.getIcon(CONTROL_ZOOM).getImage(), delta, delta, null);
        }
        if (this.getMapTypeConrolValue()) {
            i = XissWebUI.getIcon(CONTROL_TYPES).getImage();
            g.drawImage(i, 225 - i.getWidth(null) - delta, delta, null);
        }
        if (this.getOverviewControlValue()) {
            i = XissWebUI.getIcon(this.overviews[this.getMapTypeIndexValue()]).getImage();
            g.drawImage(i, 225 - i.getWidth(null), 130 - i.getHeight(null), null);
        }
        Image marker = XissWebUI.getIcon(this.getThumbnailMarkerValue() ? MARKER_ICON : MARKER_DEFAULT).getImage();
        g.drawImage(marker, 148 - marker.getWidth(null) / 2, 61 - marker.getHeight(null), null);
    }

    private void initialize() {
        GridBagConstraints mapTypeLabelConstraints = new GridBagConstraints();
        mapTypeLabelConstraints.gridy = 1;
        mapTypeLabelConstraints.gridx = 0;
        mapTypeLabelConstraints.insets = new Insets(0, 0, 0, 0);
        mapTypeLabelConstraints.anchor = 13;
        GridBagConstraints markerLabelConstraints = new GridBagConstraints();
        markerLabelConstraints.gridx = 3;
        markerLabelConstraints.gridy = 1;
        markerLabelConstraints.insets = new Insets(0, 0, 0, 0);
        markerLabelConstraints.anchor = 17;
        this.mapTypesLabel = new JLabel();
        this.mapTypesLabel.setText("map.types");
        this.textDisplayer.register(this.mapTypesLabel, "map.types.label");
        this.markerLabel = new JLabel();
        this.markerLabel.setText("marker.label");
        this.textDisplayer.register(this.markerLabel, "marker.label");
        GridBagConstraints markerThumbnailRadioButtonConstraints = new GridBagConstraints();
        markerThumbnailRadioButtonConstraints.gridx = 3;
        markerThumbnailRadioButtonConstraints.gridy = 3;
        markerThumbnailRadioButtonConstraints.anchor = 17;
        GridBagConstraints markerDefaultRadioButtonConstraints = new GridBagConstraints();
        markerDefaultRadioButtonConstraints.gridx = 3;
        markerDefaultRadioButtonConstraints.gridy = 2;
        markerDefaultRadioButtonConstraints.anchor = 17;
        GridBagConstraints mapPhysicalRadioButtonConstraints = new GridBagConstraints();
        mapPhysicalRadioButtonConstraints.gridx = 0;
        mapPhysicalRadioButtonConstraints.gridy = 5;
        mapPhysicalRadioButtonConstraints.anchor = 12;
        GridBagConstraints mapHybridRadioButtonConstraints = new GridBagConstraints();
        mapHybridRadioButtonConstraints.gridx = 0;
        mapHybridRadioButtonConstraints.gridy = 4;
        mapHybridRadioButtonConstraints.anchor = 13;
        GridBagConstraints mapSatelliteRadioButtonConstraints = new GridBagConstraints();
        mapSatelliteRadioButtonConstraints.gridx = 0;
        mapSatelliteRadioButtonConstraints.gridy = 3;
        mapSatelliteRadioButtonConstraints.anchor = 13;
        GridBagConstraints mapNormalRadioButtonConstraints = new GridBagConstraints();
        mapNormalRadioButtonConstraints.gridx = 0;
        mapNormalRadioButtonConstraints.gridy = 2;
        mapNormalRadioButtonConstraints.anchor = 13;
        GridBagConstraints previewPanelConstraints = new GridBagConstraints();
        previewPanelConstraints.gridx = 1;
        previewPanelConstraints.gridy = 1;
        previewPanelConstraints.gridwidth = 2;
        previewPanelConstraints.gridheight = 5;
        previewPanelConstraints.insets = new Insets(0, 5, 0, 5);
        previewPanelConstraints.anchor = 17;
        GridBagConstraints overviewControlCheckBoxConstraints = new GridBagConstraints();
        overviewControlCheckBoxConstraints.gridx = 2;
        overviewControlCheckBoxConstraints.gridy = 6;
        overviewControlCheckBoxConstraints.anchor = 12;
        GridBagConstraints zoomControlCheckBoxConstraints = new GridBagConstraints();
        zoomControlCheckBoxConstraints.gridx = 1;
        zoomControlCheckBoxConstraints.gridy = 0;
        zoomControlCheckBoxConstraints.anchor = 17;
        GridBagConstraints mapTypeControlCheckBoxConstraints = new GridBagConstraints();
        mapTypeControlCheckBoxConstraints.gridx = 2;
        mapTypeControlCheckBoxConstraints.gridy = 0;
        mapTypeControlCheckBoxConstraints.anchor = 13;
        this.getMapTypesButtonGroup();
        this.getMarkerButtonGroup();
        this.add((Component)this.getZoomControlCheckBox(), zoomControlCheckBoxConstraints);
        this.add((Component)this.getMapTypeControlCheckBox(), mapTypeControlCheckBoxConstraints);
        this.add((Component)this.mapTypesLabel, mapTypeLabelConstraints);
        this.add((Component)this.getMapNormalRadioButton(), mapNormalRadioButtonConstraints);
        this.add((Component)this.getMapSatelliteRadioButton(), mapSatelliteRadioButtonConstraints);
        this.add((Component)this.getMapHybridRadioButton(), mapHybridRadioButtonConstraints);
        this.add((Component)this.getMapPhysicalRadioButton(), mapPhysicalRadioButtonConstraints);
        this.add((Component)this.getPreviewPanel(), previewPanelConstraints);
        this.add((Component)this.markerLabel, markerLabelConstraints);
        this.add((Component)this.getMarkerDefaultRadioButton(), markerDefaultRadioButtonConstraints);
        this.add((Component)this.getMarkerThumbnailRadioButton(), markerThumbnailRadioButtonConstraints);
        this.add((Component)this.getOverviewControlCheckBox(), overviewControlCheckBoxConstraints);
    }

    protected void doSave() {
        this.gMapsInfo.setMapTypeIndex(this.getMapTypeIndexValue());
        this.gMapsInfo.setMapTypeControl(this.getMapTypeConrolValue());
        this.gMapsInfo.setZoomControl(this.getZoomControlValue());
        this.gMapsInfo.setOverviewControl(this.getOverviewControlValue());
        this.gMapsInfo.setThumbnailMarker(this.getThumbnailMarkerValue());
    }

    protected void initEdition() {
        switch (this.gMapsInfo.getMapTypeIndex()) {
            case 0: {
                this.mapNormalRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.mapSatelliteRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.mapHybridRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.mapPhysicalRadioButton.setSelected(true);
            }
        }
        this.getMapTypeControlCheckBox().setSelected(this.gMapsInfo.isMapTypeControl());
        this.getZoomControlCheckBox().setSelected(this.gMapsInfo.isZoomControl());
        this.getOverviewControlCheckBox().setSelected(this.gMapsInfo.isOverviewControl());
        this.getMarkerDefaultRadioButton().setSelected(!this.gMapsInfo.isThumbnailMarker());
        this.getMarkerThumbnailRadioButton().setSelected(this.gMapsInfo.isThumbnailMarker());
    }

    public void modified(boolean error) {
        if (!this.initializing && this.gMapsInfo != null) {
            if (!error) {
                boolean bl = this.isModified = this.gMapsInfo.getMapTypeIndex() != this.getMapTypeIndexValue() || this.gMapsInfo.isMapTypeControl() != this.getMapTypeConrolValue() || this.gMapsInfo.isZoomControl() != this.getZoomControlValue() || this.gMapsInfo.isOverviewControl() != this.getOverviewControlValue() || this.gMapsInfo.isThumbnailMarker() != this.getThumbnailMarkerValue();
                if (this.isModified) {
                    this.previewPanel.revalidate();
                    this.previewPanel.repaint();
                    this.save();
                }
            }
            this.onError = error;
        }
    }

    private boolean getThumbnailMarkerValue() {
        return this.getMarkerThumbnailRadioButton().isSelected();
    }

    private int getMapTypeIndexValue() {
        if (this.mapNormalRadioButton.isSelected()) {
            return 0;
        }
        if (this.mapSatelliteRadioButton.isSelected()) {
            return 1;
        }
        if (this.mapHybridRadioButton.isSelected()) {
            return 2;
        }
        if (this.mapPhysicalRadioButton.isSelected()) {
            return 3;
        }
        return 0;
    }

    private boolean getZoomControlValue() {
        return this.zoomControlCheckBox.isSelected();
    }

    private boolean getOverviewControlValue() {
        return this.overviewControlCheckBox.isSelected();
    }

    private boolean getMapTypeConrolValue() {
        return this.mapTypeControlCheckBox.isSelected();
    }

    public Object getEditedDocument() {
        return this.gMapsInfo;
    }

    public void setEditedDocument(Object document) throws DocumentException {
        this.gMapsInfo = (GoogleMapsInfo)document;
    }

    private JCheckBox getMapTypeControlCheckBox() {
        if (this.mapTypeControlCheckBox == null) {
            this.mapTypeControlCheckBox = new JCheckBox();
            this.mapTypeControlCheckBox.setText("map.type.control.check.box");
            this.mapTypeControlCheckBox.setHorizontalTextPosition(10);
            this.mapTypeControlCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.mapTypeControlCheckBox, "map.type.control.check.box");
        }
        return this.mapTypeControlCheckBox;
    }

    private JCheckBox getZoomControlCheckBox() {
        if (this.zoomControlCheckBox == null) {
            this.zoomControlCheckBox = new JCheckBox();
            this.zoomControlCheckBox.setText("zoom.control.check.box");
            this.zoomControlCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.zoomControlCheckBox, "zoom.control.check.box");
        }
        return this.zoomControlCheckBox;
    }

    private JCheckBox getOverviewControlCheckBox() {
        if (this.overviewControlCheckBox == null) {
            this.overviewControlCheckBox = new JCheckBox();
            this.overviewControlCheckBox.setText("overview.control.check.box");
            this.overviewControlCheckBox.setHorizontalTextPosition(10);
            this.overviewControlCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.overviewControlCheckBox, "overview.control.check.box");
        }
        return this.overviewControlCheckBox;
    }

    private JPanel getPreviewPanel() {
        if (this.previewPanel == null) {
            this.previewPanel = new GoogleMapsPreview();
            ((GoogleMapsPreview)this.previewPanel).setEditor(this);
            this.previewPanel.setLayout(null);
            Dimension dim = new Dimension(225, 130);
            this.previewPanel.setPreferredSize(dim);
            this.previewPanel.setMinimumSize(dim);
            this.previewPanel.setMaximumSize(dim);
        }
        return this.previewPanel;
    }

    private JRadioButton getMapNormalRadioButton() {
        if (this.mapNormalRadioButton == null) {
            this.mapNormalRadioButton = new JRadioButton();
            this.mapNormalRadioButton.setText("map.type.normal");
            this.mapNormalRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
            this.mapNormalRadioButton.setHorizontalTextPosition(10);
            this.textDisplayer.register(this.mapNormalRadioButton, "map.type.normal");
        }
        return this.mapNormalRadioButton;
    }

    private JRadioButton getMapSatelliteRadioButton() {
        if (this.mapSatelliteRadioButton == null) {
            this.mapSatelliteRadioButton = new JRadioButton();
            this.mapSatelliteRadioButton.setText("map.type.satellite");
            this.mapSatelliteRadioButton.setHorizontalTextPosition(10);
            this.mapSatelliteRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.mapSatelliteRadioButton, "map.type.satellite");
        }
        return this.mapSatelliteRadioButton;
    }

    private JRadioButton getMapHybridRadioButton() {
        if (this.mapHybridRadioButton == null) {
            this.mapHybridRadioButton = new JRadioButton();
            this.mapHybridRadioButton.setText("map.type.hybrid");
            this.mapHybridRadioButton.setHorizontalTextPosition(10);
            this.mapHybridRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.mapHybridRadioButton, "map.type.hybrid");
        }
        return this.mapHybridRadioButton;
    }

    private JRadioButton getMapPhysicalRadioButton() {
        if (this.mapPhysicalRadioButton == null) {
            this.mapPhysicalRadioButton = new JRadioButton();
            this.mapPhysicalRadioButton.setText("map.type.physical");
            this.mapPhysicalRadioButton.setHorizontalTextPosition(10);
            this.mapPhysicalRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
            this.textDisplayer.register(this.mapPhysicalRadioButton, "map.type.physical");
        }
        return this.mapPhysicalRadioButton;
    }

    private ButtonGroup getMapTypesButtonGroup() {
        if (this.mapTypesButtonGroup == null) {
            this.mapTypesButtonGroup = new ButtonGroup();
            this.mapTypesButtonGroup.add(this.getMapNormalRadioButton());
            this.mapTypesButtonGroup.add(this.getMapSatelliteRadioButton());
            this.mapTypesButtonGroup.add(this.getMapHybridRadioButton());
            this.mapTypesButtonGroup.add(this.getMapPhysicalRadioButton());
        }
        return this.mapTypesButtonGroup;
    }

    private JRadioButton getMarkerDefaultRadioButton() {
        if (this.markerDefaultRadioButton == null) {
            this.markerDefaultRadioButton = new JRadioButton();
            this.markerDefaultRadioButton.setText("marker.default");
            this.textDisplayer.register(this.markerDefaultRadioButton, "marker.default");
            this.markerDefaultRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
        }
        return this.markerDefaultRadioButton;
    }

    private JRadioButton getMarkerThumbnailRadioButton() {
        if (this.markerThumbnailRadioButton == null) {
            this.markerThumbnailRadioButton = new JRadioButton();
            this.markerThumbnailRadioButton.setText("marker.thumbnail");
            this.textDisplayer.register(this.markerThumbnailRadioButton, "marker.thumbnail");
            this.markerThumbnailRadioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    GoogleMapsInfoEditor.this.modified(GoogleMapsInfoEditor.this.onError);
                }
            });
        }
        return this.markerThumbnailRadioButton;
    }

    private ButtonGroup getMarkerButtonGroup() {
        if (this.markerButtonGroup == null) {
            this.markerButtonGroup = new ButtonGroup();
            this.markerButtonGroup.add(this.getMarkerDefaultRadioButton());
            this.markerButtonGroup.add(this.getMarkerThumbnailRadioButton());
        }
        return this.markerButtonGroup;
    }
}

