/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.prefs.data.xml;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.parsers.SAXParser;
import org.xissweb.gui.prefs.data.PreferenceCategory;
import org.xissweb.gui.prefs.data.PreferenceElement;
import org.xissweb.gui.prefs.data.PreferenceInfo;
import org.xissweb.gui.prefs.data.xml.PreferencesSchema;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class PreferencesDeserializer
extends DefaultHandler
implements PreferencesSchema {
    private PreferenceCategory rootPref;
    private List categories = new ArrayList();
    private PreferenceElement currentElement;

    public PreferenceCategory deserialize(File file) {
        this.rootPref = null;
        this.categories.clear();
        try {
            SAXParser parser = new SAXParser();
            parser.setContentHandler((ContentHandler)this);
            parser.parse(file.getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.rootPref;
    }

    private PreferenceCategory getCurrentCategory() {
        return (PreferenceCategory)this.categories.get(0);
    }

    private void pushCategory(PreferenceCategory preferencesCategory) {
        this.categories.add(0, preferencesCategory);
        this.currentElement = preferencesCategory;
    }

    private void popCategory() {
        this.categories.remove(0);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("category".equals(localName)) {
            if (this.rootPref == null) {
                this.rootPref = new PreferenceCategory(attributes.getValue("name"));
                this.pushCategory(this.rootPref);
            } else {
                PreferenceCategory pCat = new PreferenceCategory(attributes.getValue("name"));
                this.getCurrentCategory().addPreferenceElement(pCat);
                this.pushCategory(pCat);
            }
        } else if ("preference".equals(localName)) {
            String configurable = null;
            configurable = attributes.getValue("class");
            PreferenceInfo pInfo = new PreferenceInfo(attributes.getValue("key"), configurable, this.prefInfoType(attributes.getValue("type")), attributes.getValue("default"));
            String values = attributes.getValue("values");
            if (values != null) {
                pInfo.setValues(values.split(","));
            }
            this.getCurrentCategory().addPreferenceElement(pInfo);
            this.currentElement = pInfo;
        } else if ("display".equals(localName)) {
            this.currentElement.putDisplayValue(attributes.getValue("lang"), attributes.getValue("value"));
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (localName.equals("category")) {
            this.popCategory();
        }
    }

    private int prefInfoType(String value) {
        if (value.equals("boolean")) {
            return 0;
        }
        if (value.equals("integer")) {
            return 1;
        }
        if (value.equals("string")) {
            return 4;
        }
        if (value.equals("enum")) {
            return 5;
        }
        if (value.equals("file-name")) {
            return 6;
        }
        return 0;
    }
}

