/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Help;
import org.xissweb.gui.Main;
import org.xissweb.gui.XissWeb;
import org.xissweb.gui.XissWebUI;
import org.xissweb.gui.image.ImageDisplayer;
import org.xissweb.gui.image.ImageDisplayerObsever;
import org.xissweb.gui.project.FileNewProjectTreeCellRenderer;
import org.xissweb.gui.project.FileTransferHandler;
import org.xissweb.gui.project.ProjectAnalyzer;
import org.xissweb.gui.project.SwingAnalyzer;
import org.xissweb.gui.util.tree.TreeHelper;
import org.xissweb.gui.worker.ProcessLauncher;
import org.xissweb.gui.worker.SwingWorker;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.image.ImageFileHelper;
import org.xissweb.prefs.ui.ComponentConfigurator;

public abstract class AbstractNewProjectDialog
extends JDialog
implements ProcessLauncher,
TreeSelectionListener,
ImageDisplayerObsever {
    private static final String KEY_LOCATION_ANALYSE_WAIT = "location.analyse.wait";
    private static final String KEY_LOCATION_ANALYSE_PAUSE = "location.analyse.pause";
    private static final long serialVersionUID = 1L;
    private static final String WAITING_ANIM_ICON = "/images/common/waitingAnim.gif";
    private static final String STOP_ICON = "/images/common/stop.png";
    private static final String PAUSE_ICON = "/images/common/pause.png";
    private static final String RESTART_ICON = "/images/common/restart.png";
    private static final String PROJECT_ROOT_ICON = "/images/file/project-directory.png";
    private static final String HELP_ICON = "/images/common/help.png";
    private static final String PREVIEW_SELECTED = "/images/image/previewSelected.png";
    private static final String PREVIEW_UNSELECTED = "/images/image/previewUnselected.png";
    protected static final String WARNING_ICON = "/images/common/warning.png";
    protected static final String DIALOG_ERROR_ICON = "/images/common/dialog-error.png";
    protected static final String IMAGE_VIEWER_VISIBLE_KEY = "image.viewer.visible";
    protected static final String IMAGE_VIEWER_X_KEY = "image.viewer.x";
    protected static final String IMAGE_VIEWER_Y_KEY = "image.viewer.y";
    protected static final String IMAGE_VIEWER_WIDTH_KEY = "image.viewer.width";
    protected static final String IMAGE_VIEWER_HEIGHT_KEY = "image.viewer.height";
    public static final int IGNORE_ERROR_OPTION = -1;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$project$AbstractNewProjectDialog == null ? (class$org$xissweb$gui$project$AbstractNewProjectDialog = AbstractNewProjectDialog.class$("org.xissweb.gui.project.AbstractNewProjectDialog")) : class$org$xissweb$gui$project$AbstractNewProjectDialog);
    protected int option;
    protected File projectLocation;
    protected File srcDirectory;
    protected ProjectAnalyzer analyzer;
    private ProjectAnalyzer currentAnalyser;
    protected boolean okButtonStatus;
    protected String imageNumberValue;
    SwingAnalyzer worker;
    private JPanel jContentPane = null;
    private JScrollPane fileTreeContainer = null;
    private JTree fileTree = null;
    private JPanel controlPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel projectLocationLabel = null;
    private JTextField projectLocationTextField = null;
    private JButton projectLocationButton = null;
    private JTextField imageNumberTextField = null;
    private JLabel analyseLabel = null;
    private JPanel waitPanel = null;
    private JLabel inProgressLabel = null;
    private JLabel stopLabel = null;
    private JTextField infoTextField = null;
    JCheckBox showImageViewerCheckBox = null;
    private ImageDisplayer imageViewer = null;
    private JDialog imageViewerDialog = null;
    private JLabel helpLabel = null;
    protected JButton ignoreButton = null;
    private JLabel pauseLabel;
    static /* synthetic */ Class class$org$xissweb$gui$project$AbstractNewProjectDialog;

    public AbstractNewProjectDialog(Frame owner) {
        super(owner, true);
    }

    protected void imageViewLocationRegistration() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                AbstractNewProjectDialog.this.adaptImageViwerLocation();
            }

            public void componentResized(ComponentEvent e) {
                AbstractNewProjectDialog.this.adaptImageViwerLocation();
            }
        });
    }

    protected void applyPreferences() {
        ComponentConfigurator.configure((Component)this);
        boolean display = Main.preferences.getBoolean(IMAGE_VIEWER_VISIBLE_KEY, this.getClass(), false);
        this.getShowImageViewerCheckBox().setSelected(display);
        this.getImageViewerDialog().setVisible(display);
    }

    protected void adaptImageViwerLocation() {
        this.imageViewerDialog.setLocation(this.getX() + this.getWidth(), this.getY());
    }

    protected void applyImageViewerPreferences() {
        this.imageViewerDialog.setLocation(Main.preferences.getInt(IMAGE_VIEWER_X_KEY, this.getClass(), this.getX() + this.getWidth()), Main.preferences.getInt(IMAGE_VIEWER_Y_KEY, this.getClass(), this.getY()));
        this.imageViewerDialog.setSize(Main.preferences.getInt(IMAGE_VIEWER_WIDTH_KEY, this.getClass(), this.getHeight()), Main.preferences.getInt(IMAGE_VIEWER_HEIGHT_KEY, this.getClass(), this.getHeight()));
    }

    protected void storeImageViewerSizePreference() {
        Main.preferences.putInt(IMAGE_VIEWER_WIDTH_KEY, this.getClass(), this.imageViewerDialog.getWidth());
        Main.preferences.putInt(IMAGE_VIEWER_HEIGHT_KEY, this.getClass(), this.imageViewerDialog.getHeight());
    }

    protected void storeImageViewerPosPreference() {
        Main.preferences.putInt(IMAGE_VIEWER_X_KEY, this.getClass(), this.imageViewerDialog.getX());
        Main.preferences.putInt(IMAGE_VIEWER_Y_KEY, this.getClass(), this.imageViewerDialog.getY());
    }

    protected void storeImageViewerStatePreference() {
        Main.preferences.putBoolean(IMAGE_VIEWER_VISIBLE_KEY, this.getClass(), this.getShowImageViewerCheckBox().isSelected());
    }

    public int showDialog() {
        this.option = 1;
        this.getOkButton().setEnabled(false);
        this.setVisible(true);
        return this.option;
    }

    public ProjectAnalyzer getAnalyser() {
        return this.analyzer;
    }

    public File getProjectLocation() {
        return this.projectLocation;
    }

    public File getSrcDirectory() {
        return this.srcDirectory;
    }

    public boolean performAnalyse() {
        boolean inProgress = this.currentAnalyser.analyze();
        if (!inProgress) {
            this.choosedLocationAnalysed(this.currentAnalyser);
        }
        return inProgress;
    }

    public void performStart() {
    }

    public void performStop() {
        this.worker.interrupt(true);
    }

    public void performPauseRestart() {
        this.worker.interrupt(false);
        this.inProgressLabel.setIcon(this.worker.isInPause() ? null : XissWebUI.getIcon(WAITING_ANIM_ICON));
        this.pauseLabel.setIcon(XissWebUI.getIcon(this.worker.isInPause() ? RESTART_ICON : PAUSE_ICON));
        this.textDisplayer.registerToolTip(this.pauseLabel, this.worker.isInPause() ? "analyse.restart" : "analyse.pause");
        this.textDisplayer.register(this.inProgressLabel, this.worker.isInPause() ? KEY_LOCATION_ANALYSE_PAUSE : KEY_LOCATION_ANALYSE_WAIT);
    }

    protected void analyseLocation(File location, ProjectAnalyzer analyzer) {
        this.currentAnalyser = analyzer;
        this.currentAnalyser.setLocation(location);
        this.displayCurrentChoice(false);
        this.worker = new SwingAnalyzer(this);
        this.worker.setLauncher(this);
        this.worker.start();
    }

    protected void displayProjectExistWarning(File location) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.textDisplayer.getString("project.location.existing.location")).append(" \"");
        buff.append(location.getAbsolutePath()).append("\" \n");
        buff.append(this.textDisplayer.getString("project.location.existing"));
        XissWebUI.showErrorMessage(buff, this.textDisplayer.getString("project.location.title"));
    }

    public void processFinished(SwingWorker worker, long time, boolean complete) {
        this.inProgressLabel.setIcon(XissWebUI.getIcon(WAITING_ANIM_ICON));
        this.pauseLabel.setIcon(XissWebUI.getIcon(PAUSE_ICON));
        this.textDisplayer.register(this.inProgressLabel, KEY_LOCATION_ANALYSE_WAIT);
        if (!complete) {
            if (this.projectLocation != null) {
                this.projectLocationTextField.setText(this.projectLocation.getAbsolutePath());
            } else {
                this.projectLocationTextField.setText("");
            }
            this.displayCurrentChoice(true);
        }
    }

    protected void displayCurrentChoice(boolean display) {
        this.getCancelButton().setEnabled(display);
        this.getProjectLocationButton().setEnabled(display);
        if (!display) {
            this.imageNumberValue = this.getImageNumberTextField().getText();
            this.getImageNumberTextField().setText(this.textDisplayer.getString("looking.for.image.message"));
            this.okButtonStatus = this.getOkButton().isEnabled();
            this.getOkButton().setEnabled(false);
        } else {
            this.getImageNumberTextField().setText(this.imageNumberValue);
            this.getOkButton().setEnabled(this.okButtonStatus);
        }
        if (display) {
            this.getFileTreeContainer().setVisible(display);
            this.getWaitPanel().setVisible(!display);
        } else {
            this.getWaitPanel().setVisible(!display);
            this.getFileTreeContainer().setVisible(display);
        }
    }

    protected File selectAProjectLocation() {
        return this.selectAProjectLocation(this.textDisplayer.getString("project.location.aprouve.text"));
    }

    protected File selectAProjectLocation(String aprouveButtonText) {
        int result = XissWeb.getProjectFileChooser().showDialog(this, aprouveButtonText);
        if (result == 0) {
            return XissWeb.getProjectFileChooser().getSelectedFile();
        }
        return null;
    }

    protected abstract void choosedLocationAnalysed(ProjectAnalyzer var1);

    protected abstract JPanel getMainPanel();

    protected JLabel getAnalyseLabel() {
        if (this.analyseLabel == null) {
            this.analyseLabel = new JLabel();
            this.analyseLabel.setFont(XissWebUI.boldItalicFont);
        }
        return this.analyseLabel;
    }

    protected Component getFileTreeContainer() {
        if (this.fileTreeContainer == null) {
            this.fileTreeContainer = new JScrollPane();
            this.fileTreeContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.fileTreeContainer.setViewportView(this.getFileTree());
        }
        return this.fileTreeContainer;
    }

    protected JTextField getImageNumberTextField() {
        if (this.imageNumberTextField == null) {
            this.imageNumberTextField = new JTextField();
            this.imageNumberTextField.setEditable(false);
        }
        return this.imageNumberTextField;
    }

    protected JTree getFileTree() {
        if (this.fileTree == null) {
            this.fileTree = new JTree();
            this.fileTree.setRowHeight(24);
            this.fileTree.setCellRenderer(new FileNewProjectTreeCellRenderer(this));
            this.fileTree.setBackground(XissWebUI.paleColor);
            this.fileTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 1) {
                        AbstractNewProjectDialog.this.onFileTreeMouseClicked(e);
                    }
                }
            });
            this.fileTree.getSelectionModel().setSelectionMode(1);
            this.fileTree.getSelectionModel().addTreeSelectionListener(this);
        }
        return this.fileTree;
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.imageViewer != null) {
            File f;
            DefaultMutableTreeNode node;
            TreePath path = e.getPath();
            if (e != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof File && ImageFileHelper.isImageFile(f = (File)node.getUserObject())) {
                this.imageViewer.setImageFile(f);
            }
        }
    }

    void onFileTreeMouseClicked(MouseEvent e) {
        DefaultMutableTreeNode node = TreeHelper.getNode(this.fileTree, e.getX(), e.getY());
        if (node != null) {
            this.onFileNodeClicked(node);
        }
    }

    protected void onFileNodeClicked(DefaultMutableTreeNode node) {
        if (node.isRoot()) {
            this.performProjectLocation();
        }
    }

    protected JPanel getWaitPanel() {
        if (this.waitPanel == null) {
            GridBagConstraints infoTextFieldConstraints = new GridBagConstraints();
            infoTextFieldConstraints.fill = 2;
            infoTextFieldConstraints.insets = new Insets(5, 5, 5, 5);
            infoTextFieldConstraints.gridx = 0;
            infoTextFieldConstraints.gridy = 1;
            infoTextFieldConstraints.gridwidth = 4;
            infoTextFieldConstraints.anchor = 18;
            infoTextFieldConstraints.weighty = 100.0;
            GridBagConstraints pauseLabelConstraints = new GridBagConstraints();
            pauseLabelConstraints.insets = new Insets(5, 5, 5, 5);
            pauseLabelConstraints.gridx = 2;
            pauseLabelConstraints.gridy = 0;
            pauseLabelConstraints.anchor = 13;
            pauseLabelConstraints.weightx = 100.0;
            pauseLabelConstraints.gridheight = 1;
            GridBagConstraints stopLabelConstraints = new GridBagConstraints();
            stopLabelConstraints.insets = new Insets(5, 5, 5, 5);
            stopLabelConstraints.gridx = 3;
            stopLabelConstraints.gridy = 0;
            stopLabelConstraints.anchor = 13;
            stopLabelConstraints.gridheight = 1;
            GridBagConstraints inProgressLabelConstraints = new GridBagConstraints();
            inProgressLabelConstraints.gridheight = 1;
            inProgressLabelConstraints.gridx = 0;
            inProgressLabelConstraints.gridy = 0;
            inProgressLabelConstraints.anchor = 17;
            inProgressLabelConstraints.insets = new Insets(5, 5, 5, 5);
            inProgressLabelConstraints.weightx = 100.0;
            this.stopLabel = new JLabel();
            this.stopLabel.setIcon(XissWebUI.getIcon(STOP_ICON));
            this.textDisplayer.registerToolTip(this.stopLabel, "analyze.stop");
            this.stopLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    AbstractNewProjectDialog.this.performStop();
                }
            });
            this.pauseLabel = new JLabel();
            this.pauseLabel.setIcon(XissWebUI.getIcon(PAUSE_ICON));
            this.textDisplayer.registerToolTip(this.pauseLabel, "analyse.pause");
            this.pauseLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    AbstractNewProjectDialog.this.performPauseRestart();
                }
            });
            this.inProgressLabel = new JLabel();
            this.inProgressLabel.setFont(XissWebUI.plainFont);
            this.inProgressLabel.setBackground(XissWebUI.backgroundColor);
            this.inProgressLabel.setHorizontalTextPosition(2);
            this.inProgressLabel.setIcon(XissWebUI.getIcon(WAITING_ANIM_ICON));
            this.textDisplayer.register(this.inProgressLabel, KEY_LOCATION_ANALYSE_WAIT);
            this.waitPanel = new JPanel();
            this.waitPanel.setLayout(new GridBagLayout());
            this.waitPanel.setSize(new Dimension(51, 25));
            this.waitPanel.add((Component)this.inProgressLabel, inProgressLabelConstraints);
            this.waitPanel.add((Component)this.pauseLabel, null);
            this.waitPanel.add((Component)this.stopLabel, stopLabelConstraints);
            this.waitPanel.add((Component)this.getInfoTextField(), infoTextFieldConstraints);
        }
        return this.waitPanel;
    }

    protected int defaultXLocation() {
        return this.getParent().getX() + (this.getParent().getWidth() - this.getWidth()) / 3;
    }

    protected int defaultYLocation() {
        return this.getParent().getY() + (this.getParent().getHeight() - this.getWidth()) / 3;
    }

    protected void initialize() {
        this.setSize(650, 350);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getControlPanel(), "South");
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    protected JPanel getControlPanel() {
        if (this.controlPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.controlPanel = new JPanel();
            this.controlPanel.setLayout(flowLayout);
            this.controlPanel.add((Component)this.getIgnoreButton(), null);
            this.controlPanel.add((Component)this.getOkButton(), null);
            this.controlPanel.add((Component)this.getCancelButton(), null);
        }
        return this.controlPanel;
    }

    protected JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractNewProjectDialog.this.performOk();
                }
            });
            this.textDisplayer.register(this.okButton, "ok.button");
        }
        return this.okButton;
    }

    protected void performOk() {
        if (this.option == 1) {
            this.option = 0;
        }
        this.setVisible(false);
    }

    protected JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("CANCEL");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractNewProjectDialog.this.option = 1;
                    AbstractNewProjectDialog.this.setVisible(false);
                }
            });
            this.textDisplayer.register(this.cancelButton, "cancel.button");
        }
        return this.cancelButton;
    }

    protected JLabel getProjectLocationLabel() {
        if (this.projectLocationLabel == null) {
            this.projectLocationLabel = new JLabel();
            this.projectLocationLabel.setText("location");
            this.projectLocationLabel.setIcon(XissWebUI.getIcon(PROJECT_ROOT_ICON));
            this.textDisplayer.register(this.projectLocationLabel, "project.location.label");
        }
        return this.projectLocationLabel;
    }

    public JTextField getProjectLocationTextField() {
        if (this.projectLocationTextField == null) {
            this.projectLocationTextField = new JTextField();
            this.projectLocationTextField.setColumns(20);
            this.projectLocationTextField.setEnabled(false);
            this.projectLocationTextField.setEditable(false);
            this.projectLocationTextField.setTransferHandler(new FileTransferHandler(this));
        }
        return this.projectLocationTextField;
    }

    protected JButton getProjectLocationButton() {
        if (this.projectLocationButton == null) {
            this.projectLocationButton = new JButton();
            this.projectLocationButton.setText("...");
            this.projectLocationButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractNewProjectDialog.this.performProjectLocation();
                }
            });
            this.textDisplayer.register(this.projectLocationButton, "project.location.button");
        }
        return this.projectLocationButton;
    }

    public void performProjectLocation() {
        File location = this.selectAProjectLocation();
        this.performProjectLocation(location);
    }

    public void performProjectLocation(File location) {
        if (location != null) {
            File propFile = new File(location, "xissweb.properties");
            if (!propFile.exists()) {
                this.projectLocationTextField.setText(location.getAbsolutePath());
                this.analyseLocation(location, new ProjectAnalyzer(this));
            } else {
                this.displayProjectExistWarning(location);
            }
        }
    }

    JTextField getInfoTextField() {
        if (this.infoTextField == null) {
            this.infoTextField = new JTextField();
            this.infoTextField.setEditable(false);
            this.infoTextField.setColumns(0);
            this.infoTextField.setBackground(XissWebUI.backgroundColor);
        }
        return this.infoTextField;
    }

    public void displayAnalyseState(ProjectAnalyzer analyser) {
        this.getInfoTextField().setText(FileHelper.relativePath((File)analyser.getLocation(), (File)analyser.getCurrentDirectory()));
        int nbImages = analyser.getImageCount();
        if (nbImages > 0) {
            this.getImageNumberTextField().setText(nbImages + " " + this.textDisplayer.getString("images.found"));
        }
    }

    protected JCheckBox getShowImageViewerCheckBox() {
        if (this.showImageViewerCheckBox == null) {
            this.showImageViewerCheckBox = new JCheckBox();
            this.showImageViewerCheckBox.setIcon(XissWebUI.getIcon(PREVIEW_UNSELECTED));
            this.showImageViewerCheckBox.setSelectedIcon(XissWebUI.getIcon(PREVIEW_SELECTED));
            this.textDisplayer.registerToolTip(this.showImageViewerCheckBox, "image.viewer.show.tooltip");
            this.showImageViewerCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractNewProjectDialog.this.performShowImageViewer(AbstractNewProjectDialog.this.showImageViewerCheckBox.isSelected());
                }
            });
            this.showImageViewerCheckBox.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    AbstractNewProjectDialog.this.onShowImageViwerStateChanged();
                }
            });
        }
        return this.showImageViewerCheckBox;
    }

    protected void performShowImageViewer(boolean display) {
        if (display) {
            File f;
            TreePath path = this.getFileTree().getSelectionPath();
            if (path != null && ImageFileHelper.isImageFile(f = (File)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject())) {
                this.getImageViewer().setImageFile(f);
            }
            this.getImageViewerDialog().setVisible(true);
        } else {
            this.getImageViewerDialog().setVisible(false);
        }
    }

    void onShowImageViwerStateChanged() {
        this.storeImageViewerStatePreference();
    }

    protected ImageDisplayer getImageViewer() {
        if (this.imageViewer == null) {
            this.imageViewer = new ImageDisplayer();
            this.imageViewer.setObserver(this);
        }
        return this.imageViewer;
    }

    protected JDialog getImageViewerDialog() {
        if (this.imageViewerDialog == null) {
            this.imageViewerDialog = new JDialog(this);
            JScrollPane container = new JScrollPane();
            this.imageViewerDialog.setTitle(this.textDisplayer.getString("image.viewer.dialog.title"));
            container.setViewportView(this.getImageViewer());
            this.imageViewerDialog.setContentPane(container);
            this.imageViewerDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    AbstractNewProjectDialog.this.getShowImageViewerCheckBox().setSelected(false);
                }
            });
            this.applyImageViewerPreferences();
            this.imageViewerDialog.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent e) {
                    AbstractNewProjectDialog.this.storeImageViewerPosPreference();
                }
            });
            this.imageViewerDialog.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    AbstractNewProjectDialog.this.storeImageViewerSizePreference();
                }
            });
        }
        return this.imageViewerDialog;
    }

    public void imageSizeTypeChanged(ImageDisplayer imageDisplayer) {
    }

    public void imageFileReadStart(ImageDisplayer imageDisplayer) {
        this.setCursor(new Cursor(3));
        this.imageViewerDialog.setTitle(this.textDisplayer.getString("image.viewer.reading") + imageDisplayer.getImageFile().getName());
    }

    public void imageFileReadDone(ImageDisplayer imageDisplayer) {
        this.imageViewerDialog.setTitle(imageDisplayer.getImageFile().getName());
        this.setCursor(new Cursor(0));
    }

    protected JLabel getHelpLabel() {
        if (this.helpLabel == null) {
            this.helpLabel = new JLabel();
            this.helpLabel.setText("");
            this.helpLabel.setIcon(XissWebUI.getIcon(HELP_ICON));
            this.helpLabel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Help.open(AbstractNewProjectDialog.this.getHelpTag());
                }
            });
        }
        return this.helpLabel;
    }

    protected abstract String getHelpTag();

    private JButton getIgnoreButton() {
        if (this.ignoreButton == null) {
            this.ignoreButton = new JButton();
            this.textDisplayer.register(this.ignoreButton, "ignore.button");
            this.ignoreButton.setVisible(false);
            this.ignoreButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractNewProjectDialog.this.performIgnore();
                }
            });
        }
        return this.ignoreButton;
    }

    void performIgnore() {
        this.option = -1;
        this.setVisible(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

