/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.project;

import java.io.File;
import org.xissweb.file.DirectoryObserver;
import org.xissweb.file.FileHelper;
import org.xissweb.file.SteppedDirectoryVisitor;
import org.xissweb.gui.project.AbstractNewProjectDialog;
import org.xissweb.image.ImageFileHelper;
import org.xissweb.produce.AbstractDirectoryAction;

public class ProjectAnalyzer
extends AbstractDirectoryAction {
    private File location;
    private int imageMinDeep;
    private int imageCount;
    private File[] directoriesInLocation;
    private File possibleSrcDir;
    private File currentDirectory;
    private AbstractNewProjectDialog dialog;
    private int deepness = -1;
    private SteppedDirectoryVisitor visitor = null;

    public ProjectAnalyzer(AbstractNewProjectDialog dialog) {
        this.dialog = dialog;
    }

    public int getImageMinDeep() {
        return this.imageMinDeep;
    }

    protected File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public File[] getDirectoriesInLocation() {
        return this.directoriesInLocation;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public File getPossibleSrcDir() {
        return this.possibleSrcDir;
    }

    public boolean hasDirectoyHierarchy() {
        return this.directoriesInLocation.length > 0;
    }

    public boolean hasOnePossibleSrcDir() {
        return this.directoriesInLocation.length == 1;
    }

    public void setLocation(File location) {
        this.visitor = null;
        this.location = location;
        this.directoriesInLocation = FileHelper.listDirectories((File)location);
    }

    public File getLocation() {
        return this.location;
    }

    public boolean analyze() {
        if (this.visitor == null) {
            this.clear();
            this.visitor = new SteppedDirectoryVisitor((DirectoryObserver)this);
            this.visitor.visitInitialization(this.location);
            return true;
        }
        boolean inProgress = this.visitor.step();
        if (!inProgress) {
            this.visitor = null;
            if (this.imageMinDeep > 0 && this.hasOnePossibleSrcDir()) {
                this.possibleSrcDir = FileHelper.listDirectories((File)this.location)[0];
            }
        }
        return inProgress;
    }

    private void clear() {
        this.deepness = 0;
        this.imageMinDeep = -1;
        this.imageCount = 0;
    }

    public void updateAfterAddSrcDirectory() {
        ++this.imageMinDeep;
        this.directoriesInLocation = FileHelper.listDirectories((File)this.location);
        this.possibleSrcDir = this.directoriesInLocation[0];
    }

    public boolean doInDirectory(File directory, boolean selected) {
        this.currentDirectory = directory;
        int nbI = ImageFileHelper.countImageFiles(directory);
        if (nbI > 0) {
            this.imageCount += nbI;
            if (this.imageMinDeep == -1) {
                this.imageMinDeep = this.deepness;
            } else if (this.deepness < this.imageMinDeep) {
                this.imageMinDeep = this.deepness;
            }
        }
        ++this.deepness;
        if (this.dialog != null) {
            this.dialog.displayAnalyseState(this);
        }
        return false;
    }

    public boolean doOutDirectory(File directory, boolean selected) {
        --this.deepness;
        return false;
    }

    public boolean onAnalyze() {
        return this.visitor != null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("ProjectAnalyser[deep=").append(this.getImageMinDeep());
        buff.append(" ; possible src =").append(this.possibleSrcDir).append("]");
        return buff.toString();
    }
}

