/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.skin.simple;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import org.xissweb.data.skin.ComponentInfo;
import org.xissweb.data.skin.LineInfo;
import org.xissweb.data.skin.LinkInfo;
import org.xissweb.data.skin.PageInfo;
import org.xissweb.data.skin.SlideShowSkinInfo;
import org.xissweb.gui.graphic.GraphicElement;
import org.xissweb.gui.graphic.GraphicElementRenderer;
import org.xissweb.gui.skin.simple.SkinEditorHelper;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;

public class SkinGraphicElementRenderer
implements GraphicElementRenderer {
    private static final ImageIcon imageSample = new ImageIcon((class$org$xissweb$gui$skin$simple$SkinGraphicElementRenderer == null ? (class$org$xissweb$gui$skin$simple$SkinGraphicElementRenderer = SkinGraphicElementRenderer.class$("org.xissweb.gui.skin.simple.SkinGraphicElementRenderer")) : class$org$xissweb$gui$skin$simple$SkinGraphicElementRenderer).getResource("/rsrc/gui/images/skin/image.jpg"));
    private static final String metaDataSample = "[DIGITAL camera - 1/250 sec - F2,8 - 5,8 mm]";
    private static final int horizontalMargin = 17;
    private static final int verticalMargin = 25;
    private static final int verticalGap = 5;
    private static final int horizontalGap = 5;
    private static final int navigationBarGap = 17;
    private static final String backward = "<";
    private static final String foreward = ">";
    private static final String init = "o";
    private static final int thumbnailSize = 25;
    private TextDisplayer textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$gui$skin$simple$SkinGraphicElementRenderer == null ? (class$org$xissweb$gui$skin$simple$SkinGraphicElementRenderer = SkinGraphicElementRenderer.class$("org.xissweb.gui.skin.simple.SkinGraphicElementRenderer")) : class$org$xissweb$gui$skin$simple$SkinGraphicElementRenderer);
    private Color bodyBg;
    private Color pageBg;
    private Color fgColor;
    private Color link;
    private Color linkHover;
    private Color disabled;
    private Font pageFont;
    private SlideShowSkinInfo skinInfo;
    private int x;
    private int y;
    private int w;
    private int h;
    static /* synthetic */ Class class$org$xissweb$gui$skin$simple$SkinGraphicElementRenderer;

    public void draw(Graphics2D g2d, GraphicElement element, boolean selected) {
        this.skinInfo = (SlideShowSkinInfo)element.getUserObject();
        this.bodyBg = SkinEditorHelper.getColor(this.skinInfo.getColors().getBodyBackground());
        this.pageBg = SkinEditorHelper.getColor(this.skinInfo.getColors().getPageBackground());
        this.fgColor = SkinEditorHelper.getColor(this.skinInfo.getColors().getForeground());
        this.link = SkinEditorHelper.getColor(this.skinInfo.getColors().getLinkForeground());
        this.linkHover = SkinEditorHelper.getColor(this.skinInfo.getColors().getLinkHover());
        this.disabled = SkinEditorHelper.getColor(this.skinInfo.getColors().getDisabledForeground());
        this.drawBody(g2d, element);
        this.drawPage(g2d, element);
    }

    private void drawBody(Graphics2D g2d, GraphicElement element) {
        g2d.setPaint(this.bodyBg);
        g2d.fill(element.getArea());
    }

    private int xPage(GraphicElement element) {
        return element.getArea().x + (this.skinInfo.getPage().isCentered() ? 17 : 5);
    }

    private void drawPage(Graphics2D g2d, GraphicElement element) {
        PageInfo pageInfo = this.skinInfo.getPage();
        this.x = this.xPage(element);
        this.y = element.getArea().y + 25;
        this.w = element.getArea().width - 34;
        this.h = element.getArea().height - 50;
        this.pageFont = SkinEditorHelper.getFont(pageInfo.getFont());
        g2d.setPaint(this.pageBg);
        g2d.fillRect(this.x, this.y, this.w, this.h);
        this.x += 5;
        this.y += 5;
        Rectangle2D rect = this.drawText(g2d, this.textDisplayer.getString("text.page.sample"), this.pageFont, this.fgColor);
        this.y = (int)((long)this.y + Math.round(rect.getHeight()));
        LinkInfo linkInfo = pageInfo.getLink();
        this.y += 5;
        rect = this.drawText(g2d, this.textDisplayer.getString("text.page.link"), this.pageFont, this.link, linkInfo.getNormal());
        this.x = (int)((long)this.x + (5L + Math.round(rect.getWidth())));
        rect = this.drawText(g2d, this.textDisplayer.getString("text.page.link.hover"), this.pageFont, this.linkHover, linkInfo.getHover());
        this.x = this.xPage(element) + 5;
        this.y = (int)((long)this.y + (5L + Math.round(rect.getHeight())));
        rect = this.drawNavBar(g2d, element, this.pageFont);
        this.y = (int)((long)this.y + (Math.round(rect.getHeight()) + 5L));
        this.x = this.xPage(element) + 5;
        this.drawThumbnails(g2d, this.skinInfo.getComponent());
        this.x = this.xPage(element) + 5;
        int imgAreaH = this.drawImageArea(g2d);
        this.x = this.xPage(element) + 5;
        this.y += imgAreaH + 5;
        Font copyFont = SkinEditorHelper.getFont(this.skinInfo.getComponent().getCopyright().getFont());
        rect = this.drawText(g2d, this.textDisplayer.getString("text.copyright"), copyFont, this.fgColor);
    }

    private Rectangle2D drawText(Graphics2D g2d, String text, Font font, Color color) {
        return this.drawText(g2d, text, font, color, null);
    }

    private Rectangle2D drawText(Graphics2D g2d, String text, Font font, Color color, LineInfo lineInfo) {
        Stroke stroke;
        g2d.setFont(font);
        g2d.setPaint(color);
        Rectangle2D rect = font.getStringBounds(text, g2d.getFontRenderContext());
        g2d.drawString(text, (float)this.x, (float)((long)this.y + Math.round(rect.getHeight())));
        Stroke stroke2 = stroke = lineInfo != null ? SkinEditorHelper.getStroke(lineInfo) : null;
        if (stroke != null) {
            Stroke defaultStroke = g2d.getStroke();
            g2d.setStroke(stroke);
            int h = (int)Math.round(rect.getHeight());
            int w = (int)Math.round(rect.getWidth());
            g2d.drawLine(this.x, this.y + 2 + h, this.x + w, this.y + 2 + h);
            g2d.setStroke(defaultStroke);
        }
        return rect;
    }

    private Rectangle2D drawNavBar(Graphics2D g2d, GraphicElement pageElement, Font font) {
        g2d.setFont(font);
        Rectangle2D rec1 = font.getStringBounds(backward, g2d.getFontRenderContext());
        Rectangle2D rec2 = font.getStringBounds(init, g2d.getFontRenderContext());
        Rectangle2D rec3 = font.getStringBounds(foreward, g2d.getFontRenderContext());
        int wBar = (int)Math.round(rec1.getWidth() + rec2.getWidth() + rec3.getWidth()) + 34;
        this.x += (this.w - wBar) / 2;
        int yBar = this.y + (int)Math.round(rec1.getHeight());
        g2d.setPaint(this.disabled);
        g2d.drawString(backward, this.x, yBar);
        this.x = (int)((long)this.x + (17L + Math.round(rec1.getWidth())));
        g2d.setPaint(this.link);
        g2d.drawString(init, this.x, yBar);
        this.x = (int)((long)this.x + (17L + Math.round(rec2.getWidth())));
        g2d.drawString(foreward, this.x, yBar);
        return rec1;
    }

    private void drawThumbnails(Graphics2D g2d, ComponentInfo componentInfo) {
        Stroke defaultStroke = g2d.getStroke();
        this.x += 5;
        Stroke stroke = SkinEditorHelper.getStroke(componentInfo.getThumbnail().getLink().getNormal());
        if (stroke != null) {
            g2d.setStroke(stroke);
            g2d.setPaint(this.link);
            g2d.drawRect(this.x, this.y, 25, 25);
        }
        stroke = SkinEditorHelper.getStroke(componentInfo.getThumbnail().getLink().getHover());
        int yThumb = this.y + 25 + 10;
        if (stroke != null) {
            g2d.setStroke(stroke);
            g2d.setPaint(this.linkHover);
            g2d.drawRect(this.x, yThumb, 25, 25);
        }
        yThumb += 35;
        stroke = SkinEditorHelper.getStroke(componentInfo.getThumbnail().getCurrent());
        if (stroke != null) {
            g2d.setStroke(stroke);
            g2d.drawRect(this.x, yThumb, 25, 25);
            g2d.setStroke(defaultStroke);
        }
    }

    private int drawImageArea(Graphics2D g2d) {
        int borderSize = this.skinInfo.getComponent().getImageArea().getBorder().getThin();
        this.x += 40 + borderSize;
        this.y += borderSize;
        int imgAreaW = this.w - 30 - 25 - borderSize;
        int imgAreaH = this.h - this.y - 20 - borderSize;
        if (this.skinInfo.getComponent().getImageArea().getBackground() != null) {
            g2d.setPaint(SkinEditorHelper.getColor(this.skinInfo.getComponent().getImageArea().getBackground()));
            g2d.fillRect(this.x, this.y, imgAreaW, imgAreaH);
        }
        g2d.setPaint(SkinEditorHelper.getColor(this.skinInfo.getComponent().getImageArea().getColor()));
        Stroke stroke = SkinEditorHelper.getStroke(this.skinInfo.getComponent().getImageArea().getBorder());
        if (stroke != null) {
            Stroke defaultStroke = g2d.getStroke();
            g2d.setStroke(stroke);
            g2d.drawRect(this.x, this.y, imgAreaW, imgAreaH);
            g2d.setStroke(defaultStroke);
        }
        Font cmtFont = SkinEditorHelper.getFont(this.skinInfo.getComponent().getImageArea().getFont());
        String txt = this.textDisplayer.getString("text.comment");
        Font font = g2d.getFont();
        g2d.setFont(cmtFont);
        Rectangle2D rect = cmtFont.getStringBounds(txt, g2d.getFontRenderContext());
        int xTxt = this.x + (int)Math.round(((double)imgAreaW - rect.getWidth()) / 2.0);
        int yTxt = this.y + 5 + (int)Math.round(rect.getHeight());
        g2d.drawString(txt, xTxt, yTxt);
        Font mDataFont = SkinEditorHelper.getFont(this.skinInfo.getComponent().getImageArea().getMetadataFont());
        font = g2d.getFont();
        Paint paint = g2d.getPaint();
        g2d.setFont(mDataFont);
        Rectangle2D rectMData = mDataFont.getStringBounds(metaDataSample, g2d.getFontRenderContext());
        xTxt = this.x + (int)Math.round(((double)imgAreaW - rectMData.getWidth()) / 2.0);
        yTxt = yTxt + 5 + (int)Math.round(rectMData.getHeight());
        g2d.setPaint(SkinEditorHelper.getColor(this.skinInfo.getColors().getForeground()));
        g2d.drawString(metaDataSample, xTxt, yTxt);
        String textLIndex = this.textDisplayer.getString("text.local.index");
        font = g2d.getFont();
        g2d.setFont(cmtFont);
        Rectangle2D rectLIndex = cmtFont.getStringBounds(textLIndex, g2d.getFontRenderContext());
        g2d.setPaint(SkinEditorHelper.getColor(this.skinInfo.getComponent().getImageArea().getLocalIndex().getBackground()));
        int rX = this.x + 10;
        int rY = yTxt + 10;
        int rW = imgAreaW - 20;
        int rH = (int)Math.round(rectLIndex.getHeight()) + 10;
        g2d.fillRect(rX, rY, rW, rH);
        g2d.setPaint(SkinEditorHelper.getColor(this.skinInfo.getComponent().getImageArea().getLocalIndex().getBorderColor()));
        xTxt = this.x + (int)Math.round(((double)imgAreaW - rectLIndex.getWidth()) / 2.0);
        g2d.setPaint(SkinEditorHelper.getColor(this.skinInfo.getComponent().getImageArea().getColor()));
        g2d.drawString(textLIndex, xTxt, yTxt += rH);
        g2d.setPaint(paint);
        float imgW = imageSample.getIconWidth();
        float imgH = imageSample.getIconHeight();
        float areaW = imgAreaW - 10 - 2 * borderSize;
        float areaH = (float)((double)(imgAreaH - 40) - rect.getHeight() - rectMData.getHeight() - rectLIndex.getHeight());
        if (areaW >= 0.0f && areaH >= 0.0f) {
            float f = 1.0f;
            if (imgW > areaW || imgH > areaH) {
                f = Math.min(areaW / imgW, areaH / imgH);
            }
            int imgX = this.x + 5 + borderSize;
            int imgY = yTxt + 15;
            imgX = Math.max(imgX, imgX + Math.round((areaW - imgW * f) / 2.0f));
            imgY = Math.max(imgY, imgY + Math.round((areaH - imgH * f) / 2.0f));
            AffineTransform transf = new AffineTransform(f, 0.0f, 0.0f, f, imgX, imgY);
            g2d.drawImage(imageSample.getImage(), transf, null);
        }
        g2d.setFont(font);
        return imgAreaH;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

