/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ActiveLabel
extends JLabel {
    private static final long serialVersionUID = -6128378630091774914L;
    private Icon rolloverIcon;
    Icon savedIcon;

    public ActiveLabel() {
        this(null, null, 2);
    }

    public void addActionListener(final ActionListener listener) {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 1) {
                    listener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), e.getComponent().getName()));
                }
            }
        });
    }

    public ActiveLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public ActiveLabel(Icon image) {
        this(null, image, 2);
    }

    public ActiveLabel(String text, Icon image, int horizontalAlignment) {
        super(text, image, horizontalAlignment);
        this.init();
    }

    public ActiveLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public ActiveLabel(String text) {
        this(text, null, 2);
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Icon rolloverIcon) {
        this.rolloverIcon = rolloverIcon;
    }

    public void setIcon(Icon image, Icon rolloverImage) {
        super.setIcon(image);
        this.setRolloverIcon(rolloverImage);
    }

    public void setEnabled(boolean enabled) {
        if (this.savedIcon != null && !enabled) {
            this.setIcon(this.savedIcon);
        }
        super.setEnabled(enabled);
    }

    private void init() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent event) {
                if (ActiveLabel.this.getRolloverIcon() != null && ActiveLabel.this.isEnabled()) {
                    ActiveLabel.this.savedIcon = ActiveLabel.this.getIcon();
                    ActiveLabel.this.setIcon(ActiveLabel.this.getRolloverIcon());
                }
            }

            public void mouseExited(MouseEvent event) {
                if (ActiveLabel.this.getRolloverIcon() != null && ActiveLabel.this.isEnabled()) {
                    ActiveLabel.this.setIcon(ActiveLabel.this.savedIcon);
                }
            }
        });
    }
}

