/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.util;

public abstract class OsNameHelper {
    public static final String OS_MAC = "mac";
    public static final String OS_WINDOWS = "windows";
    public static final String OS_LINUX = "linux";
    public static final String OS_SOLARIS = "solaris";
    private static String osName = null;

    public static String getName() {
        if (osName == null) {
            osName = System.getProperty("os.name").toLowerCase();
        }
        return osName;
    }

    public static boolean isOs(String osName) {
        return OsNameHelper.getName().startsWith(osName);
    }

    public static boolean isMac() {
        return OsNameHelper.isOs(OS_MAC);
    }

    public static boolean isWindows() {
        return OsNameHelper.isOs(OS_WINDOWS);
    }

    public static boolean isLinux() {
        return OsNameHelper.isOs(OS_LINUX);
    }

    public static boolean isSolaris() {
        return OsNameHelper.isOs(OS_SOLARIS);
    }
}

