/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.gui.util;

import java.io.File;
import java.net.MalformedURLException;
import org.xissweb.file.FileHelper;
import org.xissweb.gui.Main;
import org.xissweb.produce.SlideShowDirectory;
import org.xissweb.project.SlideShowProject;

public abstract class ShowHelper {
    private static final String HTML_INDEX = "index.html";

    public static void performShowOneFile(File htmlFile) {
        try {
            Main.get().openURL(htmlFile.toURI().toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void performShowSlideshowDir(File slideshowDir) {
        ShowHelper.performShow(ShowHelper.slideshowBuildDir(slideshowDir));
    }

    public static void performShow() {
        ShowHelper.performShow(Main.get().getCurrentProject().getBuildDirectory());
    }

    public static boolean hasHtmlToShow() {
        return ShowHelper.hasHtmlToShowInDir(Main.get().getCurrentProject().getBuildDirectory());
    }

    public static boolean hasHtmlToShow(File slideshowDir) {
        return ShowHelper.hasHtmlToShowInDir(ShowHelper.slideshowBuildDir(slideshowDir));
    }

    private static boolean hasHtmlToShowInDir(File dir) {
        return ShowHelper.findHtmIndex(dir) != null || ShowHelper.findHtmlFile(dir) != null;
    }

    private static File slideshowBuildDir(File slideshowDir) {
        SlideShowProject project = Main.get().getCurrentProject();
        return FileHelper.fileInTargetDir((File)project.getSrcDirectory(), (File)slideshowDir, (File)project.getBuildDirectory());
    }

    private static void performShow(File dir) {
        File htmlFile = ShowHelper.findHtmIndex(dir);
        if (htmlFile == null) {
            htmlFile = ShowHelper.findHtmlFile(dir);
        }
        ShowHelper.performShowOneFile(htmlFile);
    }

    private static File findHtmIndex(File dir) {
        File indexFile = new File(dir, HTML_INDEX);
        if (indexFile.exists()) {
            return indexFile;
        }
        File[] dirs = FileHelper.listDirectories((File)dir);
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                File fIndex = ShowHelper.findHtmIndex(dirs[i]);
                if (fIndex == null) continue;
                return fIndex;
            }
        }
        return null;
    }

    private static File findHtmlFile(File dir) {
        File[] files = dir.listFiles(SlideShowDirectory.htmlFileFilter);
        if (files != null && files.length > 0) {
            return files[0];
        }
        File[] dirs = FileHelper.listDirectories((File)dir);
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                File fHtml = ShowHelper.findHtmlFile(dirs[i]);
                if (fHtml == null) continue;
                return fHtml;
            }
        }
        return null;
    }
}

