/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.image;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegReader;
import java.awt.Dimension;
import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class JPEGMetaDataExtractor {
    private static final DateFormat dateFormatIn = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    private static final DateFormat dateFormatOut = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final String ISO_PREFIX = "ISO ";
    public static final String FLASH_VALUE_YES = "yes";
    public static final String FLASH_VALUE_NO = "no";
    public static final int NOT_EXIF_TAG = -1;
    public static final int USER_COMMENT_TAG = 37510;
    public static final int IPTC_CAPTION_TAG = 632;
    public static final int MAKER_TAG = 271;
    public static final int MODEL_TAG = 272;
    public static final int DATE_TIME_TAG = 36867;
    public static final int SHUTTER_SPEED_TAG = 37377;
    public static final int EXPOSURE_TIME_TAG = 33434;
    public static final int APERTURE_TAG = 37378;
    public static final int ISO_EQUIVALENT_TAG = 34855;
    public static final int FOCAL_LENGTH_TAG = 37386;
    public static final int FLASH_TAG = 37385;
    public static final int WHITE_BALENCE_TAG = 37384;
    public static final int WHITE_BALENCE_MODE_TAG = 41987;
    public static final int SOFTWARE_TAG = 305;
    public static final int DATE_TIME_UPDATE_TAG = 306;
    public static final int FOCAL_LENGTH_35MM_EQUIV = 41989;
    public static final int GPS_LATITUDE_TAG = 2;
    public static final int GPS_LONGITUDE_TAG = 4;
    public static final int GPS_ALTITUDE_TAG = 6;
    private File file;
    private Directory jpegDirectory;
    private Directory exifDirectory;
    private Directory iptcDirectory;
    private Directory gpsDirectory;
    static /* synthetic */ Class class$com$drew$metadata$jpeg$JpegDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$exif$GpsDirectory;
    static /* synthetic */ Class class$com$drew$metadata$iptc$IptcDirectory;

    public JPEGMetaDataExtractor(File file) {
        this.file = file;
        try {
            Metadata metadata = new Metadata();
            new JpegReader(file).extract(metadata);
            this.jpegDirectory = metadata.getDirectory(class$com$drew$metadata$jpeg$JpegDirectory == null ? (class$com$drew$metadata$jpeg$JpegDirectory = JPEGMetaDataExtractor.class$("com.drew.metadata.jpeg.JpegDirectory")) : class$com$drew$metadata$jpeg$JpegDirectory);
            new ExifReader(file).extract(metadata);
            this.exifDirectory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = JPEGMetaDataExtractor.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
            this.gpsDirectory = metadata.getDirectory(class$com$drew$metadata$exif$GpsDirectory == null ? (class$com$drew$metadata$exif$GpsDirectory = JPEGMetaDataExtractor.class$("com.drew.metadata.exif.GpsDirectory")) : class$com$drew$metadata$exif$GpsDirectory);
        }
        catch (JpegProcessingException e) {
            e.printStackTrace();
        }
    }

    private Directory getIptcDirectory() {
        if (this.iptcDirectory == null) {
            try {
                Metadata metadata = new Metadata();
                new IptcReader(this.file).extract(metadata);
                this.iptcDirectory = metadata.getDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = JPEGMetaDataExtractor.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory);
            }
            catch (JpegProcessingException e) {
                e.printStackTrace();
            }
        }
        return this.iptcDirectory;
    }

    public Dimension getImageDimension() {
        Dimension dim = null;
        try {
            if (this.jpegDirectory.containsTag(3)) {
                dim = new Dimension();
                dim.width = this.jpegDirectory.getInt(3);
                dim.height = this.jpegDirectory.getInt(1);
            } else if (this.exifDirectory.containsTag(40962)) {
                dim = new Dimension();
                dim.width = this.exifDirectory.getInt(40962);
                dim.height = this.exifDirectory.getInt(40963);
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
        return dim;
    }

    public String getExifValue(int tag) {
        if (tag == -1) {
            return null;
        }
        try {
            if (tag == 37384) {
                if (this.exifDirectory.containsTag(tag)) {
                    return this.exifDirectory.getDescription(37384);
                }
                if (this.exifDirectory.containsTag(41987)) {
                    return this.exifDirectory.getDescription(41987);
                }
            }
            if (this.exifDirectory.containsTag(tag)) {
                if (tag == 37385) {
                    return this.getFlashValue();
                }
                if (tag == 37510) {
                    return this.getUserCommentValue();
                }
                String value = this.exifDirectory.getDescription(tag);
                if (tag == 34855) {
                    return ISO_PREFIX + value;
                }
                if (tag == 36867) {
                    try {
                        return dateFormatOut.format(dateFormatIn.parse(value));
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                return value;
            }
            if (this.gpsDirectory.containsTag(tag)) {
                String value = this.gpsDirectory.getDescription(tag);
                if (tag == 2) {
                    return this.gpsDirectory.getString(1) + ' ' + value.replace('\"', ' ').replace('\'', ' ');
                }
                if (tag == 4) {
                    return this.gpsDirectory.getString(3) + ' ' + value.replace('\"', ' ').replace('\'', ' ');
                }
                return value;
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getUserCommentValue() throws MetadataException {
        String value = this.exifDirectory.getDescription(37510);
        if ((value == null || value.length() == 0) && this.getIptcDirectory().containsTag(632)) {
            value = this.iptcDirectory.getDescription(632);
        }
        return value;
    }

    private String getFlashValue() throws MetadataException {
        if ((this.exifDirectory.getInt(37385) & 1) != 0) {
            return FLASH_VALUE_YES;
        }
        return FLASH_VALUE_NO;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

