/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce;

import java.io.File;
import java.io.FileFilter;
import org.xissweb.image.ImageFileHelper;
import org.xissweb.project.SlideShowProperties;

public class SlideShowDirectory {
    private static final String HTML_EXTENSION = "html";
    public static final FileFilter htmlFileFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().endsWith(SlideShowDirectory.HTML_EXTENSION);
        }
    };
    private static final FileFilter dirFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory();
        }
    };

    public static boolean isImageDirectory(File directory) {
        return directory.exists() && ImageFileHelper.hasImageFiles(directory);
    }

    public static File imageDirectory(File directory, SlideShowProperties properties) {
        File imageDir = null;
        File dir = null;
        if (properties.getImageDirFilter() == "only") {
            dir = new File(directory, properties.getImageDirName());
        } else if (properties.getImageDirFilter() == "except" && !directory.getName().equals(properties.getImageDirName()) && !directory.getName().equals(properties.getThumbnailDirName())) {
            dir = directory;
        }
        if (dir != null && (SlideShowDirectory.isImageDirectory(dir) || new File(directory, "slideshow.xml").exists())) {
            imageDir = dir;
        }
        return imageDir;
    }

    public static final boolean isSlideshowDirectory(File directory, SlideShowProperties properties) {
        return SlideShowDirectory.imageDirectory(directory, properties) != null;
    }

    public static boolean hasSlideshowDescription(File dir) {
        boolean result = false;
        File descFile = new File(dir, "slideshow.xml");
        if (!descFile.exists()) {
            File[] dirs = dir.listFiles(dirFilter);
            if (dirs != null) {
                for (int i = 0; i < dirs.length && !result; ++i) {
                    result = SlideShowDirectory.hasSlideshowDescription(dirs[i]);
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public static File createImageDirectory(SlideShowProperties properties, File currentDir) {
        File imageDir = currentDir;
        if (properties.getImageDirFilter() == "only") {
            imageDir = new File(currentDir, properties.getImageDirName());
            imageDir.mkdirs();
        }
        return imageDir;
    }
}

