/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce.links;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xissweb.data.content.SlideShowContentInfo;
import org.xissweb.data.content.SlideShowRefInfo;
import org.xissweb.data.content.xml.ContentDeserializer;
import org.xissweb.data.content.xml.ContentSerializer;
import org.xissweb.file.FileHelper;
import org.xissweb.produce.links.LinkChangeEvent;
import org.xissweb.produce.links.LinkChangeListener;

public class Linker {
    public static final int NEXT_ONLY_TYPE = 0;
    public static final int PREVIOUS_ONLY_TYPE = 1;
    public static final int NEXT_PREVIOUS_TYPE = 2;
    private List linkChangeListeners = new ArrayList();
    private ContentDeserializer deserializer = new ContentDeserializer();
    private ContentSerializer serializer = new ContentSerializer();

    public synchronized void addLinkChangeListener(LinkChangeListener listener) {
        this.linkChangeListeners.add(listener);
    }

    public synchronized void removeLinkChangeListener(LinkChangeListener listener) {
        this.linkChangeListeners.remove(listener);
    }

    public void link(File[] dirs, int linkType, boolean circular) {
        int i;
        int count = dirs.length;
        SlideShowContentInfo[] contentInfos = new SlideShowContentInfo[count];
        for (i = 0; i < count; ++i) {
            File contentFile = new File(dirs[i], "slideshow.xml");
            contentInfos[i] = this.deserializer.deserialize(contentFile);
        }
        this.linkInternal(contentInfos, linkType, circular, false);
        for (i = 0; i < contentInfos.length; ++i) {
            this.serializer.serialize(contentInfos[i]);
            this.notifyContentFileSaved(i, contentInfos[i].getFile(), true);
        }
    }

    public void link(SlideShowContentInfo[] contentInfos, int linkType, boolean circular) {
        this.linkInternal(contentInfos, linkType, circular, true);
    }

    private void linkInternal(SlideShowContentInfo[] contentInfos, int linkType, boolean circular, boolean notify) {
        int count = contentInfos.length;
        for (int i = 0; i < contentInfos.length; ++i) {
            SlideShowRefInfo oldPrev;
            SlideShowContentInfo contentInfo = contentInfos[i];
            SlideShowRefInfo oldNext = contentInfo.getNext();
            if (oldNext != null) {
                oldNext = new SlideShowRefInfo(oldNext.getHref(), oldNext.getText(), oldNext.getWay());
            }
            if ((oldPrev = contentInfo.getPrevious()) != null) {
                oldPrev = new SlideShowRefInfo(oldPrev.getHref(), oldPrev.getText(), oldPrev.getWay());
            }
            switch (linkType) {
                case 0: {
                    if (i != count - 1) {
                        this.setNextLink(contentInfo, oldNext, contentInfos[i + 1].getFile().getParentFile());
                    } else if (!circular) {
                        contentInfo.setNext(null);
                    }
                    contentInfo.setPrevious(null);
                    break;
                }
                case 1: {
                    if (i != 0) {
                        this.setPreviousLink(contentInfo, oldPrev, contentInfos[i - 1].getFile().getParentFile());
                    } else if (!circular) {
                        contentInfo.setPrevious(null);
                    }
                    contentInfo.setNext(null);
                    break;
                }
                case 2: {
                    if (i != count - 1) {
                        this.setNextLink(contentInfo, oldNext, contentInfos[i + 1].getFile().getParentFile());
                    } else if (!circular) {
                        contentInfo.setNext(null);
                    }
                    if (i != 0) {
                        this.setPreviousLink(contentInfo, oldPrev, contentInfos[i - 1].getFile().getParentFile());
                        break;
                    }
                    if (circular) break;
                    contentInfo.setPrevious(null);
                    break;
                }
            }
            if (circular) {
                if (i == 0 && (linkType == 1 || linkType == 2)) {
                    this.setPreviousLink(contentInfo, oldPrev, contentInfos[count - 1].getFile().getParentFile());
                } else if (i == count - 1 && (linkType == 0 || linkType == 2)) {
                    this.setNextLink(contentInfo, oldNext, contentInfos[0].getFile().getParentFile());
                }
            }
            if (!notify || !(oldNext == null && contentInfo.getNext() != null || oldPrev == null && contentInfo.getPrevious() != null || oldNext != null && !oldNext.equals(contentInfo.getNext())) && (oldPrev == null || oldPrev.equals(contentInfo.getPrevious()))) continue;
            this.notifyLinkChanged(i, contentInfo, true);
        }
    }

    public void clear(File[] dirs) {
        for (int i = 0; i < dirs.length; ++i) {
            File contentFile = new File(dirs[i], "slideshow.xml");
            SlideShowContentInfo contentInfo = this.deserializer.deserialize(contentFile);
            contentInfo.setNext(null);
            contentInfo.setPrevious(null);
            this.serializer.serialize(contentFile, contentInfo);
            this.notifyContentFileSaved(i, contentFile, false);
        }
    }

    public void clear(SlideShowContentInfo[] contentInfos) {
        for (int i = 0; i < contentInfos.length; ++i) {
            SlideShowRefInfo n = contentInfos[i].getNext();
            SlideShowRefInfo p = contentInfos[i].getPrevious();
            contentInfos[i].setNext(null);
            contentInfos[i].setPrevious(null);
            if (n == null && p == null) continue;
            this.notifyLinkChanged(i, contentInfos[i], false);
        }
    }

    private void notifyContentFileSaved(int index, File f, boolean a) {
        LinkChangeEvent event = new LinkChangeEvent(this, index, f, a);
        Iterator i = this.linkChangeListeners.iterator();
        while (i.hasNext()) {
            ((LinkChangeListener)i.next()).linkChanged(event);
        }
    }

    private void notifyLinkChanged(int index, SlideShowContentInfo contentInfo, boolean creation) {
        LinkChangeEvent event = new LinkChangeEvent(this, index, contentInfo, creation);
        Iterator i = this.linkChangeListeners.iterator();
        while (i.hasNext()) {
            ((LinkChangeListener)i.next()).linkChanged(event);
        }
    }

    private void setPreviousLink(SlideShowContentInfo contentInfo, SlideShowRefInfo p, File dir) {
        File current = contentInfo.getFile().getParentFile();
        String path = FileHelper.relativeURL((File)current, (File)dir);
        contentInfo.setPrevious(path, p != null && path.equals(p.getHref()) ? p.getText() : dir.getName());
    }

    private void setNextLink(SlideShowContentInfo contentInfo, SlideShowRefInfo n, File dir) {
        File current = contentInfo.getFile().getParentFile();
        String path = FileHelper.relativeURL((File)current, (File)dir);
        contentInfo.setNext(path, n != null && path.equals(n.getHref()) ? n.getText() : dir.getName());
    }
}

