/*
 * Decompiled with CFR 0.152.
 */
package org.xissweb.produce.sow;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.xissweb.i18n.TextDisplayManager;
import org.xissweb.i18n.TextDisplayer;
import org.xissweb.produce.AbstractProcess;
import org.xissweb.produce.DirectoryActionEvent;
import org.xissweb.produce.sow.SowEventListener;
import org.xissweb.produce.sow.SowException;
import org.xissweb.produce.sow.Sower;
import org.xissweb.project.SlideShowProject;

public final class Process
extends AbstractProcess
implements SowEventListener {
    private static final String REVERSE_ARG_NAME = "-reverse";
    private static final String REPOSITORY_ARG_NAME = "-repository";
    private static TextDisplayer textDisplayer;
    private int nbVisitedDir = 0;
    private int nbReadedImages = 0;
    private int nbReadedSlideshowContent = 0;
    private int nbWrotenSlideshowContent = 0;
    private int nbNewSlideshowContent = 0;
    static /* synthetic */ Class class$org$xissweb$produce$sow$Process;

    private Process() {
    }

    public static void main(String[] args) {
        textDisplayer = TextDisplayManager.createTextDisplayFor(class$org$xissweb$produce$sow$Process == null ? (class$org$xissweb$produce$sow$Process = Process.class$("org.xissweb.produce.sow.Process")) : class$org$xissweb$produce$sow$Process);
        if (args.length > 3) {
            Process.displayUsage();
            System.exit(0);
        }
        boolean reverse = false;
        boolean repository = false;
        String dirs = null;
        if (args.length == 1 && (args[0].equals("-version") || args[0].equals("-legal"))) {
            if (args[0].equals("-version")) {
                Process.printVersion();
                System.exit(0);
            } else {
                Process.printLegal();
                System.exit(0);
            }
        } else if (args.length == 2) {
            if (!args[0].equals("-select")) {
                Process.displayUsage();
                System.exit(0);
            } else {
                dirs = args[1];
            }
        } else if (args.length >= 1 && args[0].equals(REVERSE_ARG_NAME)) {
            reverse = true;
            if (args.length == 3 && !args[1].equals("-select")) {
                Process.displayUsage();
                System.exit(0);
            } else if (args.length == 3) {
                dirs = args[2];
            }
        } else if (args.length >= 1 && args[0].equals(REPOSITORY_ARG_NAME)) {
            repository = true;
            if (args.length == 3 && !args[1].equals("-select")) {
                Process.displayUsage();
                System.exit(0);
            } else if (args.length == 3) {
                dirs = args[2];
            }
        } else if (args.length != 0) {
            Process.displayUsage();
            System.exit(0);
        }
        new Process().doSowing(reverse, repository, dirs);
    }

    private void doSowing(boolean reverse, boolean reposotory, String dirs) {
        File projectDir = new File(System.getProperty("user.dir"));
        SlideShowProject project = new SlideShowProject(projectDir);
        if (!project.isProject()) {
            Process.displayNotAProjectMessage(projectDir);
            return;
        }
        Set selection = null;
        if (dirs != null) {
            File base = null;
            base = reposotory ? project.getRepositoryDirectory() : project.getSrcDirectory();
            selection = this.buildSelection(base, dirs);
            if (selection.isEmpty()) {
                Process.displayUsage();
                System.exit(0);
            }
        }
        Sower sower = new Sower();
        sower.setSelection(selection);
        sower.addListener(this);
        sower.setProject(project);
        if (reverse) {
            System.out.println(textDisplayer.getString("message.reverse.process"));
        } else {
            System.out.print(textDisplayer.getString("message.sow.process"));
            if (reposotory) {
                System.out.print(" " + textDisplayer.getString("message.sow.repository"));
            }
            System.out.println("...");
        }
        Date d0 = new Date();
        try {
            if (reverse) {
                while (sower.reverseSows()) {
                }
            } else if (reposotory) {
                while (sower.sowsFromRepository()) {
                }
            } else {
                while (sower.sows()) {
                }
            }
            this.printStatistics(d0, new Date());
        }
        catch (SowException e) {
            System.out.println(e);
        }
    }

    private void printStatistics(Date d0, Date d1) {
        SimpleDateFormat df = new SimpleDateFormat("mm:ss.SSS");
        d0.setTime(d1.getTime() - d0.getTime());
        System.out.println(textDisplayer.getString("message.sow.done") + " " + df.format(d0));
        System.out.println("   " + this.nbVisitedDir + "  " + textDisplayer.getString("message.sow.visited"));
        System.out.print("   " + (this.nbWrotenSlideshowContent - this.nbNewSlideshowContent) + "  " + textDisplayer.getString("message.sow.updated.slideshows"));
        System.out.println(" " + textDisplayer.getString("message.sow.on") + " " + this.nbReadedSlideshowContent + " " + textDisplayer.getString("message.sow.existing.slideshows"));
        System.out.println("   " + this.nbNewSlideshowContent + "  " + textDisplayer.getString("message.sow.new.slideshows"));
        System.out.println("   " + this.nbReadedImages + "  " + textDisplayer.getString("message.sow.images.number"));
        System.out.println();
    }

    protected static void displayUsage() {
        System.out.println(textDisplayer.getString("usage.intro"));
        AbstractProcess.displayUsage();
        System.out.println("    " + textDisplayer.getString("usage.reverse"));
        System.out.println("    " + textDisplayer.getString("usage.repository"));
        System.out.println("    " + textDisplayer.getString("usage.select"));
        System.out.println("    " + textDisplayer.getString("usage.usage"));
    }

    public void visitingInDirectory(DirectoryActionEvent event) {
        if (event.isSelected()) {
            ++this.nbVisitedDir;
            File dir = event.getDirectory();
            String path = dir.getPath();
            int index = path.lastIndexOf(File.separatorChar);
            for (int i = 0; i < index; ++i) {
                System.out.print(' ');
            }
            System.out.print(dir.getName());
        }
    }

    public void inDirectoryVisited(DirectoryActionEvent event) {
        if (event.isSelected()) {
            System.out.println();
        }
    }

    public void readingImage(DirectoryActionEvent event) {
        ++this.nbReadedImages;
        System.out.print('.');
    }

    public void slideshowContentReaded(DirectoryActionEvent event) {
        ++this.nbReadedSlideshowContent;
    }

    public void writingSlideshowContent(DirectoryActionEvent event) {
        ++this.nbWrotenSlideshowContent;
    }

    public void slideshowContentCreated(DirectoryActionEvent event) {
        ++this.nbNewSlideshowContent;
    }

    public void resizingImage(DirectoryActionEvent event) {
        System.out.print("o");
    }

    public void imageReaded(DirectoryActionEvent event) {
    }

    public void copyingContentDir(DirectoryActionEvent event) {
    }

    public void slideshowContentWroten(DirectoryActionEvent event) {
    }

    public void copyingImage(DirectoryActionEvent event) {
    }

    public void imageResized(DirectoryActionEvent event) {
    }

    public void outDirectoryVisited(DirectoryActionEvent event) {
    }

    public void visitingOutDirectory(DirectoryActionEvent event) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

