﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 -->
	<xsl:import href="doc2html.xsl"/>
	<!--
	 -->
	<xsl:param name="lang" select="'fr'"/>
	<xsl:param name="images-base">rsrc/doc/images/</xsl:param>
	<!--
	 -->
	<xsl:template match="/doc">
		<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="{$lang}">
			<head>
				<title><xsl:apply-templates select="doc-title"/></title>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
				<link href="rsrc/doc/css/doc.css" rel="stylesheet" type="text/css" />
				<link href="rsrc/doc/css/common.css" rel="stylesheet" type="text/css" />
				<link rel="shortcut icon" type="image/x-icon" href="rsrc/doc/images/xissweb.ico" />
			</head>
		<body>
		<p id="acces">[<a href="#start"><xsl:call-template name="i18n"><xsl:with-param name="key" select="'skip.intro.toc'"/></xsl:call-template></a> | <a href="#toc"><xsl:call-template name="i18n"><xsl:with-param name="key" select="'go.to.toc'"/></xsl:call-template></a>]</p>
		<div id="content">
			<div style="float: right;"><img src="rsrc/doc/images/banner.png" width="420" height="55"/></div>
			<div><a href="http://xissweb.free.fr" title="Aller sur le site de Xiss web..." accesskey="X"><img src="rsrc/doc/images/logo.png" alt="XISS WEB" width="96" height="50" /></a></div>
			<xsl:apply-templates select="content"/>
	   </div>
	   <div class="copy">&#169; 2004 - 2012 Xiss web</div>
<div id="goto-top"><a title="Aller en haut de la page." href="#acces"/></div>
<script type="text/javascript" src="rsrc/js/jquery.js"><xsl:comment>empty</xsl:comment></script>
<script type="text/javascript" src="rsrc/js/doc.js"><xsl:comment>empty</xsl:comment></script>
	   </body>
		</html>
	</xsl:template>
	<!--
	-->
	<xsl:template name="i18n">
		<xsl:param name="key"/>
		<xsl:choose>
			<xsl:when test="$lang = 'en'">
				<xsl:choose>
					<xsl:when test="$key = 'skip.intro.toc'">Skip intro and table of content</xsl:when>
					<xsl:when test="$key = 'go.to.toc'">Go to table of content</xsl:when>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$lang = 'fr'">
				<xsl:choose>
					<xsl:when test="$key = 'skip.intro.toc'">Passer l'intro et la table des matières</xsl:when>
					<xsl:when test="$key = 'go.to.toc'">Table des matières</xsl:when>
				</xsl:choose>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
