﻿var XWlang = "en"; /* en, fr */
var XWmetadataPos = "top"; /* none, top, bottom */
var XWcommentPos = "top"; /* top, bottom */
var XWnavigation = "basic"; /* basic, circular, previous, next, links */
var XWanimationKind = "fade"; /* fade, superimposed fade, (horizontal) scroll, vertical scroll */
var XWscrollOrientation = -1; /* -1 no scroll, 0 horizontal, 1 vertical */
var XWtransition = "medium"; /* none, fast, medium, slow --> 0, 200, 400, 600 */
var XWwaitScreenSize = "image area"; /* image area, full screen, none */
var XWcontrolPanel = false; /* true, false */
var XWprevious = 0;
var XWcurrent = -1;
var XWindex = "false"; /* false, default, standard, google maps, personal */
var XWhtmlIndex = "";
var XWslideWidth = 0;
var XWslideHeight = 0;
var XWscrollSlideDim = 0;
var XWcomments = new Array();
var XWimages = new Array();
var XWmetadata = new Array();
var XWtop = new Array();
var XWthumbnails = new Array();
var XWthumbTitles = new Array();
var XWhasLocation = new Array();
var XWnextLink = "";
var XWpreviousLink = "";
var XWmextLinkTitle = "";
var XWpreviousLinkTitle = "";
var XWforwardLinkTitle = "";
var XWbackwardLinkTitle = "";
var XWStartShowTitle = "";
var XWLocOnMap = null;

var XW_IMG_QUERY = "#image-container > div";
var XW_INDEX_QUERY = "#image-container";

function animation(map, fading) {
	this.map = map;
	this.fading = fading;
	this.init = function(current) {
		this.map.current = current;
		XWInitMapBox2(this.map, this.fading);
	};
}

function XWloadAndInitSlideShow(index) {
	XWindex = index;
	$.get("images.xml", function (xml) {
		var serializer = new XMLSerializer();
		var xmlDoc;
		if (xml instanceof Document) {
			xmlDoc = xml;
		} else {
			var parser = new DOMParser();
		    xmlDoc = parser.parseFromString(xml, "text/xml");
		}
		var rootNode = xmlDoc.getElementsByTagName("images")[0];
		XWlang = rootNode.getAttribute('lang');
		if (rootNode.hasAttribute("animation")) {
			XWanimationKind = rootNode.getAttribute("animation");
		}
		XWtransition = rootNode.getAttribute("transition");
		if (rootNode.hasAttribute("control-panel")) {
			if (rootNode.getAttribute("control-panel")  == "true") {
				XWcontrolPanel= true;
			} // false is the default value
		}
		if (XWcontrolPanel) {
			var cookie = XWgetCookie(XWCookieAnimationSpeed);
			if (cookie != "") {
				XWtransition = cookie;
			}
		}
		if (XWtransition == "none" || XWtransition == "immediate") {
			XWtransition = 0;
		} else if (XWtransition == "medium") {
			XWtransition = 400;
		}
		if (rootNode.hasAttribute("wait-screen-size")) {
			XWwaitScreenSize = rootNode.getAttribute("wait-screen-size");
		}
		XWcommentPos = rootNode.getAttribute("comment-pos");
		if (XWcontrolPanel) {
			cookie = XWgetCookie(XWCookieCommentPos);
			if (cookie != '') {
				XWcommentPos = cookie;
			}
		}
		XWmetadataPos = rootNode.getAttribute("metadata-pos");
		if (XWcontrolPanel) {
			cookie = XWgetCookie(XWCookieMetadataDisp);
			if (cookie != '') {
				XWmetadataPos = cookie;
			}
		}
		XWnavigation = rootNode.getAttribute("navigation");
		if (rootNode.hasAttribute("next-link")) {
			XWnextLink = rootNode.getAttribute("next-link");
		}
		if (rootNode.hasAttribute("previous-link")) {
			XWpreviousLink = rootNode.getAttribute("previous-link");
		}
		
		var imgLocOnMap = xmlDoc.getElementsByTagName("image-location-on-map");
		if (imgLocOnMap.length == 1) {
			var ic = (imgLocOnMap[0].getAttribute("thumbnail-marker") == 'true') ? 1 : 0;
			var mt = parseInt(imgLocOnMap[0].getAttribute("map-type"));
			var zc = (imgLocOnMap[0].getAttribute("zoom-control") == 'true') ? 1 : 0;
			var mc = (imgLocOnMap[0].getAttribute("map-control") == 'true') ? 1 : 0;
			var oc = (imgLocOnMap[0].getAttribute("overview-control") == 'true') ? 1 : 0;
			var zl = parseInt(imgLocOnMap[0].getAttribute("zoom-level"));
			var f = imgLocOnMap[0].getAttribute("fading");
			var map = new XWMap(ic, mt, zc, mc, oc, -1, zl);
			XWLocOnMap = new animation(map, f);
		}
		
		var nav = xmlDoc.getElementsByTagName("navigation-links");
		XWpreviousLinkTitle = nav[0].getAttribute("previous");
		XWnextLinkTitle = nav[0].getAttribute("next");
		XWbackwardLinkTitle = nav[0].getAttribute("backward");
		XWforwardLinkTitle = nav[0].getAttribute("forward");
		XWstartShowTitle = nav[0].getAttribute("start");
		
		var imgs = xmlDoc.getElementsByTagName("image");
		var num = 0;
		var cmt = '';
		var mdata = '';
		var divs = null;
		var thumb = null;
		var hasLoc = 'no';
		for (var i = 0; i < imgs.length; i++) {
			num = parseInt(imgs[i].getAttribute("number"));
			XWimages[num] = imgs[i].getAttribute("src");
			XWtop[num] = parseInt(imgs[i].getAttribute("top"));
			
			cmt = imgs[i].getElementsByTagName("comment")[0];
			XWcomments[num] = serializer.serializeToString(cmt.getElementsByTagName("div")[0]);
			
			mdata = imgs[i].getElementsByTagName("metadata")[0];
			divs = mdata.getElementsByTagName("div");
			if (divs.length != 0) {
				XWmetadata[num] = serializer.serializeToString(mdata.getElementsByTagName("div")[1]);
			} else {
				XWmetadata[num] = '';
			}

			thumb = imgs[i].getElementsByTagName("thumbnail")[0];
			XWthumbnails[num] = serializer.serializeToString(thumb.getElementsByTagName("img")[0]);
			XWthumbTitles[num] = thumb.getAttribute("title");
			
			hasLoc = imgs[i].getAttribute("has-location");
			XWhasLocation[num] = false;
			if (hasLoc == 'yes') {
				XWhasLocation[num] = true;
			}
		}
		if (XWanimationKind == 'fade') {
			XWfadeInit();
		} else if (XWanimationKind == 'scroll' || XWanimationKind == 'horizontal scroll') {
			XWscrollOrientation = 0;
			XWscrollInit();
		} else if (XWanimationKind == 'vertical scroll') {
			XWscrollOrientation = 1;
			XWscrollInit();
		} else {
			XWsuperimposedFadeInit();
		}
	});
}

function XWinitSlideShow() {
	XWinitLoadScreen();
	if (XWcontrolPanel) {
		XWinitControlPanel();
	}
	if (XWindex != 'false' && XWindex != 'personal') {
		XWhtmlIndex = $(XW_INDEX_QUERY).html();
		XWprevious = 0;
		XWcurrent = 0;
	} else {
		XWprevious = 0;
		XWcurrent = 1;
	}
}


// v = +1 or -1
function XWnextImage(v) {
	var i = XWcurrent + v;
	var n = XWnavigationState(i);
	
	XWswitchImage(n);
}

function XWgotoImage(i) {
	XWnavigationState(i);
	if (i == 0) {
		XWsetBackwardEnable(false);
		XWsetForwardEnable(true);
	}
	XWswitchImage(i);
}

function XWswitchImage(i) {
	if (XWanimationKind == 'fade') {
		XWfadeSwitchImage(i);
	} else if (XWscrollOrientation != -1) { // if scroll animation, orientation = 0 or 1
		XWscrollSwitchImage(i);
	} else {
		XWsuperimposedFadeSwitchImage(i);
	}
}


/**** FADE ANIMATION ****/

function XWfadeInit() {
	XWinitSlideShow();
	if (XWindex != 'false' && XWindex != 'personal') {
		XWfadeShowIndex();
	} else {
		XWfadeShowMainImage();
	}
}

function XWfadeSwitchImage(i) {
	if (i != XWcurrent) {
		XWprevious = XWcurrent;
		XWcurrent = i;
		XWunsetCurrentThumbnail(XWprevious);
		XWunloadMapBeforeSwitching();
		if (XWprevious == 0) {
			$(XW_IMG_QUERY).fadeOut(XWtransition, function() {
				XWfadeShowMainImage();
			});
		} else {
			$(XW_IMG_QUERY).fadeOut(XWtransition, function() {
				if (XWcurrent == 0) {
					XWfadeShowIndex();
				} else {
					XWfadeShowMainImage();
				}
			});
		}
	}
}

function XWfadeShowMainImage() {
	XWshowLoadScreen(XWcurrent);
	var preloader = new Image();
	preloader.onload = function() { // to do when the image is loaded
		if (XWprevious == 0) {
			// replace the index elements by image elements
			XWsetFadeImageElements(XWcurrent);
		} else {
			if (XWhasLocation[XWprevious] && XWLocOnMap != null) {
				XWMapUnload();
				XWRemoveImageLocationOnMap();
			}
			// Image elements already here, just update the content
			$(XW_IMG_QUERY).css("padding-top", XWtop[XWcurrent]+"px");
			$("#metaData div:first").replaceWith(XWmetadata[XWcurrent]);
			$("#image-comment div:first").replaceWith(XWcomments[XWcurrent]);
		}
		// set im in the HTML element after it's load
		var img = $(".mainImage");
		img.width(preloader.width);
		img.height(preloader.height);
		img.attr("src", preloader.src);
		// then show all the elements
		
		XWhideLoadScreen(XWcurrent);
		$(XW_IMG_QUERY).fadeIn(XWtransition);
		img.fadeIn(XWtransition);
		if (XWhasLocation[XWcurrent] && XWLocOnMap != null) {
			XWaddImageLocationOnMap();
			XWLocOnMap.init(XWcurrent);
		}
		XWsetCurrentThumbnail(XWcurrent);
	};
	// loading...
	preloader.src = XWimages[XWcurrent];
}

function XWfadeShowIndex() {
	if (XWprevious > 0) {
		XWunsetCurrentThumbnail(XWprevious);
		if (XWhasLocation[XWprevious] && XWLocOnMap != null) {
			XWMapUnload();
			XWRemoveImageLocationOnMap();
		}
	}
	$(XW_IMG_QUERY).replaceWith(XWhtmlIndex);
	$(XW_IMG_QUERY).fadeIn(XWtransition);
	if (XWindex == 'google maps') {
		XW_MAP.load();
	}
}

function XWsetFadeImageElements(n) {
	data = '<div style="display: none; padding-top: '+XWtop[n]+'px;">';
	data = data + XWcreateImageElements(n);
	data = data + '</div>'
	$(XW_IMG_QUERY).replaceWith(data);
}
/**** End of FADE ANIMATION ****/



/**** SCROLL ANIMATION ****/

function XWscrollInit() {
	if (XWscrollOrientation == 0) {
		XWscrollSlideDim = $('#image-container').width();
	} else {
		XWscrollSlideDim = $('#image-container').height();
	}
	
	$('#image-container').css('overflow', 'hidden');
	
	if (XWindex != 'false' && XWindex != 'personal') {
		var index = null;
		if (XWindex == 'google maps') {
			index = $('#map-index');
		} else if (XWindex == 'standard') {
			index = $('#standard-index');
		} else {
			index = $('#default-index');
		}
		index.css("display", "block");
		index.wrapAll('<div class="slide"></div>');
	} else {
		$('#image-container div').attr("class", "slide");
		$(".slide").replaceWith(XWCreateFirstScrollElement());
	}
	
	var slides = $('.slide');
	// Wrap all .slides with #slideInner div
	slides.wrapAll('<div id="slideInner" style="text-align: center"></div>')
	// Float left to display horizontally, readjust .slides dim
	if (XWscrollOrientation == 0) {
		slides.css({'float' : 'left', 'width' : XWscrollSlideDim});
	} else {
		slides.css('height', XWscrollSlideDim);
	}
	
	// Set #slideInner width equal to total width of all slides
	XW_INDEX_QUERY = "#slideInner";
	XWinitSlideShow();
	
	if (XWindex == 'false' || XWindex == 'personal') {
		var preloader = new Image();
		XWshowLoadScreen(XWcurrent);
		preloader.onload = function() { // to do when the image is loaded
			var img = $(".slide img");
			img.width(preloader.width);
			img.height(preloader.height);
			img.attr("src", preloader.src);
			XWhideLoadScreen(XWcurrent);
			$('.slide').css("display", "block");
			XWaddImageLocationOnMap();
			XWsetCurrentThumbnail(XWcurrent);
		};
		// loading...
		preloader.src = XWimages[XWcurrent];
	} else if (XWindex == 'google maps') {
		XW_MAP.load();
	}
}

function XWCreateFirstScrollElement() {
	var data = '';
	if (XWscrollOrientation == 0) {
		data = '<div class="slide" style="display: none; padding: '+XWtop[1]+'px 0 0 0; text-align: center; float: left; width: '+XWscrollSlideDim+'px;">';
	} else {
		data = '<div class="slide" style="display: none; padding: '+XWtop[1]+'px 0 0 0; text-align: center; height: '+(XWscrollSlideDim-XWtop[1])+'px;">';
	}
	data = data + XWcreateImageElements(1);
	data = data + '</div>';
	return data;
}

function XWCreateScrollElement(n) {
	var data = "";
	if (n == 0) {
		data = XWhtmlIndex;
	} else {
		if (XWscrollOrientation == 0) {
			data = '<div class="slide" style="padding: '+XWtop[n]+'px 0 0 0; text-align: center; float: left; width: '+XWscrollSlideDim+'px;">';
		} else {
			data = '<div class="slide" style="padding: '+XWtop[n]+'px 0 0 0; text-align: center; height: '+(XWscrollSlideDim-XWtop[n])+'px;">';
		}
		data = data + XWcreateImageElements(n);
		data = data + '</div>';
	}
	return data;
}

function XWscrollSwitchImage(n) {
	if (XWcurrent != n) {
		var e = XWCreateScrollElement(n);
		XWprevious = XWcurrent;
		XWcurrent = n;
		XWunsetCurrentThumbnail(XWprevious);
		XWunloadMapBeforeSwitching();
		var way = 1;
		if (n > XWprevious) {
			$(e).insertAfter(".slide");
			if (XWscrollOrientation == 0) {
				$('#slideInner').css('width', XWscrollSlideDim * 2);
			} else {				
				$('#slideInner').css('height', XWscrollSlideDim * 2);
			}
		} else {
			way = 0;
			$(e).insertBefore('.slide');
			if (XWscrollOrientation == 0) {
				$('#slideInner').css({'width' : XWscrollSlideDim * 2, 'margin-left': -XWscrollSlideDim});
			} else {
				$('#slideInner').css({'height' : XWscrollSlideDim * 2, 'margin-top': -XWscrollSlideDim});
			}
		}
		if (XWcurrent != 0) {
			XWloadAndScroll(way);
		} else {
			XWscrollSlide(way);
		}
	}
}

function XWloadAndScroll(way) {
	var preloader = new Image();
	XWshowLoadScreen(XWcurrent);
	preloader.onload = function() { // to do when the image is loaded
		var img;
		if (XWcurrent >= XWprevious) {
			img = $("img.mainImage:last");
		} else {
			img = $("img.mainImage:first");
		}
		img.width(preloader.width);
		img.height(preloader.height);
		img.attr("src", preloader.src);
		XWhideLoadScreen(XWcurrent);
		XWscrollSlide(way);
	};
	// loading...
	preloader.src = XWimages[XWcurrent];
}


function XWscrollSlide(way) {
	if (XWcurrent == 0 && XWindex == 'google maps') {
		XW_MAP.load();
	}
	if (XWscrollOrientation == 0) {
		$('#slideInner').animate(
			{'marginLeft' : XWscrollSlideDim*(-way)},
			XWtransition,
			function() {
				XWafterScroll(way);
			}
		);
	} else {
		$('#slideInner').animate(
			{'marginTop' : XWscrollSlideDim*(-way)},
			XWtransition,
			function() {
				XWafterScroll(way);
			}
		);
	}
}

function XWafterScroll(way) {
	if (way == 1) {
		$(".slide:first").remove();
	} else {
		$(".slide:last").remove();
	}
	if (XWscrollOrientation == 0) {
		$('#slideInner').css({"width" : XWscrollSlideDim, "margin-left" : 0});
	} else {
		$('#slideInner').css({"height" : XWscrollSlideDim, "margin-top" : 0});
	}
	XWaddImageLocationOnMap();
	XWsetCurrentThumbnail(XWcurrent);
}

/**** End of SCROLL ANIMATION ****/

/**** SUPERIMPOSED FADE ANIMATION ****/

function XWsuperimposedFadeInit() {
	XWslideWidth = $('#image-container').width();
	XWslideHeight = $('#image-container').height();
	$('#image-container').css('overflow', 'hidden');
	
	if (XWindex != 'false' && XWindex != 'personal') {
		// set a z-index for the index before the initialization
		$(XW_IMG_QUERY).wrapAll('<div class="slide" style="z-index: 30000; display: none;"></div>').css('display', 'block');
	} else {
		$(XW_IMG_QUERY).attr('class', 'slide');
	}
	
	// Wrap all .slides with #slideInner div
	$('.slide').wrapAll('<div id="slideInner" style="text-align: center"></div>')
	// readjust .slide width and height
	 .css({'width' : XWslideWidth, 'height' : XWslideHeight});

	XW_INDEX_QUERY = "#slideInner";
 	XWinitSlideShow();

	if (XWindex != 'false' && XWindex != 'personal') {
		$('.slide:first').css('z-index', 10000).fadeIn(XWtransition);
		if (XWindex == 'google maps') {
			XW_MAP.load();
		}
	} else {
		XWsetSuperimposedFadeImageElement(1);
		var preloader = new Image();
		XWshowLoadScreen(1);
		preloader.onload = function() { // to do when the image is loaded
			XWhideLoadScreen(1);
			var img = $("img.mainImage:last")
			img.width(preloader.width);
			img.height(preloader.height);
			img.attr("src", preloader.src);
			$('.slide:first').remove();
			$('.slide').css({'top': 0, 'z-index': 10000}).fadeIn(XWtransition);
			XWsetCurrentThumbnail(XWcurrent);
		};
		// loading...
		preloader.src = XWimages[1];
	}
}

function XWsuperimposedFadeSwitchImage(n) {
	if (XWcurrent != n) {
		XWprevious = XWcurrent;
		XWcurrent = n;
		XWunsetCurrentThumbnail(XWprevious)
		XWunloadMapBeforeSwitching();
		XWsetSuperimposedFadeImageElement(n);
		var preloader = new Image();
		XWshowLoadScreen(XWcurrent);
		if (XWcurrent == 0) {
			$('.slide:last').fadeIn(XWtransition);
			if (XWindex == 'google maps') {
				XW_MAP.load();
			}
			XWsuperimposedFadeAfterShow();
		} else {
			preloader.onload = function() { // to do when the image is loaded
				XWhideLoadScreen(XWcurrent);
				var img = $("img.mainImage:last")
				img.width(preloader.width);
				img.height(preloader.height);
				img.attr("src", preloader.src);
				$('.slide:last').fadeIn(XWtransition);
				XWsuperimposedFadeAfterShow();
			};
			// loading...
			preloader.src = XWimages[XWcurrent];
		}
	}
}

function XWsuperimposedFadeAfterShow() {
	$('.slide:first').fadeOut(XWtransition, function() {
		XWsuperimposedFadeAfterShow2();
	});
}

function XWsuperimposedFadeAfterShow2() {
	$('.slide:last').css({'z-index': 10000, 'top': 0});
	$('.slide:first').remove();
	XWaddImageLocationOnMap();
	XWsetCurrentThumbnail(XWcurrent);
}

function XWsetSuperimposedFadeImageElement(n) {
	var element = XWcreateSuperimposedElement(n);
	$(element).insertAfter('.slide');
	if (n == 0) {
		$('.slide:last').css({'position': 'relative', 'top': -XWslideHeight});
	}
}

function XWcreateSuperimposedElement(n) {
	var data = "";
	if (n == 0) {
		data = XWhtmlIndex;
	} else {
		var h = XWslideHeight - XWtop[n];
		data = '<div class="slide" style="display: none; z-index: 30000; padding-top: '+XWtop[n]+'px; position: relative; left: 0; top: -'+XWslideHeight+'px; height: '+h+'px; width: '+XWslideWidth+'px;">';
		data = data + XWcreateImageElements(n);
		data = data + '</div>';
	}
	return data;
}

/**** End of SUPERIMPOSED FADE ANIMATION ****/


function XWcreateImageElements(n) {
	var data = "";
	if (XWcommentPos == 'top') {
		data = data + '<div class="top-comment" id="image-comment">'+XWcomments[n]+'</div>';
	}
	if (XWmetadataPos == 'top') {
		data = data + '<div class="top-metadata" id="metaData">'+XWmetadata[n]+'</div>';
	}
	data = data + '<img class="mainImage"/>';
	if (XWmetadataPos == 'bottom') {
		data =  data + '<div class="bottom-metadata" id="metaData">'+XWmetadata[n]+'</div>';
	}
	if (XWcommentPos == 'bottom') {
		data = data + '<div class="bottom-comment" id="image-comment">'+XWcomments[n]+'</div>';
	}
	return data;
}

function XWaddImageLocationOnMap() {
	if (XWhasLocation[XWcurrent] && XWLocOnMap != null) {
		var divMap = '<div id="map" style="z-index:65555; width:200px; height:100px; position:absolute; top:0; left:0; display:none; background:white;"><xsl:comment> area for maps </xsl:comment></div>';
		var divMapAction = '<div id="map-action" style="z-index:65557; position:absolute; top:0; left:0; display:block"><a id="open" style="cursor: pointer" title="Location on map"><span>Map</span></a></div>';
		$(divMap).appendTo(XW_IMG_QUERY);
		$(divMapAction).appendTo(XW_IMG_QUERY);
		XWLocOnMap.init(XWcurrent);
	}
}


function XWunloadMapBeforeSwitching() {
	if (XWprevious == 0) {
		// if google maps  index then call unload map
		if (XWindex == 'google maps') {
			XWMapUnload();
		}
	} else if (XWhasLocation[XWprevious] && XWLocOnMap != null) {
		XWMapUnload();
		XWRemoveImageLocationOnMap();
	}
}


function XWRemoveImageLocationOnMap() {
	$("#map").remove();
	$("#map-action").remove();
}


/*** THUMBNAILS STATE MANAGEMENT ***/

function XWunsetCurrentThumbnail(i) {
	$(".currentThumbnail").removeAttr("class").wrap('<a onclick="XWgotoImage('+i+')" style="cursor: pointer" class="thumbnailLink" title="'+XWthumbTitles[i]+'"></a>');
}

function XWsetCurrentThumbnail(i) {
	var imgQuery = "img[alt="+i+"]";
	$(imgQuery).parent().replaceWith(XWthumbnails[i]);
}


/*** NAVIGATION BAR STATE MANAGEMENT ***/

function XWbasicForwardState(i) {
	if (i == 1) {
		XWsetForwardEnable(true);
	} else if (i == XWimages.length-1) {
		XWsetForwardEnable(false);
	} else {
		XWsetForwardEnable(true);
	}
	if (i == 0) {
		$("a.forward").attr("title", XWStartShowTitle);
	} else {
		$("a.forward").attr("title", XWforwardLinkTitle);
	}
}

function XWbasicBackwardState(i) {
	if (i == 1) {
		XWsetBackwardEnable(false);
	} else if (i == XWimages.length-1) {
		XWsetBackwardEnable(true);
	} else {
		XWsetBackwardEnable(true);
	}
	$("a.backward").attr("title", XWbackwardLinkTitle);
}

function XWnavigationState(i) {
	if (XWnavigation == "basic") {
		XWbasicBackwardState(i);
		XWbasicForwardState(i);
		return i;
	}
	if (XWnavigation == "circular") {
		XWsetBackwardEnable(true);
		$("a.backward").attr("title", XWbackwardLinkTitle);
		if (i == 0) {
			return XWimages.length -1;
		} else if (i == XWimages.length) {
			return 1;
		}
	}
	if (XWnavigation == "previous" || XWnavigation == "links") {
		if (XWnavigation == "previous") {
			XWbasicForwardState(i);
		}
		if (XWpreviousLink == "" || XWpreviousLink == null) {
			if (i == 1) {
				XWsetBackwardEnable(false);
			} else if (i != 0) {
				XWsetBackwardEnable(true);
				$("a.backward").attr("title", XWbackwardLinkTitle);
			}
		} else {
			XWsetBackwardEnable(true);
			if (i == 1) {				
				$("a.backward").attr("title", XWpreviousLinkTitle);
			} else if (i == 0) {
				XWsetPreviousLink();
			} else {
				$("a.backward").attr("title", XWbackwardLinkTitle);
			}
		}
	}
	if (XWnavigation == "next" || XWnavigation == "links") {
		if (XWnavigation == "next") {
			XWbasicBackwardState(i);
		}
		if (XWnextLink == "" || XWnextLink == null) {
			if (i == XWimages.length -1) {
				XWsetForwardEnable(false);
			} else {
				XWsetForwardEnable(true);
				$("a.forward").attr("title", XWforwardLinkTitle);
			}
		} else {
			XWsetForwardEnable(true);
			if (i == XWimages.length - 1) {
				$("a.forward").attr("title", XWnextLinkTitle);
			} else if (i == XWimages.length) {
				XWsetNextLink();
			} else {
				$("a.forward").attr("title", XWforwardLinkTitle);
			}
		}
	}
	return i;
}

function XWsetPreviousLink() {
	$("a.backward").removeAttr("onclick");
	$("a.backward").attr("href", XWpreviousLink);
}
function XWsetNextLink() {
	$("a.forward").removeAttr("onclick");
	$("a.forward").attr("href", XWnextLink);
}

function XWsetBackwardEnable(value) {
	if (value) {
		if (($("li.h-backward-disabled").length + $("li.v-backward-disabled").length) > 0) {
			$("li.h-backward-disabled span").replaceWith('<a class="backward" style="cursor: pointer" onclick="XWnextImage(-1)" title="Go to backward"><span> &lt; </span></a>');
			$("li.h-backward-disabled").removeAttr("class");
			$("li.v-backward-disabled span").replaceWith('<a class="backward" style="cursor: pointer" onclick="XWnextImage(-1)" title="Go to backward"><span> &lt; </span></a>');
			$("li.v-backward-disabled").removeAttr("class");
		}
	} else {
		$("ul.h-nav-bar a.backward").parents("li").attr("class", "h-backward-disabled");
		$("ul.v-nav-bar a.backward").parents("li").attr("class", "v-backward-disabled");
		$("a.backward").replaceWith("<span> &lt; </span>");
	}
}

function XWsetForwardEnable(value) {
	if (value) {
		if (($("li.h-forward-disabled").length + $("li.v-forward-disabled").length) > 0) {
			$("li.h-forward-disabled span").replaceWith('<a class="forward" style="cursor: pointer" onclick="XWnextImage(1)" title="Go to forward"><span> &gt; </span></a>');
			$("li.h-forward-disabled").removeAttr("class");
			$("li.v-forward-disabled span").replaceWith('<a class="forward" style="cursor: pointer" onclick="XWnextImage(1)" title="Go to forward"><span> &gt; </span></a>');
			$("li.v-forward-disabled").removeAttr("class");
		}
	} else {
		$("ul.h-nav-bar a.forward").parents("li").attr("class", "h-forward-disabled");
		$("ul.v-nav-bar a.forward").parents("li").attr("class", "v-forward-disabled");
		$("a.forward").replaceWith("<span> &gt; </span>");			
	}
}

/*** WAIT (LOAD) SCREEN MANAGEMENT ***/

var XWloaded = new Array();

function XWisLoaded(n) {
	var loaded = XWloaded[n];
	if (loaded == null) {
		loaded = false;
	}
	return loaded;
}

function XWsetIsLoaded(n) {
	XWloaded[n] = true;
}

function XWinitLoadScreen() {
	$('<div id="load" style="position: absolute; z-index: 65000; display: none;"> </div>').insertBefore('#image-container');
}

function XWshowLoadScreen(n) {
	if (XWwaitScreenSize != 'none') {
		if (XWcurrent != 0 && !XWisLoaded(XWcurrent)) {
			if (XWwaitScreenSize == 'full screen') {
				$('#load').css({'width': '100%', 'height': '100%', 'top': 0, 'left': 0});
			} else {
				var container = $('#image-container');
				var off = container.offset();
				$('#load').css({'width': container.width(), 'height': container.height(), 'top': off.top, 'left': off.left});
			}
			$('#load').fadeIn('fast');
		}
	}
}

function XWhideLoadScreen(n) {
	if (XWwaitScreenSize != 'none') {
		if (XWcurrent != 0 && !XWisLoaded(XWcurrent)) {
			XWsetIsLoaded(XWcurrent);
			$("#load").fadeOut(0);
		}
	}
}

/**   ANIMATION CONTROL PANEL   **/
var XWspeeds = new Array();
XWspeeds[0] = 'immediate';
XWspeeds['fast'] = 'fast';
XWspeeds[400] = 'medium';
XWspeeds['slow'] = 'slow';

var XWtext_fr = new Array();
XWtext_fr['Comment'] = 'Commentaire';
XWtext_fr['top'] = 'en haut';
XWtext_fr['bottom'] = 'en bas';
XWtext_fr['Meta data'] = 'Meta données';
XWtext_fr['none'] = 'aucunes';
XWtext_fr['Transition speed'] = 'Vitesse de transition';
XWtext_fr['immediate'] = 'instantané';
XWtext_fr['fast'] = 'rapide';
XWtext_fr['medium'] = 'intermédiaire';
XWtext_fr['slow'] = 'lent';
XWtext_fr['Animation speed'] = "Vitesse d'animation";
XWtext_fr[':'] = ' :';

function getText(word) {
	if (XWlang == 'fr' && XWtext_fr[word] != null) {
		return XWtext_fr[word];
	}
	return word;
}
// elements to control by the end user:
//   - comment position
//   - meta data display and position
//   - transition speed
function XWinitControlPanel() {
	$('<div id="ctrl-wrapper">'+
	  '<div id="ctrl-action"><a onclick="XWtoggleControlPanel()" style="cursor: pointer;"><span>[+]</span></a></div>'+
	  '<div id="ctrl-panel" style="display: none;">'+
	  XWinitCommentDisp()+
	  XWinitMetaDataDisp()+
	  XWinitAnimationSpeed()+'</div>').insertBefore('#image-container');
	XWcommentAfterAction();
	XWmetaDataAfterAction();
	XWanimationSpeedAfterAction();
}

// Comment display position
function XWinitCommentDisp() {
	return '<ul id="comment-disp"><li class="title">'+getText('Comment')+getText(':')+'</li>'+
		   '<li id="disp-cmt-bottom"><span>'+getText('bottom')+'</span></li>'+
	       '<li id="disp-cmt-top"><span>'+getText('top')+'</span></li></ul>';
}
function XWcommentAfterAction() {
	if (XWcommentPos == "top") {
		$("#disp-cmt-bottom > span").wrap('<a onclick="XWchangeCommentDisp()" style="cursor: pointer;"></a>');
		$("#disp-cmt-bottom").removeAttr('class');
		$("#disp-cmt-top").attr('class', 'current-elt');
	} else {
		$("#disp-cmt-top > span").wrap('<a onclick="XWchangeCommentDisp()" style="cursor: pointer;"></a>');
		$("#disp-cmt-top").removeAttr('class');
		$("#disp-cmt-bottom").attr('class', 'current-elt');
	}
}
function XWchangeCommentDisp() { // top -> bottom -> top
	var a = $('#comment-disp > li > a');
	a.replaceWith(a.html());	
	if (XWcommentPos == "top") {
		XWcommentPos = "bottom";
	} else {
		XWcommentPos = "top";
	}
	XWsetCookie(XWCookieCommentPos, XWcommentPos);
	XWapplyChange();
	XWcommentAfterAction();
}

// meta data display
function XWinitMetaDataDisp() {
	return '<ul id="mdata-disp"><li class="title">'+getText('Meta data')+getText(':')+'</li>'+
		   ' <li id="disp-mdata-none"><span>'+getText('none')+'</span></li>'+
		   ' <li id="disp-mdata-bottom"><span>'+getText('bottom')+'</span></li>'+
	       ' <li id="disp-mdata-top"><span>'+getText('top')+'</span></li></ul>';
}
function XWmetaDataAfterAction() {
	$('#mdata-disp > li.current-elt').removeAttr('class');
	if (XWmetadataPos == "top") {
		$("#disp-mdata-none > span").wrap('<a onclick="XWchangeMetaDataDisp(\'none\')" style="cursor: pointer;"></a>');
		$("#disp-mdata-bottom > span").wrap('<a onclick="XWchangeMetaDataDisp(\'bottom\')" style="cursor: pointer;"></a>');
		$('#disp-mdata-top').attr('class', 'current-elt');
	} else if (XWmetadataPos == "bottom") {
		$("#disp-mdata-none > span").wrap('<a onclick="XWchangeMetaDataDisp(\'none\')" style="cursor: pointer;"></a>');
		$("#disp-mdata-top > span").wrap('<a onclick="XWchangeMetaDataDisp(\'top\')" style="cursor: pointer;"></a>');
		$('#disp-mdata-bottom').attr('class', 'current-elt');
	} else {
		$("#disp-mdata-bottom > span").wrap('<a onclick="XWchangeMetaDataDisp(\'bottom\')" style="cursor: pointer;"></a>');
		$("#disp-mdata-top > span").wrap('<a onclick="XWchangeMetaDataDisp(\'top\')" style="cursor: pointer;"></a>');
		$('#disp-mdata-none').attr('class', 'current-elt');
	}
}
function XWchangeMetaDataDisp(value) {
	var a = $('#mdata-disp > li > a:first');
	a.replaceWith(a.html());
	a = $('#mdata-disp > li > a');
	a.replaceWith(a.html());
	XWmetadataPos = value;
	XWsetCookie(XWCookieMetadataDisp, value);
	XWapplyChange();
	XWmetaDataAfterAction();
}

// transition speed none -> fast -> medium -> slow -> nones
function XWinitAnimationSpeed() {
	return '<ul id="anim-speed"><li class="title">'+getText('Animation speed')+getText(':')+'</li>'+
		   '<li id="decrease"><a onclick="XWdecreaseSpeed()" style="cursor: pointer"><span>-</span></a></li>'+
		   '<li id="anim-speed-value"><span></span></li>'+
		   '<li id="increase"><a onclick="XWincreaseSpeed()" style="cursor: pointer"><span>+</span></a></li></ul>'
}
function XWincreaseSpeed() {
	if (XWtransition == 'slow') {
		XWtransition = 400;
	} else if (XWtransition == 400) {
		XWtransition = 'fast';
	} else if (XWtransition == 'fast') {
		XWtransition = 0;
	}
	XWsetCookie(XWCookieAnimationSpeed, XWtransition);
	XWanimationSpeedAfterAction();
}
function XWdecreaseSpeed() {
	if (XWtransition == 0) {
		XWtransition = 'fast';
	} else if (XWtransition == 'fast') {
		XWtransition = 400;
	} else if (XWtransition == 400) {
		XWtransition = 'slow';
	}
	XWsetCookie(XWCookieAnimationSpeed, XWspeeds[XWtransition]);
	XWanimationSpeedAfterAction();
}
function XWanimationSpeedAfterAction() {
	$('#anim-speed-value').attr('class', XWspeeds[XWtransition]);
	$('#anim-speed-value > span').text(getText(XWspeeds[XWtransition]));
}

function XWapplyChange() {
	var c = XWcurrent;
	if (c > 0) {
		XWprevious = -1;
		XWcurrent = 0;
		XWswitchImage(c);
	}
}

// Hides or Shows the control panel
function XWtoggleControlPanel() {
	var ctrlPanel = $('#ctrl-panel');
	var disp = ctrlPanel.css('display');
	if (disp == "none") {
		ctrlPanel.show('slow');
		$('#ctrl-action > a > span').text('[-]');
	} else {
		ctrlPanel.hide('slow');
		$('#ctrl-action > a > span').text('[+]');
	}
}
/***
 COOKIES
***/
var XWcookiesExpiration = 30;
var XWCookieCommentPos = "comment.position";
var XWCookieMetadataDisp = "metadata.display";
var XWCookieAnimationSpeed = "animaiton.speed";
function XWsetCookie(name, value) {
	var expDate = new Date();
	expDate.setTime(expDate.getTime() + (XWcookiesExpiration * 24 * 3600 * 1000));
	document.cookie = name + "=" + escape(value) + ";expires=" + expDate.toGMTString();
}
function XWgetCookie(name) {
	deb = document.cookie.indexOf(name + "=");
	if (deb >= 0) {
		deb += name.length + 1;
		fin = document.cookie.indexOf(";",deb);
		if (fin < 0) {
			fin = document.cookie.length;
		}
		return unescape(document.cookie.substring(deb,fin));
	}
	return "";
}