﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 v1.4.0:
		replace id by class for each element of navigation bar
		to enable more than one navigation bar in a slideshow page
	 v1.6.0:
		Add animation feature
    -->
	<xsl:template match="slideshow-content" mode="NAVIGATION_BAR">
		<xsl:param name="orientation"/>
		<xsl:param name="navigationBar"/>
		<xsl:param name="animation"/>
		<xsl:choose>
			<xsl:when test="$orientation = 'vertical'">
				<xsl:apply-templates select="." mode="RENDERER_NAV_BAR">
					<xsl:with-param name="navigationBar" select="$navigationBar"/>
					<xsl:with-param name="prefix" select="string('h-')"/>
					<xsl:with-param name="animation" select="$animation"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:when test="$orientation = 'horizontal'">
				<xsl:apply-templates select="." mode="RENDERER_NAV_BAR">
					<xsl:with-param name="navigationBar" select="$navigationBar"/>
					<xsl:with-param name="prefix" select="string('v-')"/>
					<xsl:with-param name="animation" select="$animation"/>
				</xsl:apply-templates>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--

     -->
	<xsl:template match="navigation-bar" mode="TYPE">
		<xsl:choose>
			<xsl:when test="@type"><xsl:value-of select="@type"/></xsl:when>
			<xsl:otherwise>basic</xsl:otherwise> <!-- default navigation type -->
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	<xsl:template match="slideshow-content" mode="RENDERER_NAV_BAR">
		<xsl:param name="navigationBar"/>
		<xsl:param name="prefix"/>
		<xsl:param name="animation"/>
		<!-- bakward arrow : if not first image link to previous image, else disabled -->
		<xsl:if test="$navigationBar/previous">
			<xsl:apply-templates select="previous-show">
				<xsl:with-param name="prefix" select="$prefix"/>
				<xsl:with-param name="animation" select="$animation"/>
			</xsl:apply-templates>
		</xsl:if>
		<xsl:if test="$navigationBar/next and $prefix = 'h-'">
			<xsl:apply-templates select="next-show">
				<xsl:with-param name="prefix" select="$prefix"/>
				<xsl:with-param name="animation" select="$animation"/>
			</xsl:apply-templates>
		</xsl:if>
		<div class="{concat($prefix, 'navbar-div')}">
			<ul class="{concat($prefix, 'nav-bar')}">
			   <xsl:if test="$navigationBar/backward">
					<xsl:apply-templates select="." mode="BACKWARD">
						<xsl:with-param name="navigationBar" select="$navigationBar"/>
						<xsl:with-param name="prefix" select="$prefix"/>
						<xsl:with-param name="animation" select="$animation"/>
					</xsl:apply-templates>
				</xsl:if>
				<xsl:if test="$navigationBar/init">
				   <xsl:apply-templates select="." mode="INIT">
						<xsl:with-param name="prefix" select="$prefix"/>
						<xsl:with-param name="animation" select="$animation"/>
				   </xsl:apply-templates>
				</xsl:if>
				<xsl:if test="$navigationBar/forward">
					<xsl:apply-templates select="." mode="FORWARD">
						<xsl:with-param name="navigationBar" select="$navigationBar"/>
						<xsl:with-param name="prefix" select="$prefix"/>
						<xsl:with-param name="animation" select="$animation"/>
					</xsl:apply-templates>
				</xsl:if>
			</ul>
		</div>
		<xsl:if test="$navigationBar/next and $prefix = 'v-'">
			<xsl:apply-templates select="next-show">
					<xsl:with-param name="prefix" select="$prefix"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>
	<!--
	
	 -->
	<xsl:template match="slideshow-content" mode="INIT">
		<xsl:param name="prefix"/>
		<xsl:param name="animation"/>
		<xsl:variable name="href">
			<xsl:call-template name="link-to-current"/>
		</xsl:variable>
		<li><a class="init">
			 <xsl:choose>
				<xsl:when test="$localIndex = 'personal'">
					<xsl:attribute name="href"><xsl:call-template name="link-to-current"/></xsl:attribute>
				</xsl:when>
				<xsl:when test="string-length($animation) != 0">
					<xsl:attribute name="style"><xsl:value-of select="'cursor: pointer'"/></xsl:attribute>
					<xsl:attribute name="onclick">
						<xsl:choose>
							<xsl:when test="$localIndex != 'false'">XWgotoImage(0)</xsl:when>
							<xsl:otherwise>XWgotoImage(1)</xsl:otherwise>
						</xsl:choose>
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$localIndex != 'false'">
							<xsl:attribute name="href"><xsl:call-template name="link-to-current"/></xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="href"><xsl:value-of select="concat(//image[1]/@filename,'.html')"/></xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			 </xsl:choose>
			 <xsl:attribute name="title">
			   	<xsl:call-template name="properties">
			   		<xsl:with-param name="lang" select="$lang"/>
			   		<xsl:with-param name="key">link.init.title</xsl:with-param>
			   	</xsl:call-template>
			 </xsl:attribute>
			<span><xsl:call-template name="properties">
			   		<xsl:with-param name="lang" select="$lang"/>
			   		<xsl:with-param name="key">link.init.text</xsl:with-param>
			   	</xsl:call-template></span></a></li>
	</xsl:template>
	<!--
		In case of non animation: one pahe per image plus one for index if one is generated by Xiss web
		In case of animation: only one page for all images an index if it exists or non personal one.
		This page is positionned on the first image or on the index.
	 -->
	<xsl:template match="slideshow-content" mode="BACKWARD">
	   <xsl:param name="navigationBar"/>
		<xsl:param name="prefix"/>
		<xsl:param name="animation"/>
		<xsl:variable name="navType">
			<xsl:apply-templates select="$navigationBar" mode="TYPE"/>
		</xsl:variable>
		<!--xsl:message>NAV BAR BACKWARD: "<xsl:value-of select="$currentImage"/>" "<xsl:value-of select="$animation"/>(<xsl:value-of select="string-length($animation)"/>)" "<xsl:value-of select="$localIndex"/>" "<xsl:value-of select="$navType"/>"</xsl:message-->
			<!-- bakward arrow : if not first image link to previous image, else disabled -->
			<!-- in cas of animation $currentImage is always true : backwar arrow is disabled only if a non personal "index"
				 is specfied for the slide show and the nav type is not circular -->
		<xsl:choose>
			<xsl:when test="(($currentImage = 'index' and string-length($animation) = 0) or (($localIndex = 'personal' or (number(//image[@filename = $currentImage]/@number) = 1)) and ($navType = 'basic' or $navType = 'next' or (($navType = 'links' or $navType = 'previous') and not(previous-show))))) or (string-length($animation) != 0 and ($localIndex != 'personal' or $localIndex = 'false'))">
				<li class="{concat($prefix, 'backward-disabled')}">
					<span><xsl:call-template name="properties">
					   		<xsl:with-param name="lang" select="$lang"/>
					   		<xsl:with-param name="key">link.backward.text</xsl:with-param>
					   	</xsl:call-template></span>
				</li>
			</xsl:when>
			<xsl:otherwise>
				<li>
					<a class="backward">
						<xsl:choose>
							<xsl:when test="string-length($animation) != 0 and ($navType = 'links' or  $navType = 'previous')">
								<xsl:attribute name="href">
									<xsl:call-template name="link">
										<xsl:with-param name="ref" select="previous-show/@href"/>
										<xsl:with-param name="animation" select="$animation"/>
									</xsl:call-template>
								</xsl:attribute>
							</xsl:when>
							<xsl:when test="string-length($animation) != 0 and $navType != 'links' and  $navType != 'previous'">
								<xsl:attribute name="style"><xsl:value-of select="'cursor: pointer'"/></xsl:attribute>
								<xsl:attribute name="onclick">XWnextImage(-1)</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="href"> <!-- {//image[number(@number) = $prevnb]/@filename}.html" -->
									<xsl:apply-templates select="." mode="BACKWARD_LINK">
										<xsl:with-param name="navType" select="$navType"/>
									</xsl:apply-templates>
								</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:attribute name="title">
							<xsl:call-template name="properties">
								<xsl:with-param name="lang" select="$lang"/>
								<xsl:with-param name="key">link.backward.title</xsl:with-param>
							</xsl:call-template>
						</xsl:attribute>
						<span><xsl:call-template name="properties">
					   		<xsl:with-param name="lang" select="$lang"/>
					   		<xsl:with-param name="key">link.backward.text</xsl:with-param>
					   	</xsl:call-template></span>
					</a>
				</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	
	 -->
   <xsl:template match="slideshow-content" mode="BACKWARD_LINK">
   	<xsl:param name="navType"/>
   	<xsl:choose>
		<xsl:when test="number(//image[@filename = $currentImage]/@number) &gt; 1">
			<xsl:variable name="prevnb" select="number(//image[@filename = $currentImage]/@number)-1"/>
			<xsl:value-of select="concat(//image[number(@number) = $prevnb]/@filename, '.html')"/>
		</xsl:when>
		<xsl:when test="$navType = 'circular'">
		   <xsl:value-of select="concat(images/section[last()]/image[last()]/@filename, '.html')"/>
		</xsl:when>
		<xsl:when test="previous-show and ($navType = 'previous' or $navType = 'links')">
           <xsl:call-template name="link">
              <xsl:with-param name="ref" select="previous-show/@href"/>
            <xsl:with-param name="goto">backward</xsl:with-param>
           </xsl:call-template>
		</xsl:when>
	</xsl:choose>
   </xsl:template>
   <!--
	
	-->
	<xsl:template match="slideshow-content" mode="FORWARD">
		<xsl:param name="navigationBar"/>
		<xsl:param name="prefix"/>
		<xsl:param name="animation"/>
		<xsl:variable name="lastNum" select="count(//image)"/>
		<xsl:variable name="currNum" select="//image[@filename = $currentImage]/@number"/>
		<xsl:variable name="navType">
			<xsl:apply-templates select="$navigationBar" mode="TYPE"/>
		</xsl:variable>
		<!--xsl:message>NAV BAR F <xsl:value-of select="$currNum"/> ... <xsl:value-of select="$lastNum"/></xsl:message-->
		<xsl:choose>
			<!-- forward arrow : if index link to first image, if not last image link to next image, else disabled -->
			<xsl:when test="$currentImage = 'index'">
				<li>
					<a class="forward">
						<xsl:choose>
							<xsl:when test="string-length($animation) = 0">
								<xsl:attribute name="href">
									<xsl:value-of select="concat(images/section[1]/image[1]/@filename, '.html')"/>
								</xsl:attribute>
							</xsl:when>
							<xsl:otherwise>
								<xsl:attribute name="style"><xsl:value-of select="'cursor: pointer'"/></xsl:attribute>
								<xsl:attribute name="onclick">XWnextImage(1)</xsl:attribute>
							</xsl:otherwise>
						</xsl:choose>
					   <xsl:attribute name="title">
					   	<xsl:call-template name="properties">
					   		<xsl:with-param name="lang" select="$lang"/>
					   		<xsl:with-param name="key">link.forward.start</xsl:with-param>
					   	</xsl:call-template>
					   </xsl:attribute>
						<span><xsl:call-template name="properties">
					   		<xsl:with-param name="lang" select="$lang"/>
					   		<xsl:with-param name="key">link.forward.text</xsl:with-param>
					   	</xsl:call-template></span>
					</a>
				</li>
			</xsl:when>
			<xsl:when test="($currNum = $lastNum) and ($navType = 'basic' or $navType = 'previous' or (($navType = 'links' or $navType = 'next') and not(next-show)))">
				<li class="{concat($prefix, 'forward-disabled')}">
					<span><xsl:call-template name="properties">
					   		<xsl:with-param name="lang" select="$lang"/>
					   		<xsl:with-param name="key">link.forward.text</xsl:with-param>
					   	</xsl:call-template></span>
				</li>
			</xsl:when>
			<xsl:otherwise>     <!-- test="(//image[@filename = $currentImage]/@number != $lastNum) or ($navigationBar/@type != 'basic')" -->
				<li>
					<a class="forward">
						<xsl:attribute name="href">
							<xsl:apply-templates select="." mode="FORWARD_LINK">
					   		<xsl:with-param name="navType" select="$navType"/>
							</xsl:apply-templates>
						</xsl:attribute>
					   <xsl:attribute name="title">
					   	<xsl:call-template name="properties">
					   		<xsl:with-param name="lang" select="$lang"/>
					   		<xsl:with-param name="key">link.forward.title</xsl:with-param>
					   	</xsl:call-template>
					   </xsl:attribute>
						<span><xsl:call-template name="properties">
					   		<xsl:with-param name="lang" select="$lang"/>
					   		<xsl:with-param name="key">link.forward.text</xsl:with-param>
					   	</xsl:call-template></span>
					</a>
				</li>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	
	 -->
	<xsl:template match="slideshow-content" mode="FORWARD_LINK">
		<xsl:param name="navType"/>
		<xsl:choose>
			<xsl:when test="number(//image[@filename = $currentImage]/@number) &lt; count(//image)">
				<xsl:variable name="nextnb" select="number(//image[@filename = $currentImage]/@number)+1"/>
				<xsl:value-of select="concat(//image[number(@number) = $nextnb]/@filename, '.html')"/>
			</xsl:when>
			<xsl:when test="$navType = 'circular'">
			   <xsl:value-of select="concat(//image[1]/@filename, '.html')"/>
			</xsl:when>
			<xsl:when test="next-show and ($navType = 'next' or $navType = 'links')">
           <xsl:call-template name="link">
              <xsl:with-param name="ref" select="next-show/@href"/>
            	<xsl:with-param name="goto">forward</xsl:with-param>
           </xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	 <xsl:template match="previous-show">
		<xsl:param name="prefix"/>
		<xsl:param name="animation"/>
	    <div class="{concat($prefix, 'previous')}">&lt; <a>
	        <xsl:attribute name="href">
				<xsl:call-template name="link">
					<xsl:with-param name="ref" select="@href"/>
            		<xsl:with-param name="goto">backward</xsl:with-param>
					<xsl:with-param name="animation" select="$animation"/>
				</xsl:call-template>
	        </xsl:attribute>
			   <xsl:attribute name="title">
			   	<xsl:call-template name="properties">
			   		<xsl:with-param name="lang" select="$lang"/>
			   		<xsl:with-param name="key">link.previous.title</xsl:with-param>
			   	</xsl:call-template>
			   </xsl:attribute>
	       <xsl:value-of select="@text"/></a></div>
	 </xsl:template>
	<!--
	 -->
	 <xsl:template match="next-show">
		<xsl:param name="prefix"/>
		<xsl:param name="animation"/>
	    <div class="{concat($prefix, 'next')}"><a>
	        <xsl:attribute name="href">
	           <xsl:call-template name="link">
					<xsl:with-param name="ref" select="@href"/>
					<xsl:with-param name="goto">forward</xsl:with-param>
					<xsl:with-param name="animation" select="$animation"/>
	           </xsl:call-template>
	        </xsl:attribute>
			   <xsl:attribute name="title">
			   	<xsl:call-template name="properties">
			   		<xsl:with-param name="lang" select="$lang"/>
			   		<xsl:with-param name="key">link.next.title</xsl:with-param>
			   	</xsl:call-template>
			   </xsl:attribute>
	       <xsl:value-of select="@text"/></a> &gt;</div>
	 </xsl:template>
	<!--
	
	 -->
	<xsl:template name="link-to-current">
	   <!--xsl:message>LINK TO CURRENT: <xsl:value-of select="$localIndex"/>, <xsl:value-of select="$web"/></xsl:message-->
	   <xsl:choose>
			<xsl:when test="$web = 'web'"><xsl:value-of select="'.'"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="'./index.html'"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	
	Builds a link to another slideshow: previous and next elements in navigation bar
	or links, previous-links and next-links navigation bar type.
	 -->
	<xsl:template name="link">
		<xsl:param name="ref"/>
		<xsl:param name="goto"/> <!-- backward, forward -->
		<xsl:param name="animation"/>
		<xsl:variable name="path" select="substring-before($contentFile, 'slideshow.xml')"/>
		<xsl:variable name="refFile" select="concat($path, $ref, '/slideshow.xml')"/>
		<!--xsl:message>LINK : "<xsl:value-of select="$path"/>" "<xsl:value-of select="$ref"/>" "<xsl:value-of select="$animation"/>"</xsl:message-->
		<xsl:choose>
			<xsl:when test="string-length($animation) != 0"> <!-- If the current slideshow is animated, then the linked ones should be animated too. -->
				<xsl:choose>                   <!-- In this case an index page exists always. -->
					<xsl:when test="$web = 'web'">
						<xsl:value-of select="concat($ref, '/')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="concat($ref, '/', 'index.html')"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="$goto = 'forward'">
				<xsl:value-of select="concat($ref, '/', document($refFile)/slideshow-content/images/section[1]/image[1]/@filename, '.html')"/>
			</xsl:when>
			<xsl:when test="$goto = 'backward'">
				<xsl:value-of select="concat($ref, '/', document($refFile)/slideshow-content/images/section[last()]/image[last()]/@filename, '.html')"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
</xsl:stylesheet>
