﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--
	 -->
	<xsl:template name="properties">
		<xsl:param name="lang"/>
		<xsl:param name="key"/>
		<xsl:choose>
			<xsl:when test="$lang = 'en'">
				<xsl:call-template name="properties-en">
					<xsl:with-param name="key" select="$key"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$lang = 'fr'">
				<xsl:call-template name="properties-fr">
					<xsl:with-param name="key" select="$key"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="properties-en">
					<xsl:with-param name="key" select="$key"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	<xsl:template name="properties-en">
		<xsl:param name="key"/>
		<!--xsl:message>properties en : key = <xsl:value-of select="$key"/></xsl:message-->
		<xsl:choose>
			<xsl:when test="$key = 'main.index.title'">Slide Show Main Index</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'link.home.text'">Home</xsl:when>
			<xsl:when test="$key = 'link.home.title'">Go to home page</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'page.index.text'">Click on a thumbnail or click on arrows to navigate.</xsl:when>
			<xsl:when test="$key = 'page.index.link'">Click here to start.</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'link.init.title'">Return at the first page of the slideshow</xsl:when>
			<xsl:when test="$key = 'link.init.text'"> o </xsl:when>
			<xsl:when test="$key = 'link.previous.title'">Go to previous slideshow</xsl:when>
			<xsl:when test="$key = 'link.forward.text'"> &gt; </xsl:when>
			<xsl:when test="$key = 'link.forward.title'">Go to forward</xsl:when>
			<xsl:when test="$key = 'link.forward.start'">Start the slideshow</xsl:when>
			<xsl:when test="$key = 'link.backward.text'"> &lt; </xsl:when>
			<xsl:when test="$key = 'link.backward.title'">Go to backward</xsl:when>
			<xsl:when test="$key = 'link.next.title'">Go to next slideshow</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'built-with.title'">Go to the "Xiss web" web site</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'no.flash'">no flash</xsl:when>
			<xsl:when test="$key = 'yes.flash'">with flash</xsl:when>
			<xsl:when test="$key = 'show.hide.map'">Show/hide image location on a map.</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'map.action'">Map</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
	<xsl:template name="properties-fr">
		<xsl:param name="key"/>
		<!--xsl:message>properties en : key = <xsl:value-of select="$key"/></xsl:message-->
		<xsl:choose>
			<xsl:when test="$key = 'main.index.title'">Indexe principal du diaporama</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'link.home.text'">Accueil</xsl:when>
			<xsl:when test="$key = 'link.home.title'">Aller a la page d'accueil</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'page.index.text'">Cliquez sur les images ou utilisez les flèches pour passer d'une image à l'autre.</xsl:when>
			<xsl:when test="$key = 'page.index.link'">Cliquez ici pour démarrer.</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'link.init.title'">Retourner à la première page du diaporama</xsl:when>
			<xsl:when test="$key = 'link.init.text'"> o </xsl:when>
			<xsl:when test="$key = 'link.previous.title'">Aller au diaporama précédant</xsl:when>
			<xsl:when test="$key = 'link.forward.text'"> &gt; </xsl:when>
			<xsl:when test="$key = 'link.forward.title'">Aller en avant</xsl:when>
			<xsl:when test="$key = 'link.forward.start'">Démarrer le diaporama</xsl:when>
			<xsl:when test="$key = 'link.backward.text'"> &lt; </xsl:when>
			<xsl:when test="$key = 'link.backward.title'">Aller en arrière</xsl:when>
			<xsl:when test="$key = 'link.next.title'">Aller au diaporama suivant</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'built-with.title'">Aller sur le site internet de "Xiss web"</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'no.flash'">sans flash</xsl:when>
			<xsl:when test="$key = 'yes.flash'">avec flash</xsl:when>
			<xsl:when test="$key = 'show.hide.map'">Montrer/cahcher l'emplacement de l'image sur une carte.</xsl:when>
			<!-- -->
			<xsl:when test="$key = 'map.action'">Carte</xsl:when>
		</xsl:choose>
	</xsl:template>
	<!--
	 -->
</xsl:stylesheet>
