<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<!--
	 -->
	<xsl:template match="/">
		<!--xsl:message>Images count = <xsl:value-of select="count($contentDoc//image)"/></xsl:message-->
		<xsl:apply-templates select="slideshow-layout"/>
	</xsl:template>
	<!--
		if the image-area element haven't child element comment-position, add it
	 -->
	<xsl:template match="image-area">
		<xsl:if test="not(comment-position)">
		   <image-area width="{@width}" height="{@height}">
		   	<comment position="{@comment-position}" number-format="@#/%+"/>
		   </image-area>
	   </xsl:if>
	</xsl:template>
	<!--
	By default copy all identicaly
	 -->
	<xsl:template match="@*|node()">
	   <xsl:copy>
	      <xsl:apply-templates select="@*|node()"/>
	   </xsl:copy>
	</xsl:template>
	<!--
	 -->
</xsl:stylesheet>
