/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.Vector;

public class MVBond
implements Serializable {
    private MVAtom atom1;
    private MVAtom atom2;
    private int bondOrder;

    public MVBond(MVAtom mVAtom, MVAtom mVAtom2, int n) {
        this.atom1 = mVAtom;
        this.atom2 = mVAtom2;
        this.bondOrder = n;
    }

    public boolean isDrawableBond(MVAtom mVAtom, Vector vector) {
        double d;
        MVAtom mVAtom2 = null;
        if (mVAtom == this.atom1) {
            mVAtom2 = this.atom2;
        }
        if (mVAtom == this.atom2) {
            mVAtom2 = this.atom1;
        }
        if (mVAtom2 == null) {
            return false;
        }
        double d2 = mVAtom.getZ();
        return !(d2 > (d = mVAtom2.getZ()));
    }

    public void paint(Graphics graphics, Color color, Color color2, boolean bl, boolean bl2) {
        Object object;
        if (this.atom1.getZ() > this.atom2.getZ()) {
            object = this.atom1;
            this.atom1 = this.atom2;
            this.atom2 = object;
        }
        object = this.atom1.getScreenXYZ();
        double[] dArray = this.atom2.getScreenXYZ();
        double d = this.atom1.getScreenRadius();
        double d2 = this.atom2.getScreenRadius();
        double d3 = d / (d + d2);
        double[] dArray2 = new double[]{(double)(object[0] + (dArray[0] - object[0]) * d3), (double)(object[1] + (dArray[1] - object[1]) * d3), (double)(object[2] + (dArray[2] - object[2]) * d3)};
        double d4 = d + (d2 - d) * d3;
        double d5 = d / this.atom1.getRadius();
        double d6 = d2 / this.atom2.getRadius();
        double d7 = d5 + (d6 - d5) * d3;
        double d8 = dArray[0] - object[0];
        double d9 = dArray[1] - object[1];
        double d10 = dArray[2] - object[2];
        double d11 = Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = d11 - d * 0.9;
        if (bl2) {
            d12 = d11;
        }
        double d13 = d12 / d11;
        object[0] = dArray[0] - d8 * d13;
        object[1] = dArray[1] - d9 * d13;
        object[2] = dArray[2] - d10 * d13;
        if (!bl2) {
            if (bl) {
                color2 = this.atom1.getColor();
            }
            this.paintCylinderBond(graphics, color, color2, (double[])object, dArray2, d, d4, d5, d7);
            if (bl) {
                color2 = this.atom2.getColor();
            }
            this.paintCylinderBond(graphics, color, color2, dArray2, dArray, d4, d2, d7, d6);
            return;
        }
        if (bl) {
            color = this.atom1.getColor();
        }
        this.paintWireframeBond(graphics, color, (double[])object, dArray2, d, d4, d5, d7);
        if (bl) {
            color = this.atom2.getColor();
        }
        this.paintWireframeBond(graphics, color, dArray2, dArray, d4, d2, d7, d6);
    }

    private void paintWireframeBond(Graphics graphics, Color color, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        double d5 = 0.15;
        if (this.bondOrder == 2) {
            d5 = 0.1;
        }
        double d6 = dArray2[0] - dArray[0];
        double d7 = dArray2[1] - dArray[1];
        double d8 = Math.atan2(d7, d6);
        double d9 = d5 * d3 * Math.sin(d8);
        double d10 = d5 * d3 * Math.cos(d8);
        double d11 = d5 * d4 * Math.sin(d8);
        double d12 = d5 * d4 * Math.cos(d8);
        graphics.setColor(color);
        if (this.bondOrder == 2 || this.bondOrder == 3) {
            graphics.drawLine((int)(dArray[0] + d9), (int)(dArray[1] - d10), (int)(dArray2[0] + d11), (int)(dArray2[1] - d12));
            graphics.drawLine((int)(dArray[0] - d9), (int)(dArray[1] + d10), (int)(dArray2[0] - d11), (int)(dArray2[1] + d12));
            if (this.bondOrder == 2) {
                return;
            }
        }
        graphics.drawLine((int)dArray[0], (int)dArray[1], (int)dArray2[0], (int)dArray2[1]);
    }

    private void paintCylinderBond(Graphics graphics, Color color, Color color2, double[] dArray, double[] dArray2, double d, double d2, double d3, double d4) {
        double d5 = 0.15;
        double d6 = dArray2[0] - dArray[0];
        double d7 = dArray2[1] - dArray[1];
        double d8 = dArray2[2] - dArray[2];
        double d9 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8);
        double d10 = Math.atan2(d7, d6);
        double d11 = d5 * d3 * Math.sin(d10);
        double d12 = d5 * d3 * Math.cos(d10);
        double d13 = d5 * d4 * Math.sin(d10);
        double d14 = d5 * d4 * Math.cos(d10);
        Polygon polygon = new Polygon();
        polygon.addPoint((int)Math.rint(dArray[0] + d11), (int)Math.rint(dArray[1] - d12));
        polygon.addPoint((int)Math.rint(dArray2[0] + d13), (int)Math.rint(dArray2[1] - d14));
        polygon.addPoint((int)Math.rint(dArray2[0] - d13), (int)Math.rint(dArray2[1] + d14));
        polygon.addPoint((int)Math.rint(dArray[0] - d11), (int)Math.rint(dArray[1] + d12));
        double d15 = Math.atan2(-d12, d11);
        Math.atan2(d12, -d11);
        double d16 = d5 * d3;
        double d17 = Math.cos(d8 / d9 * 1.5707963267948966);
        int n = 0;
        while (n <= 180) {
            double d18 = (double)n * Math.PI / 180.0;
            double d19 = d15 + d18;
            double d20 = 1.0 - d17 * Math.sin(d18);
            if (d20 < 0.25) {
                d20 = 0.25;
            }
            double d21 = dArray[0] - d16 * d20 * Math.cos(d19);
            double d22 = dArray[1] - d16 * d20 * Math.sin(d19);
            polygon.addPoint((int)Math.rint(d21), (int)Math.rint(d22));
            n += 20;
        }
        polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
        graphics.setColor(color2);
        graphics.fillPolygon(polygon);
        graphics.setColor(color);
        graphics.drawPolygon(polygon);
    }
}

