/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class MVMatrix
implements Serializable {
    private double[][] matrix = new double[4][4];

    public MVMatrix() {
        this.unitMatrix();
    }

    private void unitMatrix() {
        int n = 0;
        while (n <= 3) {
            int n2 = 0;
            while (n2 <= 3) {
                this.matrix[n][n2] = 0.0;
                ++n2;
            }
            this.matrix[n][n] = 1.0;
            ++n;
        }
    }

    public void shiftMatrix(double[] dArray) {
        this.unitMatrix();
        this.matrix[0][3] = dArray[0];
        this.matrix[1][3] = dArray[1];
        this.matrix[2][3] = dArray[2];
    }

    public void scaleMatrix(double[] dArray) {
        this.unitMatrix();
        this.matrix[0][0] = dArray[0];
        this.matrix[1][1] = dArray[1];
        this.matrix[2][2] = dArray[2];
    }

    public void rotateMatrix(double d, String string) {
        double d2 = Math.PI / 180;
        double d3 = Math.cos(d * d2);
        double d4 = Math.sin(d * d2);
        this.unitMatrix();
        if (string.indexOf("X") >= 0) {
            this.matrix[2][2] = d3;
            this.matrix[1][1] = d3;
            this.matrix[1][2] = -d4;
            this.matrix[2][1] = d4;
        }
        if (string.indexOf("Y") >= 0) {
            this.matrix[0][0] = d3;
            this.matrix[2][2] = d3;
            this.matrix[0][2] = d4;
            this.matrix[2][0] = -d4;
        }
        if (string.indexOf("Z") >= 0) {
            this.matrix[0][0] = d3;
            this.matrix[1][1] = d3;
            this.matrix[0][1] = -d4;
            this.matrix[1][0] = d4;
        }
    }

    public double[] transformPoint(double[] dArray) {
        double[] dArray2 = new double[]{this.matrix[0][0] * dArray[0] + this.matrix[0][1] * dArray[1] + this.matrix[0][2] * dArray[2] + this.matrix[0][3], this.matrix[1][0] * dArray[0] + this.matrix[1][1] * dArray[1] + this.matrix[1][2] * dArray[2] + this.matrix[1][3], this.matrix[2][0] * dArray[0] + this.matrix[2][1] * dArray[1] + this.matrix[2][2] * dArray[2] + this.matrix[2][3]};
        double d = this.matrix[3][0] * dArray[0] + this.matrix[3][1] * dArray[1] + this.matrix[3][2] * dArray[2] + this.matrix[3][3];
        if (Math.abs(d) < 1.0E-5) {
            d = 1.0E-5;
        }
        d = 1.0 / d;
        dArray2[0] = dArray2[0] * d;
        dArray2[1] = dArray2[1] * d;
        dArray2[2] = dArray2[2] * d;
        return dArray2;
    }
}

