/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StreamTokenizer;

public class MVReadData
implements Serializable {
    public static MVMolecule createDataSet(MVMolecule mVMolecule) {
        MVMolecule mVMolecule2 = new MVMolecule(mVMolecule, "Water");
        mVMolecule2.addAtom(8, 0.0, 0.0, 0.0);
        mVMolecule2.addAtom(1, 0.5, 0.2, 0.0);
        mVMolecule2.addAtom(1, -0.5, 0.2, 0.0);
        return mVMolecule2;
    }

    public MVMolecule readDataSet(File file, MVMolecule mVMolecule) {
        MVMolecule mVMolecule2 = new MVMolecule(mVMolecule, file.getName());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            String string = file.getName();
            if (string.endsWith(".xyz")) {
                this.readXYZDataSet(mVMolecule2, streamTokenizer);
                return mVMolecule2;
            }
        }
        catch (Exception exception) {}
        System.out.println(">>> Error reading in the molecule file : " + file);
        return null;
    }

    public void readXYZDataSet(MVMolecule mVMolecule, StreamTokenizer streamTokenizer) throws Exception {
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        boolean bl = false;
        do {
            switch (streamTokenizer.nextToken()) {
                case -1: {
                    bl = true;
                    break;
                }
                case -3: {
                    String string = streamTokenizer.sval;
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    if (streamTokenizer.nextToken() == -2) {
                        d = streamTokenizer.nval;
                        if (streamTokenizer.nextToken() == -2) {
                            d2 = streamTokenizer.nval;
                            if (streamTokenizer.nextToken() == -2) {
                                d3 = streamTokenizer.nval;
                            }
                        }
                    }
                    mVMolecule.addAtom(string, d, d2, d3);
                    while (streamTokenizer.ttype != 10 && streamTokenizer.ttype != -1) {
                        streamTokenizer.nextToken();
                    }
                    break block0;
                }
            }
        } while (!bl);
    }
}

