/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIButton;
import emsl.awt.GUIChoice;
import emsl.awt.GUIColorIconBox;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpButton;
import emsl.objects.FontPlus;
import emsl.objects.TextStyle;
import emsl.system.UndoGroup;
import emsl.text.AttributeList;
import emsl.text.TextData;
import emsl.text.TextPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class GUIStyleBar
extends GUIPanel
implements ActionListener {
    private int iconHeight;
    private Dimension iconSize;
    private GUIPanel panel;
    private ActionListener listener;
    private TextStyle textStyle;
    private TextPanel textPanel;
    private GUIChoice fontName;
    private GUIChoice fontSize;
    private GUIButton bold;
    private GUIButton italic;
    private GUIButton underline;
    private GUIButton superscript;
    private GUIButton subscript;
    private GUIPopUpButton textColor;
    private GUIButton left;
    private GUIButton center;
    private GUIButton right;
    private GUIButton justify;
    private GUIButton line10;
    private GUIButton line15;
    private GUIButton line20;
    private GUIButton textMarkers;

    public GUIStyleBar(ActionListener actionListener) {
        super(new Dimension(-1, -2), 1);
        this.setLayout(new FlowLayout(0, 10, 2));
        this.iconHeight = 33;
        this.iconSize = new Dimension(33, 33);
        this.listener = actionListener;
        this.newGroup();
        this.panel.add(this.createFontNameChoice());
        this.newGroup();
        this.panel.add(this.createFontSizeChoice());
        this.newGroup();
        this.bold = this.add("Bold", "bold.gif", true);
        this.italic = this.add("Italic", "italic.gif", true);
        this.underline = this.add("Underline", "underline.gif", true);
        this.newGroup();
        this.superscript = this.add("Superscript", "superscript.gif", true);
        this.subscript = this.add("Subscript", "subscript.gif", true);
        this.newGroup();
        this.panel.add(this.createTextColorPopUp());
        this.newGroup();
        this.left = this.add("Align Left", "left.gif", true);
        this.center = this.add("Align Center", "center.gif", true);
        this.right = this.add("Align Right", "right.gif", true);
        this.justify = this.add("Justify", "justify.gif", true);
        this.newGroup();
        this.line10 = this.add("Single Line Spacing", "line10.gif", true);
        this.line15 = this.add("One And A Half Line Spacing", "line15.gif", true);
        this.line20 = this.add("Double Line Spacing", "line20.gif", true);
        this.newGroup();
        this.textMarkers = this.add("Show / Hide Text Markers", "markers.gif", true);
    }

    private GUIChoice createFontNameChoice() {
        this.fontName = new GUIChoice(new Dimension(150, this.iconHeight));
        this.fontName.setChoices("SansSerif, Serif, Monospaced");
        this.fontName.addActionListener(this);
        this.fontName.setTipText("Font Name");
        return this.fontName;
    }

    private GUIChoice createFontSizeChoice() {
        this.fontSize = new GUIChoice(new Dimension(50, this.iconHeight));
        this.fontSize.setChoices("6,8,9,10,12,14,18,24,28,32,36,48,60");
        this.fontSize.addActionListener(this);
        this.fontSize.setTipText("Font Size");
        this.fontSize.select("12", false);
        return this.fontSize;
    }

    private GUIPopUpButton createTextColorPopUp() {
        this.textColor = new GUIPopUpButton(this.iconSize, new GUIColorIconBox());
        this.textColor.setImage(this.getClass(), "icons", "textColor.gif");
        this.textColor.addActionListener(this);
        this.textColor.setTipText("Text Color");
        return this.textColor;
    }

    private void newGroup() {
        this.panel = new GUIPanel();
        this.panel.setLayout(new FlowLayout(0, 0, 1));
        this.add(this.panel);
    }

    private GUIButton add(String string, String string2, boolean bl) {
        GUIButton gUIButton = new GUIButton(this.iconSize, this.getClass(), "icons", string2);
        gUIButton.setName(string);
        gUIButton.addActionListener(this);
        gUIButton.setTipText(string);
        if (bl) {
            gUIButton.setBehaviour(1);
        }
        this.panel.add(gUIButton);
        return gUIButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.subscript) {
            this.superscript.deSelect(true);
        }
        if (object == this.superscript) {
            this.subscript.deSelect(true);
        }
        if (object == this.left || object == this.center || object == this.right || object == this.justify) {
            this.left.select(object == this.left, true);
            this.right.select(object == this.right, true);
            this.center.select(object == this.center, true);
            this.justify.select(object == this.justify, true);
        }
        if (object == this.line10 || object == this.line15 || object == this.line20) {
            this.line10.select(object == this.line10, true);
            this.line15.select(object == this.line15, true);
            this.line20.select(object == this.line20, true);
        }
        this.listener.actionPerformed(actionEvent);
        if (this.textPanel != null) {
            this.applyStyling(object);
            this.textPanel.getTextCursor().setCursorPosition(this.textPanel.getTextCursor().getCursorPosition());
        }
    }

    public void applyStyling(Object object) {
        Object object2;
        Object object3;
        int n;
        Object object4 = this.textPanel.getTextData().getStyleList().clone();
        boolean bl = false;
        int n2 = n = this.textPanel.getTextCursor().getCursorPosition();
        if (this.textPanel.getTextSelector().isSelected()) {
            bl = true;
            n = this.textPanel.getTextSelector().getSelectionStart();
            if (n > (n2 = this.textPanel.getTextSelector().getSelectionEnd())) {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
        }
        if (object == this.left || object == this.right || object == this.center || object == this.justify || object == this.line10 || object == this.line15 || object == this.line20) {
            bl = true;
            n = this.textPanel.getTextSelector().getLineBoundary(n, 0);
            n2 = this.textPanel.getTextSelector().getLineBoundary(n2, 1);
        }
        if (n == 1) {
            n = 0;
        }
        TextData textData = this.textPanel.getTextData();
        TextStyle textStyle = textData.getTextStyle(n2 + 1);
        Object object5 = null;
        int n4 = n;
        while (n4 <= n2) {
            object3 = textData.getTextStyle(n4);
            if (object3 != null && object3 != object5) {
                object3 = (TextStyle)((TextStyle)object3).clone();
                object2 = ((TextStyle)object3).getFontPlus();
                if (object == this.bold) {
                    ((FontPlus)object2).setBold(this.bold.isSelected());
                }
                if (object == this.italic) {
                    ((FontPlus)object2).setItalic(this.italic.isSelected());
                }
                if (object == this.underline) {
                    ((FontPlus)object2).setUnderline(this.underline.isSelected());
                }
                if (object == this.subscript) {
                    ((FontPlus)object2).setSubScript(this.subscript.isSelected());
                }
                if (object == this.superscript) {
                    ((FontPlus)object2).setSuperScript(this.superscript.isSelected());
                }
                if (object == this.left) {
                    ((TextStyle)object3).setAlignment(1);
                }
                if (object == this.right) {
                    ((TextStyle)object3).setAlignment(2);
                }
                if (object == this.center) {
                    ((TextStyle)object3).setAlignment(3);
                }
                if (object == this.justify) {
                    ((TextStyle)object3).setAlignment(4);
                }
                if (object == this.line10) {
                    ((TextStyle)object3).setSpacing(1);
                }
                if (object == this.line15) {
                    ((TextStyle)object3).setSpacing(3);
                }
                if (object == this.line20) {
                    ((TextStyle)object3).setSpacing(2);
                }
                if (object == this.textColor) {
                    ((TextStyle)object3).setForeground(this.textColor.getBackground());
                }
                if (object == this.fontName) {
                    ((TextStyle)object3).setFontName(this.fontName.getText());
                }
                if (object == this.fontSize) {
                    ((TextStyle)object3).setFontSize(new Integer(this.fontSize.getText()));
                }
                if (bl) {
                    textData.setTextStyle((TextStyle)object3, n4);
                }
                object5 = object3;
            }
            ++n4;
        }
        if (bl) {
            if (textStyle != null) {
                textData.setTextStyle(textStyle, n2 + 1);
            }
            object3 = this.textPanel.getTextData().getStyleList().clone();
            object2 = this.textPanel.getTextUndo().getUndoGroup("Styling");
            this.textPanel.getTextUndo().setUndoStyle((UndoGroup)object2, n, n2, (AttributeList)object4, (AttributeList)object3);
            this.textPanel.getTextUndo().setUndoGroup((UndoGroup)object2);
            this.textPanel.layoutRange(n, n2 + 1);
            this.textPanel.sendActionEvent("Update Menus");
            return;
        }
        textData.setNextTextStyle((TextStyle)object5, n);
    }

    private void setFontName() {
        this.fontName.select(this.textStyle.getFontName(), true);
    }

    private void setFontSize() {
        this.fontSize.select(String.valueOf(this.textStyle.getFontSize()), true);
    }

    private void setTextAttributes() {
        FontPlus fontPlus = this.textStyle.getFontPlus();
        this.bold.select(fontPlus.isBold(), true);
        this.italic.select(fontPlus.isItalic(), true);
        this.underline.select(fontPlus.isUnderline(), true);
        this.superscript.select(fontPlus.isSuperScript(), true);
        this.subscript.select(fontPlus.isSubScript(), true);
    }

    private void setTextColor() {
        Color color = this.textStyle.getForeground();
        this.textColor.select(color, true);
    }

    private void setTextAlign() {
        int n = this.textStyle.getAlignment();
        this.left.select(n == 1, true);
        this.center.select(n == 3, true);
        this.right.select(n == 2, true);
        this.justify.select(n == 4, true);
    }

    private void setTextSpacing() {
        int n = this.textStyle.getSpacing();
        this.line10.select(n == 1, true);
        this.line15.select(n == 3, true);
        this.line20.select(n == 2, true);
    }

    public boolean getMarkerVisible() {
        return this.textMarkers.isSelected();
    }

    public void setTextStyle(TextPanel textPanel) {
        if (textPanel == null) {
            return;
        }
        this.textPanel = textPanel;
        int n = textPanel.getTextCursor().getCursorPosition();
        if (textPanel.getTextSelector().isSelected()) {
            n = textPanel.getTextSelector().getSelectionStart();
        }
        this.textStyle = textPanel.getTextData().getTextStyle(n);
        this.fontName.select(this.textStyle.getFontName(), true);
        this.fontSize.select(String.valueOf(this.textStyle.getFontSize()), true);
        this.setTextAttributes();
        this.setTextColor();
        this.setTextAlign();
        this.setTextSpacing();
    }
}

