/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIButton;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

public class GUIDialogueBox
extends Dialog
implements ActionListener {
    private Frame parent;
    private GUIPanel displayPanel;
    private GUIPanel exitPanel;
    private GUIButton defaultButton;
    private String exitButtonText;
    private GUIButton windowCloseButton;
    private boolean isDisposed;

    public GUIDialogueBox(Frame frame, String string, boolean bl) {
        super(frame, string, true);
        if (frame == null) {
            return;
        }
        this.enableEvents(64L);
        ((Component)this).setBackground(Color.lightGray);
        this.parent = frame;
        GUIPopUpManager gUIPopUpManager = null;
        if (bl) {
            gUIPopUpManager = new GUIPopUpManager(this);
        }
        this.setLayout(new BorderLayout(5, 5));
        this.exitPanel = new GUIPanel(1);
        this.add("South", this.exitPanel);
        this.displayPanel = new GUIPanel(1);
        this.add("Center", this.displayPanel);
    }

    public GUIPanel getDisplayPanel() {
        return this.displayPanel;
    }

    protected boolean isDefaultButtonAllowed() {
        return false;
    }

    public GUIButton addExitButton(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (!this.isDefaultButtonAllowed()) {
            bl = false;
        }
        GUIPanel gUIPanel = new GUIPanel();
        gUIPanel.setLayout(new FlowLayout(1, 1, 1));
        gUIPanel.setBackground(Color.black);
        GUIButton gUIButton = new GUIButton(new Dimension(120, -2), "DialogueExitButton");
        gUIButton.setText(string);
        gUIButton.setBackground(Color.lightGray);
        gUIButton.addActionListener(this);
        gUIPanel.add(gUIButton);
        this.exitPanel.add(gUIPanel);
        if (bl) {
            this.defaultButton = gUIButton;
            gUIPanel.setLayout(new FlowLayout(1, 2, 2));
            this.setWindowCloseButton(gUIButton);
        }
        return gUIButton;
    }

    public void addExitButtons(String string, String string2, String string3, String string4) {
        if (string != null) {
            this.addExitButton(string, string2 == null);
        }
        if (string2 != null) {
            this.addExitButton(string2, string3 == null);
        }
        if (string3 != null) {
            this.addExitButton(string3, string4 == null);
        }
        if (string4 != null) {
            this.addExitButton(string4, true);
        }
    }

    public void addExitButtons(String string, String string2, String string3) {
        this.addExitButtons(string, string2, string3, null);
    }

    public void addExitButtons(String string, String string2) {
        this.addExitButtons(string, string2, null, null);
    }

    public void addExitButtons(String string) {
        this.addExitButtons(string, null, null, null);
    }

    public GUIButton getDefaultButton() {
        return this.defaultButton;
    }

    public String getExitButton() {
        return this.exitButtonText;
    }

    protected boolean exitButtonPressed(GUIButton gUIButton) {
        this.exitButtonText = "";
        if (gUIButton == null) {
            return false;
        }
        if (!gUIButton.getName().equals("DialogueExitButton")) {
            return false;
        }
        this.exitButtonText = gUIButton.getText();
        ((Component)this).setVisible(false);
        this.dispose();
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(object instanceof GUIButton)) {
            return;
        }
        this.exitButtonPressed((GUIButton)object);
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        super.dispose();
    }

    public void display() {
        this.isDisposed = false;
        this.pack();
        Rectangle rectangle = this.parent.getBounds();
        Rectangle rectangle2 = this.getBounds();
        int n = rectangle.width / 2 - rectangle2.width / 2 + rectangle.x;
        int n2 = rectangle.height / 2 - rectangle2.height / 2 + rectangle.y;
        ((Component)this).setLocation(n, n2);
        this.show();
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.exitButtonPressed(this.windowCloseButton);
        }
        super.processWindowEvent(windowEvent);
    }

    public void setWindowCloseButton(GUIButton gUIButton) {
        this.windowCloseButton = gUIButton;
    }
}

