/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIButton;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpManager;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class GUIIconBox
extends GUIPanel {
    public static final int UNLIMITED_COLUMNS = 999;
    private Vector iconList;
    private String name;
    private int columns;
    private int gap;
    private Dimension size;
    private ActionListener actionListener;
    private GUIButton eventSource;
    private boolean layMeOut;
    private GUIPopUpManager popUpManager;

    public GUIIconBox(int n, int n2, String string) {
        super(1);
        this.columns = n;
        this.gap = n2;
        this.name = string;
        this.size = new Dimension(0, 0);
        this.iconList = new Vector();
        this.enableEvents(48L);
        this.layMeOut = true;
    }

    public GUIIconBox(int n, int n2) {
        this(n, n2, "NoName");
    }

    public GUIIconBox(int n) {
        this(n, 0, "NoName");
    }

    public void add(GUIButton gUIButton) {
        this.iconList.addElement(gUIButton);
        if (gUIButton.getBackground() == null) {
            gUIButton.setBackground(Color.lightGray);
        }
        gUIButton.setBehaviour(2);
        this.layMeOut = true;
    }

    public void remove(GUIButton gUIButton) {
        this.iconList.removeElement(gUIButton);
        this.layMeOut = true;
    }

    public void removeAll() {
        this.iconList.removeAllElements();
        this.layMeOut = true;
    }

    public void setColumns(int n) {
        this.columns = n;
        this.layMeOut = true;
    }

    public void setGap(int n) {
        this.gap = n;
        this.layMeOut = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void select(GUIButton gUIButton, boolean bl) {
        if (this.iconList == null) {
            return;
        }
        if (gUIButton == null) {
            return;
        }
        this.deSelectAll(bl);
        this.setState(gUIButton, 1, bl);
    }

    public void select(Color color, boolean bl) {
        if (this.iconList == null) {
            return;
        }
        if (color == null) {
            return;
        }
        int n = color.getRed();
        int n2 = color.getBlue();
        int n3 = color.getGreen();
        double d = 99999.0;
        GUIButton gUIButton = null;
        Enumeration enumeration = this.iconList.elements();
        while (enumeration.hasMoreElements()) {
            int n4;
            int n5;
            Color color2;
            GUIButton gUIButton2 = (GUIButton)enumeration.nextElement();
            if (gUIButton2 == null || (color2 = gUIButton2.getBackground()) == null) continue;
            int n6 = n - color2.getRed();
            double d2 = Math.sqrt(n6 * n6 + (n5 = n3 - color2.getGreen()) * n5 + (n4 = n2 - color2.getBlue()) * n4);
            if (d2 < d) {
                d = d2;
                gUIButton = gUIButton2;
            }
            if (!color2.equals(color)) continue;
            gUIButton = gUIButton2;
        }
        if (gUIButton != null) {
            this.select(gUIButton, bl);
        }
    }

    public void select(String string, boolean bl) {
        if (this.iconList == null) {
            return;
        }
        if (string == null) {
            return;
        }
        GUIButton gUIButton = null;
        Enumeration enumeration = this.iconList.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            GUIButton gUIButton2 = (GUIButton)enumeration.nextElement();
            if (gUIButton2 == null || !(string2 = gUIButton2.getName()).equals(string)) continue;
            gUIButton = gUIButton2;
        }
        if (gUIButton != null) {
            this.select(gUIButton, bl);
        }
    }

    public void deSelectAll(boolean bl) {
        if (this.iconList == null) {
            return;
        }
        Enumeration enumeration = this.iconList.elements();
        while (enumeration.hasMoreElements()) {
            GUIButton gUIButton = (GUIButton)enumeration.nextElement();
            if (gUIButton == null || gUIButton.getState() != 1 && gUIButton.getPrivateState() != 1) continue;
            this.setState(gUIButton, 0, bl);
        }
    }

    public GUIButton getSelectedButton() {
        if (this.iconList == null) {
            return null;
        }
        Enumeration enumeration = this.iconList.elements();
        while (enumeration.hasMoreElements()) {
            GUIButton gUIButton = (GUIButton)enumeration.nextElement();
            if (gUIButton == null || gUIButton.getState() != 1) continue;
            return gUIButton;
        }
        return null;
    }

    public void setState(GUIButton gUIButton, int n, boolean bl) {
        int n2 = gUIButton.getState();
        if (n2 == n) {
            return;
        }
        gUIButton.setState(n);
        if (bl) {
            this.paintButton(gUIButton);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public GUIButton getTargetButton(Point point) {
        if (this.iconList == null) {
            return null;
        }
        Enumeration enumeration = this.iconList.elements();
        while (enumeration.hasMoreElements()) {
            GUIButton gUIButton = (GUIButton)enumeration.nextElement();
            if (gUIButton == null || !gUIButton.getBounds().contains(point)) continue;
            return gUIButton;
        }
        return null;
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.getPopUpManager() != null) {
            this.getPopUpManager().eventFired(mouseEvent);
            return;
        }
        if (this.eventSource == null) {
            return;
        }
        Point point = this.eventSource.getLocation();
        Point point2 = mouseEvent.getPoint();
        MouseEvent mouseEvent2 = new MouseEvent(this.eventSource, mouseEvent.getID(), 0L, 0, point2.x - point.x, point2.y - point.y, 1, false);
        int n = this.eventSource.getPrivateState();
        this.eventSource.processMouseMotionEvent(mouseEvent2);
        if (n != this.eventSource.getPrivateState()) {
            this.paintButton(this.eventSource);
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.getPopUpManager() != null) {
            this.getPopUpManager().eventFired(mouseEvent);
            return;
        }
        GUIButton gUIButton = this.getTargetButton(mouseEvent.getPoint());
        if (mouseEvent.getID() != 505) {
            this.eventSource = gUIButton;
        }
        if (this.eventSource != null) {
            Point point = this.eventSource.getLocation();
            Point point2 = mouseEvent.getPoint();
            MouseEvent mouseEvent2 = new MouseEvent(this.eventSource, mouseEvent.getID(), 0L, 0, point2.x - point.x, point2.y - point.y, 1, false);
            int n = this.eventSource.getState();
            int n2 = this.eventSource.getPrivateState();
            this.eventSource.processMouseEvent(mouseEvent2);
            if (n != this.eventSource.getState() || n2 != this.eventSource.getPrivateState()) {
                if (mouseEvent.getID() == 502) {
                    this.deSelectAll(true);
                    this.setState(this.eventSource, 1, false);
                    if (this.actionListener != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 1, this.name));
                    }
                }
                this.paintButton(this.eventSource);
            }
        }
    }

    public void layoutIcons() {
        this.layMeOut = false;
        if (this.iconList == null) {
            return;
        }
        if (this.iconList.size() <= 0) {
            return;
        }
        Insets insets = this.getInsets();
        int n = 1;
        int n2 = insets.top;
        int n3 = insets.left;
        this.size.width = 0;
        GUIButton gUIButton = null;
        Enumeration enumeration = this.iconList.elements();
        while (enumeration.hasMoreElements()) {
            gUIButton = (GUIButton)enumeration.nextElement();
            if (gUIButton == null) continue;
            gUIButton.setLocation(n3, n2);
            n3 = n3 + gUIButton.getSize().width + this.gap;
            if (n3 > this.size.width) {
                this.size.width = n3;
            }
            if (++n <= this.columns) continue;
            n = 1;
            n3 = insets.left;
            n2 = n2 + gUIButton.getSize().height + this.gap;
        }
        this.size.height = n2 + gUIButton.getSize().height + insets.bottom;
        if (n3 == insets.left) {
            this.size.height = this.size.height - gUIButton.getSize().height - this.gap;
        }
        this.size.width = this.size.width - this.gap + insets.right;
        if (this.size.width != this.getSize().width || this.size.height != this.getSize().height) {
            this.setSize(new Dimension(this.size.width, this.size.height));
        }
    }

    public void paintButton(GUIButton gUIButton) {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        if (this.layMeOut) {
            this.layoutIcons();
        }
        graphics.translate(gUIButton.getLocation().x, gUIButton.getLocation().y);
        gUIButton.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.layMeOut) {
            this.layoutIcons();
        }
        Enumeration enumeration = this.iconList.elements();
        while (enumeration.hasMoreElements()) {
            GUIButton gUIButton = (GUIButton)enumeration.nextElement();
            if (gUIButton == null) continue;
            Graphics graphics2 = graphics.create();
            graphics2.translate(gUIButton.getLocation().x, gUIButton.getLocation().y);
            gUIButton.paint(graphics2);
        }
    }

    public void setPopUpManager(GUIPopUpManager gUIPopUpManager) {
        this.popUpManager = gUIPopUpManager;
    }

    public GUIPopUpManager getPopUpManager() {
        return this.popUpManager;
    }
}

