/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GUIProgressBar
extends GUIPanel {
    public static final int BAR = 0;
    public static final int LED = 1;
    public static final int RAINBOW_LED = 2;
    private static final int BACKGROUND_BORDER = 6;
    private static final int WHITE_BORDER = 3;
    private int percent;
    private int incrementTotal;
    private int increment;
    private Color progressColor;
    private int progressType;
    private int ledBoxes;
    private int ledBorder;

    public GUIProgressBar() {
        super(new Dimension(-1, 30));
        this.setProgressColor(Color.blue);
        this.setLedBoxes(10);
        this.setLedBorder(3);
        this.incrementTotal = 0;
    }

    public int getProgress() {
        return this.percent;
    }

    public void setTotalIncrements(int n) {
        this.incrementTotal = n;
        this.increment = 0;
    }

    public boolean setProgress(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 100) {
            n = 100;
        }
        if (this.percent == n) {
            return false;
        }
        int n2 = this.percent * this.ledBoxes / 100;
        this.percent = n;
        int n3 = this.percent * this.ledBoxes / 100;
        if (n3 == n2 && this.progressType != 0) {
            return false;
        }
        this.repaint();
        return true;
    }

    public boolean setProgress() {
        ++this.increment;
        int n = this.increment * 100 / this.incrementTotal;
        return this.setProgress(n);
    }

    public void reset() {
        this.increment = 0;
        this.percent = 0;
        this.repaint();
    }

    public void setProgressColor(Color color) {
        this.progressColor = color;
    }

    public void setProgressType(int n) {
        this.progressType = 0;
        this.progressColor = Color.blue;
        if (n == 1) {
            this.progressType = 1;
            this.progressColor = Color.green;
        }
        if (n == 2) {
            this.progressType = 2;
        }
    }

    public void setLedBoxes(int n) {
        this.ledBoxes = n;
    }

    public void setLedBorder(int n) {
        this.ledBorder = n;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.progressType == 0) {
            this.paintBar(graphics);
        }
        if (this.progressType == 1) {
            this.paintLED(graphics);
        }
        if (this.progressType == 2) {
            this.paintRainbowLED(graphics);
        }
    }

    private void paintBar(Graphics graphics) {
        Rectangle rectangle = this.getDrawableSize();
        rectangle.grow(-6, -6);
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        rectangle.grow(-3, -3);
        graphics.setColor(this.progressColor);
        int n = rectangle.width * this.percent / 100;
        graphics.fillRect(rectangle.x, rectangle.y, n, rectangle.height);
    }

    private void paintLED(Graphics graphics) {
        Rectangle rectangle = this.getDrawableSize();
        rectangle.grow(-6, -6);
        int n = rectangle.y + this.ledBorder;
        int n2 = rectangle.height - this.ledBorder * 2;
        int n3 = (rectangle.width - this.ledBorder) / this.ledBoxes;
        rectangle.x += this.ledBorder;
        Color color = this.progressColor.darker().darker().darker();
        int n4 = 0;
        while (n4 < this.ledBoxes) {
            int n5 = rectangle.x + (rectangle.width - this.ledBorder) * n4 / this.ledBoxes;
            graphics.setColor(Color.black);
            graphics.drawRect(n5, n, n3 - this.ledBorder - 1, n2 - 1);
            graphics.setColor(color);
            if (this.percent > n4 * 100 / this.ledBoxes) {
                graphics.setColor(this.progressColor);
            }
            graphics.fillRect(n5 + 1, n + 1, n3 - this.ledBorder - 2, n2 - 2);
            ++n4;
        }
    }

    private void paintRainbowLED(Graphics graphics) {
        Rectangle rectangle = this.getDrawableSize();
        rectangle.grow(-6, -6);
        int n = rectangle.y + this.ledBorder;
        int n2 = rectangle.height - this.ledBorder * 2;
        int n3 = (rectangle.width - this.ledBorder) / this.ledBoxes;
        rectangle.x += this.ledBorder;
        double d = 0.25;
        double d2 = 0.0;
        double d3 = (d2 - d) / (double)this.ledBoxes;
        double d4 = d;
        int n4 = 0;
        while (n4 < this.ledBoxes) {
            int n5 = rectangle.x + (rectangle.width - this.ledBorder) * n4 / this.ledBoxes;
            graphics.setColor(Color.black);
            graphics.drawRect(n5, n, n3 - this.ledBorder - 1, n2 - 1);
            Color color = Color.getHSBColor((float)d4, 1.0f, 1.0f);
            Color color2 = Color.getHSBColor((float)d4, 1.0f, 0.18f);
            graphics.setColor(color2);
            if (this.percent > n4 * 100 / this.ledBoxes) {
                graphics.setColor(color);
            }
            graphics.fillRect(n5 + 1, n + 1, n3 - this.ledBorder - 2, n2 - 2);
            d4 += d3;
            ++n4;
        }
    }
}

