/*
 * Decompiled with CFR 0.152.
 */
package emsl.editors;

import emsl.awt.GUIDialogueBox;
import emsl.awt.GUIPanel;
import emsl.objects.FontPlus;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class FontPlusEditor
extends GUIDialogueBox
implements ItemListener {
    private transient List fontList;
    private transient List sizeList;
    private transient Checkbox plain;
    private transient Checkbox bold;
    private transient Checkbox italic;
    private transient Checkbox underline;
    private transient TextArea demoText;

    public FontPlusEditor(Frame frame) {
        super(frame, "Font Selector", true);
        GUIPanel gUIPanel = this.getDisplayPanel();
        gUIPanel.setLayout(new BorderLayout(5, 5));
        gUIPanel.setSize(600, 500);
        this.fontList = new List(10);
        this.fillInFonts();
        gUIPanel.add("Center", this.fontList);
        GUIPanel gUIPanel2 = new GUIPanel(new Dimension(-1, 60));
        gUIPanel.add("South", gUIPanel2);
        gUIPanel2.setLayout(new BorderLayout(0, 0));
        this.demoText = new TextArea("", 5, 50, 3);
        this.demoText.setEditable(false);
        this.demoText.setText("The quick brown fox jumped over the lazy dog");
        gUIPanel2.add("Center", this.demoText);
        GUIPanel gUIPanel3 = new GUIPanel();
        gUIPanel.add("East", gUIPanel3);
        gUIPanel3.setLayout(new BorderLayout(5, 5));
        this.sizeList = new List(10);
        this.fillInSizes();
        gUIPanel3.add("West", this.sizeList);
        GUIPanel gUIPanel4 = new GUIPanel();
        this.addStyleButtons(gUIPanel4);
        gUIPanel3.add("East", gUIPanel4);
        this.addExitButtons("Cancel", "OK");
        this.setFontPlus(new FontPlus());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            if (object.equals(this.plain)) {
                this.setPlain();
            } else {
                this.plain.setState(false);
            }
            if (!(this.isBold() || this.isItalic() || this.isUnderline())) {
                this.plain.setState(true);
            }
        }
        this.demoText.setFont(this.getFontPlus().getAWTFont());
    }

    public FontPlus getFontPlus() {
        FontPlus fontPlus = new FontPlus(this.getFontName(), this.getFontStyle(), this.getFontSize());
        return fontPlus;
    }

    public String getFontName() {
        String string = this.fontList.getSelectedItem();
        if (string == null) {
            string = "SansSerif";
        }
        return string;
    }

    public int getFontSize() {
        String string = this.sizeList.getSelectedItem();
        try {
            Integer n = new Integer(string);
            return n;
        }
        catch (Exception exception) {
            return 12;
        }
    }

    public int getFontStyle() {
        int n = 0;
        if (this.isBold()) {
            n |= 1;
        }
        if (this.isItalic()) {
            n |= 2;
        }
        if (this.isUnderline()) {
            n |= 4;
        }
        return n;
    }

    public boolean isPlain() {
        return this.plain.getState();
    }

    public boolean isBold() {
        return this.bold.getState();
    }

    public boolean isItalic() {
        return this.italic.getState();
    }

    public boolean isUnderline() {
        return this.underline.getState();
    }

    public void setFontPlus(FontPlus fontPlus) {
        if (fontPlus == null) {
            return;
        }
        this.setFontName(fontPlus.getName());
        this.setFontSize(fontPlus.getSize());
        this.setFontStyle(fontPlus.getStyle());
    }

    public void setFontName(String string) {
        String[] stringArray;
        if (string == null) {
            string = "SansSerif";
        }
        if ((stringArray = this.fontList.getItems()) == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                this.fontList.select(n);
                return;
            }
            ++n;
        }
        this.fontList.select(0);
    }

    public void setFontSize(int n) {
        if (n == 0) {
            n = 12;
        }
        String string = new Integer(n).toString();
        String[] stringArray = this.sizeList.getItems();
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals(string)) {
                this.sizeList.select(n2);
                return;
            }
            ++n2;
        }
        this.sizeList.select(0);
    }

    public void setFontStyle(int n) {
        if (n == 0) {
            this.setPlain();
        }
        if ((n & 1) != 0) {
            this.setBold();
        }
        if ((n & 2) != 0) {
            this.setItalic();
        }
        if ((n & 4) != 0) {
            this.setUnderline();
        }
    }

    public void setPlain() {
        this.plain.setState(true);
        this.bold.setState(false);
        this.italic.setState(false);
        this.underline.setState(false);
    }

    public void setBold() {
        this.bold.setState(true);
        this.plain.setState(false);
    }

    public void setItalic() {
        this.italic.setState(true);
        this.plain.setState(false);
    }

    public void setUnderline() {
        this.underline.setState(true);
        this.plain.setState(false);
    }

    private void addStyleButtons(Panel panel) {
        this.plain = new Checkbox("Plain", false);
        this.bold = new Checkbox("Bold", false);
        this.italic = new Checkbox("Italic", false);
        this.underline = new Checkbox("Underline", false);
        panel.setLayout(new GridLayout(0, 1));
        panel.add(this.plain);
        panel.add(this.bold);
        panel.add(this.italic);
        panel.add(this.underline);
        this.plain.addItemListener(this);
        this.bold.addItemListener(this);
        this.italic.addItemListener(this);
        this.underline.addItemListener(this);
    }

    private void fillInFonts() {
        this.fontList.removeAll();
        this.fontList.add("Serif");
        this.fontList.add("SansSerif");
        this.fontList.add("MonoSpaced");
        this.fontList.addItemListener(this);
    }

    private void fillInSizes() {
        this.sizeList.removeAll();
        this.sizeList.add("6");
        this.sizeList.add("8");
        this.sizeList.add("9");
        this.sizeList.add("10");
        this.sizeList.add("12");
        this.sizeList.add("14");
        this.sizeList.add("18");
        this.sizeList.add("20");
        this.sizeList.add("24");
        this.sizeList.add("28");
        this.sizeList.add("32");
        this.sizeList.add("36");
        this.sizeList.add("40");
        this.sizeList.add("48");
        this.sizeList.add("72");
        this.sizeList.add("96");
        this.sizeList.add("128");
        this.sizeList.addItemListener(this);
    }
}

