/*
 * Decompiled with CFR 0.152.
 */
package emsl.io;

import emsl.awt.GUIButton;
import emsl.awt.GUIDialogueBox;
import emsl.awt.GUILabelPanel;
import emsl.awt.GUIPanel;
import emsl.awt.GUITextField;
import emsl.io.DataBaseSockets;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LoginManager
extends GUIDialogueBox
implements ActionListener {
    private String hostname = "130.20.182.21";
    private int portNumber = 3001;
    private String username = "qg598";
    private String password;
    private Frame parent;
    private GUITextField usernameText;
    private GUITextField passwordText;
    private GUITextField hostText;
    private GUITextField portText;
    private GUILabelPanel hostPanel;
    private GUILabelPanel portPanel;
    private GUIButton button;
    private boolean isDataBaseUsable;

    public LoginManager(Frame frame) {
        super(frame, "Document Server Login", false);
        this.parent = frame;
        this.isDataBaseUsable = false;
        this.createLoginDialogue();
    }

    public void createLoginDialogue() {
        GUIPanel gUIPanel = this.getDisplayPanel();
        gUIPanel.setLayout(new GridLayout(0, 1, 10, 10));
        this.usernameText = new GUITextField("username", 0, 30);
        this.passwordText = new GUITextField("password", 0, 30);
        GUILabelPanel gUILabelPanel = new GUILabelPanel((Component)this.usernameText, "Username : ", 80);
        gUILabelPanel.setBehaviour(3);
        gUIPanel.add(gUILabelPanel);
        gUILabelPanel = new GUILabelPanel((Component)this.passwordText, "Password : ", 80);
        gUILabelPanel.setBehaviour(3);
        gUIPanel.add(gUILabelPanel);
        this.hostText = new GUITextField("hostname", 0, 30);
        this.portText = new GUITextField("port", 2, 30);
        this.hostPanel = new GUILabelPanel((Component)this.hostText, "Host : ", 80);
        this.hostPanel.setBehaviour(3);
        this.portPanel = new GUILabelPanel((Component)this.portText, "Port : ", 80);
        this.portPanel.setBehaviour(3);
        gUIPanel.add(this.hostPanel);
        gUIPanel.add(this.portPanel);
        this.passwordText.setEchoChar('*');
        this.button = new GUIButton(new Dimension(-2, -2), "Host Details...");
        this.button.setName("host");
        this.button.addActionListener(this);
        gUIPanel.add(this.button);
        this.addExitButtons("Cancel", "Login");
    }

    public void display() {
        if (this.username != null) {
            this.usernameText.setText(this.username);
        }
        if (this.hostname != null) {
            this.hostText.setText(this.hostname);
        }
        this.portText.setText(this.portNumber);
        this.passwordText.setText("");
        this.hostPanel.setVisible(false);
        this.portPanel.setVisible(false);
        this.button.setVisible(true);
        super.display();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button) {
            this.displayHostDialogue();
        }
        super.actionPerformed(actionEvent);
    }

    private void displayHostDialogue() {
        this.button.setVisible(false);
        this.hostPanel.setVisible(true);
        this.portPanel.setVisible(true);
    }

    protected boolean exitButtonPressed(GUIButton gUIButton) {
        if (gUIButton == null) {
            return false;
        }
        if (gUIButton.getText().equals("Login")) {
            ((Component)this).setCursor(new Cursor(3));
            this.username = this.usernameText.getText();
            this.password = this.passwordText.getText();
            this.hostname = this.hostText.getText();
            this.portNumber = this.portText.getInteger();
            DataBaseSockets dataBaseSockets = this.login();
            this.logout(dataBaseSockets);
            ((Component)this).setCursor(new Cursor(0));
            this.isDataBaseUsable = true;
            if (dataBaseSockets == null) {
                this.isDataBaseUsable = false;
                return false;
            }
        }
        return super.exitButtonPressed(gUIButton);
    }

    public boolean isDataBaseUsable() {
        return this.isDataBaseUsable;
    }

    public DataBaseSockets login() {
        ((Component)this.parent).setCursor(new Cursor(3));
        DataBaseSockets dataBaseSockets = new DataBaseSockets(this.parent, this.hostname, this.portNumber);
        ((Component)this.parent).setCursor(new Cursor(0));
        if (dataBaseSockets.isError()) {
            this.logout(dataBaseSockets);
            return null;
        }
        ((Component)this.parent).setCursor(new Cursor(3));
        dataBaseSockets.openConnection(this.username, this.password);
        ((Component)this.parent).setCursor(new Cursor(0));
        if (dataBaseSockets.isError()) {
            this.logout(dataBaseSockets);
            return null;
        }
        return dataBaseSockets;
    }

    public void logout(DataBaseSockets dataBaseSockets) {
        ((Component)this.parent).setCursor(new Cursor(3));
        if (dataBaseSockets != null) {
            dataBaseSockets.closeConnection();
        }
        ((Component)this.parent).setCursor(new Cursor(0));
    }
}

