/*
 * Decompiled with CFR 0.152.
 */
package emsl.objects;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Hashtable;

public class FontPlus
implements Serializable {
    public static final transient int PLAIN = 0;
    public static final transient int BOLD = 1;
    public static final transient int ITALIC = 2;
    public static final transient int UNDERLINE = 4;
    public static final transient int SUPERSCRIPT = 16;
    public static final transient int SUBSCRIPT = 32;
    public static transient Hashtable fontTable;
    public static transient Hashtable fontMetricsTable;
    private String fontName;
    private int fontSize;
    private int fontStyle;
    private int superScriptPercent;
    private int subScriptPercent;
    private transient Font AWTFont;
    private transient FontMetrics fontMetrics;
    private transient Hashtable stringWidthTable;

    public FontPlus(String string, int n, int n2) {
        if (fontTable == null) {
            fontTable = new Hashtable();
        }
        if (fontMetricsTable == null) {
            fontMetricsTable = new Hashtable();
        }
        this.cacheReset();
        this.setName(string);
        this.setStyle(n);
        this.setSize(n2);
    }

    public FontPlus() {
        this("SansSerif", 0, 12);
    }

    public FontPlus(FontPlus fontPlus) {
        this(fontPlus.getName(), fontPlus.getStyle(), fontPlus.getSize());
    }

    public FontPlus(Font font) {
        this(font.getName(), font.getStyle(), font.getSize());
    }

    public boolean equals(FontPlus fontPlus) {
        if (!this.getName().equals(fontPlus.getName())) {
            return false;
        }
        if (this.getSize() != fontPlus.getSize()) {
            return false;
        }
        return this.getStyle() == fontPlus.getStyle();
    }

    public void setName(String string) {
        this.fontName = string;
        this.cacheReset();
    }

    public void setStyle(int n) {
        this.cacheReset();
        this.fontStyle = n;
    }

    public void setSize(int n) {
        this.cacheReset();
        this.fontSize = n;
    }

    public String getName() {
        return this.fontName;
    }

    public int getStyle() {
        return this.fontStyle;
    }

    public int getSize() {
        return this.fontSize;
    }

    private boolean isStyled(int n) {
        return (this.getStyle() & n) != 0;
    }

    public boolean isPlain() {
        return this.getStyle() == 0;
    }

    public boolean isBold() {
        return this.isStyled(1);
    }

    public boolean isItalic() {
        return this.isStyled(2);
    }

    public boolean isUnderline() {
        return this.isStyled(4);
    }

    public boolean isSuperScript() {
        return this.isStyled(16);
    }

    public boolean isSubScript() {
        return this.isStyled(32);
    }

    public void setStyleState(int n, boolean bl) {
        int n2 = this.getStyle();
        if (this.isStyled(n)) {
            n2 -= n;
        }
        if (bl) {
            n2 += n;
        }
        if (n == 0) {
            n2 = 0;
        }
        if (n == 16 && this.isStyled(32)) {
            n2 -= 32;
        }
        if (n == 32 && this.isStyled(16)) {
            n2 -= 16;
        }
        this.setStyle(n2);
    }

    public void setPlain(boolean bl) {
        this.setStyleState(0, bl);
    }

    public void setBold(boolean bl) {
        this.setStyleState(1, bl);
    }

    public void setItalic(boolean bl) {
        this.setStyleState(2, bl);
    }

    public void setUnderline(boolean bl) {
        this.setStyleState(4, bl);
    }

    public void setSuperScript(boolean bl) {
        this.setStyleState(16, bl);
    }

    public void setSubScript(boolean bl) {
        this.setStyleState(32, bl);
    }

    public FontMetrics getFontMetrics() {
        if (this.fontMetrics == null) {
            this.fontMetrics = this.getHashtableFontMetrics(this.getName(), this.getStyle(), this.getSize());
        }
        return this.fontMetrics;
    }

    public int getSuperScriptPercent() {
        if (this.superScriptPercent <= 0) {
            return 33;
        }
        return this.superScriptPercent;
    }

    public int getSubScriptPercent() {
        if (this.subScriptPercent <= 0) {
            return 33;
        }
        return this.superScriptPercent;
    }

    public void setSuperScriptPercent(int n) {
        this.superScriptPercent = n;
    }

    public void getSuperScriptPercent(int n) {
        this.subScriptPercent = n;
    }

    public int getSuperScriptAscent() {
        int n = this.getFontMetrics().getAscent();
        return n * this.getSuperScriptPercent() / 100;
    }

    public int getSubScriptDescent() {
        int n = this.getFontMetrics().getAscent();
        return n * this.getSuperScriptPercent() / 100;
    }

    public Font getAWTFont() {
        if (this.AWTFont == null) {
            String string = this.getName();
            int n = this.getStyle() & 3;
            int n2 = this.getSize();
            this.AWTFont = this.getHashtableFont(string, n, n2);
        }
        return this.AWTFont;
    }

    public int getWidth(String string) {
        Integer n;
        if (string == null) {
            return 0;
        }
        if (string.length() <= 0) {
            return 0;
        }
        if (this.stringWidthTable == null) {
            this.cacheReset();
        }
        if ((n = (Integer)this.stringWidthTable.get(string)) != null) {
            return n;
        }
        if (this.stringWidthTable.size() > 200) {
            this.stringWidthTable = new Hashtable();
        }
        n = new Integer(this.getFontMetrics().stringWidth(string));
        this.stringWidthTable.put(string, n);
        return n;
    }

    private void cacheReset() {
        this.AWTFont = null;
        this.fontMetrics = null;
        this.stringWidthTable = new Hashtable();
    }

    private String getHashtableName(String string, int n, int n2) {
        return new String(String.valueOf(string) + n + n2);
    }

    private Font getHashtableFont(String string, int n, int n2) {
        String string2 = this.getHashtableName(string, n, n2);
        Font font = (Font)fontTable.get(string2);
        if (font != null) {
            return font;
        }
        font = new Font(string, n, n2);
        fontTable.put(string2, font);
        return font;
    }

    private FontMetrics getHashtableFontMetrics(String string, int n, int n2) {
        String string2 = this.getHashtableName(string, n, n2);
        FontMetrics fontMetrics = (FontMetrics)fontMetricsTable.get(string2);
        if (fontMetrics != null) {
            return fontMetrics;
        }
        Font font = this.getAWTFont();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        fontMetrics = toolkit.getFontMetrics(font);
        fontMetricsTable.put(string2, fontMetrics);
        return fontMetrics;
    }

    public String toString() {
        String string = "";
        string = String.valueOf(this.getName()) + " ";
        string = String.valueOf(string) + this.getSize() + "pt  ";
        if (this.isPlain()) {
            string = String.valueOf(string) + "Plain  ";
        }
        if (this.isBold()) {
            string = String.valueOf(string) + "Bold  ";
        }
        if (this.isItalic()) {
            string = String.valueOf(string) + "Italic  ";
        }
        if (this.isUnderline()) {
            string = String.valueOf(string) + "Underline  ";
        }
        return string;
    }
}

