/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.text.Attribute;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class AttributeList
implements Serializable {
    private Vector attributeList;
    private String attributeName;
    private transient Attribute cachedAttribute;
    private transient Attribute cachedNextAttribute;
    private transient int cachedCharacterIndex = -1;
    private transient int cachedAttributeIndex = -1;

    public AttributeList(String string, Object object) {
        this.attributeName = string;
        this.attributeList = new Vector();
        this.setAttribute(new Attribute(object), 0);
        this.cacheReset();
    }

    private int lookupAttribute(int n, int n2, int n3) {
        int n4 = n2;
        if (n3 < 1) {
            n3 = 1;
        }
        int n5 = n2;
        while (n5 < this.attributeList.size()) {
            try {
                Attribute attribute = (Attribute)this.attributeList.elementAt(n5);
                int n6 = attribute.getStartIndex();
                if (n6 > n) break;
                n4 = n5;
            }
            catch (Exception exception) {}
            n5 += n3;
        }
        return n4;
    }

    private int getAttributeIndex(int n) {
        int n2 = this.lookupAttribute(n, 0, this.attributeList.size() / 8);
        int n3 = this.lookupAttribute(n, n2, 1);
        return n3;
    }

    public void cacheAttributes(int n) {
        if (this.cachedAttribute != null && this.cachedCharacterIndex == n) {
            return;
        }
        try {
            if (n >= this.cachedAttribute.getStartIndex()) {
                if (this.cachedNextAttribute == null) {
                    return;
                }
                if (n < this.cachedNextAttribute.getStartIndex()) {
                    return;
                }
            }
        }
        catch (Exception exception) {}
        int n2 = this.getAttributeIndex(n);
        this.cachedCharacterIndex = n;
        this.cachedAttributeIndex = n2;
        try {
            this.cachedAttribute = (Attribute)this.attributeList.elementAt(n2);
            this.cachedNextAttribute = (Attribute)this.attributeList.elementAt(n2 + 1);
            return;
        }
        catch (Exception exception) {
            this.cachedNextAttribute = null;
            return;
        }
    }

    public Attribute getAttribute(int n) {
        this.cacheAttributes(n);
        return this.cachedAttribute;
    }

    public Object getAttributeObject(int n) {
        try {
            this.cacheAttributes(n);
            Object object = this.cachedAttribute.getObject();
            return object;
        }
        catch (Exception exception) {
            System.out.println("getObject error in " + this.attributeName + " list, index = " + n);
            System.out.println(exception.toString());
            System.out.println(this.toString());
            return null;
        }
    }

    public int getNextAttributeIndex(int n) {
        this.cacheAttributes(n);
        if (this.cachedNextAttribute == null) {
            return -1;
        }
        return this.cachedNextAttribute.getStartIndex();
    }

    public void insertData(int n, int n2) {
        this.cacheReset();
        Enumeration enumeration = this.attributeList.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            int n3 = attribute.getStartIndex();
            if (n3 < n) continue;
            attribute.setStartIndex(n3 + n2);
        }
    }

    public void insertData(AttributeList attributeList, int n, int n2) {
        this.insertData(n, n2 - 1);
        int n3 = 1;
        do {
            Attribute attribute = (Attribute)attributeList.getAttribute(n3).clone();
            this.setAttribute(attribute, n + n3 - 1, n + n2 - 1);
        } while ((n3 = attributeList.getNextAttributeIndex(n3)) != -1);
    }

    public void deleteData(int n, int n2) {
        this.cacheReset();
        Attribute attribute = (Attribute)this.getAttribute(n2 + 1).clone();
        this.clearAttribute(n, n2);
        Enumeration enumeration = this.attributeList.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute2 = (Attribute)enumeration.nextElement();
            int n3 = attribute2.getStartIndex();
            if (n3 > n2) {
                n3 -= n2 - n + 1;
            }
            attribute2.setStartIndex(n3);
        }
        this.setAttribute(attribute, n);
    }

    public void setAttribute(Attribute attribute, int n) {
        if (attribute == null) {
            return;
        }
        Attribute attribute2 = this.getAttribute(n);
        if (attribute.equals(attribute2)) {
            return;
        }
        attribute.setStartIndex(n);
        this.insertAttribute(attribute, n);
    }

    public void setAttribute(Attribute attribute, int n, int n2) {
        if (attribute == null) {
            return;
        }
        this.cacheReset();
        Attribute attribute2 = (Attribute)this.getAttribute(n2).clone();
        this.clearAttribute(n, n2);
        this.setAttribute(attribute, n);
        this.setAttribute(attribute2, n2);
    }

    private void insertAttribute(Attribute attribute, int n) {
        this.cacheReset();
        int n2 = this.attributeList.size();
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.attributeList.size()) {
            Attribute attribute2 = (Attribute)this.attributeList.elementAt(n4);
            int n5 = attribute2.getStartIndex();
            if (n5 > n) {
                n2 = n4;
                break;
            }
            if (n5 == n) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n3 != -1) {
            this.attributeList.setElementAt(attribute, n3);
            return;
        }
        this.attributeList.insertElementAt(attribute, n2);
    }

    private void clearAttribute(int n, int n2) {
        this.cacheReset();
        int n3 = this.attributeList.size() - 1;
        while (n3 >= 0) {
            Attribute attribute = (Attribute)this.attributeList.elementAt(n3);
            int n4 = attribute.getStartIndex();
            if (n4 >= n && n4 <= n2) {
                this.attributeList.removeElementAt(n3);
            }
            --n3;
        }
    }

    private void cacheReset() {
        this.cachedCharacterIndex = -1;
        this.cachedAttribute = null;
        this.cachedNextAttribute = null;
        this.cachedAttributeIndex = -1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Attribute List for " + this.attributeName + "...");
        Enumeration enumeration = this.attributeList.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            stringBuffer.append("\n   " + attribute.toString());
        }
        return stringBuffer.toString();
    }

    public AttributeList getAttributeList(int n, int n2) {
        Object object = this.getAttributeObject(0);
        AttributeList attributeList = new AttributeList(this.attributeName, object);
        if (n2 > n) {
            return this.getAttributeList(attributeList, n, n2);
        }
        return this.getAttributeList(attributeList, n);
    }

    private AttributeList getAttributeList(AttributeList attributeList, int n, int n2) {
        int n3 = n;
        do {
            Attribute attribute = (Attribute)this.getAttribute(n3).clone();
            attributeList.setAttribute(attribute, n3 - n + 1);
        } while ((n3 = this.getNextAttributeIndex(n3)) > n && n3 <= n2);
        return attributeList;
    }

    private AttributeList getAttributeList(AttributeList attributeList, int n) {
        Attribute attribute = (Attribute)this.getAttribute(n).clone();
        attributeList.setAttribute(attribute, 1);
        return attributeList;
    }

    public Object clone() {
        Object object = this.getAttributeObject(0);
        AttributeList attributeList = new AttributeList(this.attributeName, object);
        Vector<Attribute> vector = new Vector<Attribute>();
        Enumeration enumeration = this.attributeList.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            Attribute attribute2 = (Attribute)attribute.clone();
            vector.addElement(attribute2);
        }
        attributeList.setAttributeVector(vector);
        return attributeList;
    }

    public void setAttributeVector(Vector vector) {
        this.attributeList = vector;
    }

    public Vector getAttributeVector() {
        return this.attributeList;
    }
}

