/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.objects.TextStyle;
import emsl.text.TextData;
import java.util.Vector;

public abstract class TextObject {
    private TextData textData;
    private TextStyle textStyle;
    private int x;
    private int y;
    private int width;
    private int ascent;
    private int descent;
    private int lineSpace;
    private int startIndex;
    private int widthIndex;

    public TextObject(TextData textData, int n) {
        this.setTextData(textData);
        this.setStartIndex(n);
        this.setX(0);
        this.setY(0);
        this.setWidth(0);
        this.setAscent(0);
        this.setDescent(0);
        this.setWidthIndex(0);
        this.setLineSpace(0);
    }

    public TextData getTextData() {
        return this.textData;
    }

    public void setTextData(TextData textData) {
        this.textData = textData;
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    public int getFlowCoordinate() {
        return this.getY();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getAscent() {
        return this.ascent;
    }

    public void setAscent(int n) {
        this.ascent = n;
    }

    public int getDescent() {
        return this.descent;
    }

    public void setDescent(int n) {
        this.descent = n;
    }

    public int getLineSpace() {
        return this.lineSpace;
    }

    public void setLineSpace(int n) {
        this.lineSpace = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.getAscent() + this.getDescent() + this.getLineSpace();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int n) {
        this.startIndex = n;
    }

    public int getWidthIndex() {
        return this.widthIndex;
    }

    public void setWidthIndex(int n) {
        this.widthIndex = n;
    }

    public int getEndIndex() {
        return this.getStartIndex() + this.getWidthIndex() - 1;
    }

    public void setEndIndex(int n) {
        this.setWidthIndex(n - this.getStartIndex() + 1);
    }

    public boolean contains(int n) {
        if (n < this.getStartIndex()) {
            return false;
        }
        return n <= this.getEndIndex();
    }

    public static int getObjectIndex(Vector vector, int n) {
        int n2 = 0;
        int n3 = 0;
        try {
            int n4 = 0;
            while (n4 < vector.size()) {
                TextObject textObject = (TextObject)vector.elementAt(n4);
                if (n4 == 0) {
                    n2 = textObject.getStartIndex();
                }
                n3 = textObject.getEndIndex();
                if (textObject.contains(n)) {
                    return n4;
                }
                ++n4;
            }
        }
        catch (Exception exception) {}
        if (n <= n2) {
            return 0;
        }
        return vector.size() - 1;
    }

    public static int getObjectIndex(Vector vector, double d) {
        try {
            int n = 0;
            while (n < vector.size()) {
                TextObject textObject = (TextObject)vector.elementAt(n);
                double d2 = textObject.getFlowCoordinate();
                if (d < d2) {
                    return Math.max(0, n - 1);
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return vector.size() - 1;
    }

    public static TextObject getObjectAt(Vector vector, int n) {
        try {
            return (TextObject)vector.elementAt(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static TextObject getObject(Vector vector, int n) {
        int n2 = TextObject.getObjectIndex(vector, n);
        return TextObject.getObjectAt(vector, n2);
    }

    public static TextObject getObject(Vector vector, double d) {
        int n = TextObject.getObjectIndex(vector, d);
        return TextObject.getObjectAt(vector, n);
    }
}

