/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import it.flavianopetrocchi.jpdfbookmarks.IPage;
import it.flavianopetrocchi.jpdfbookmarks.IPageProducer;
import it.flavianopetrocchi.jpdfbookmarks.PageDimension;
import it.flavianopetrocchi.jpdfbookmarks.Res;
import it.flavianopetrocchi.jpdfbookmarks.bookmark.IBookmarksConverter;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class DummyPageProducer
implements IPageProducer {
    private IBookmarksConverter converter;
    private int numberOfPages;

    @Override
    public IPage getPage(int n) {
        return new Page(n);
    }

    public void setIBookmarksConverter(IBookmarksConverter iBookmarksConverter) {
        this.converter = iBookmarksConverter;
        this.numberOfPages = iBookmarksConverter.getCountOfPages();
    }

    private class Page
    implements IPage {
        private PageDimension size;
        private BufferedImage img;
        private float previousScale;
        private final float A4_WIDTH = 8.27f;
        private final float A4_HEIGHT = 11.7f;

        public Page(int n) {
            int n2 = Toolkit.getDefaultToolkit().getScreenResolution();
            if (DummyPageProducer.this.converter != null) {
                float f = DummyPageProducer.this.converter.getPageWidth(n);
                float f2 = DummyPageProducer.this.converter.getPageHeight(n);
                this.size = new PageDimension(f, f2);
            } else {
                this.size = new PageDimension((float)n2 * 8.27f, (float)n2 * 11.7f);
            }
            this.img = this.createImage(1.0f);
        }

        @Override
        public BufferedImage getImage(float f) {
            if (f != this.previousScale) {
                this.img = this.createImage(f);
                this.previousScale = f;
            }
            return this.img;
        }

        private BufferedImage createImage(float f) {
            this.img = new BufferedImage(Math.round(this.size.getWidth() * f), Math.round(this.size.getHeight() * f), 2);
            Graphics2D graphics2D = (Graphics2D)this.img.getGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, this.img.getWidth(), this.img.getHeight());
            graphics2D.setColor(Color.black);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            String string = Res.getString("NOT_A_PDF_PAGE");
            int n = fontMetrics.getHeight();
            int n2 = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, (this.img.getWidth() - n2) / 2, this.img.getHeight() / 2 - n);
            string = Res.getString("THIS_IS_A_DUMMY_PAGE");
            n2 = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, (this.img.getWidth() - n2) / 2, this.img.getHeight() / 2 + n);
            graphics2D.dispose();
            this.previousScale = f;
            return this.img;
        }

        @Override
        public PageDimension getSize(float f) {
            return this.size;
        }
    }
}

