/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.jpdfbookmarks;

import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class ExtendedUndoManager
extends UndoManager
implements UndoableEditListener {
    private ExtendedUndoableEditSupport support = new ExtendedUndoableEditSupport();
    private Object source;

    public synchronized UndoableEdit[] getEdits() {
        Object[] objectArray = new UndoableEdit[this.edits.size()];
        this.edits.copyInto(objectArray);
        return objectArray;
    }

    public synchronized UndoableEdit[] getUndoableEdits() {
        int n = this.edits.size();
        Vector<UndoableEdit> vector = new Vector<UndoableEdit>(n);
        for (int i = n - 1; i >= 0; --i) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(i);
            if (!undoableEdit.canUndo() || !undoableEdit.isSignificant()) continue;
            vector.addElement(undoableEdit);
        }
        Object[] objectArray = new UndoableEdit[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized UndoableEdit[] getRedoableEdits() {
        int n = this.edits.size();
        Vector<UndoableEdit> vector = new Vector<UndoableEdit>(n);
        for (int i = 0; i < n; ++i) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(i);
            if (!undoableEdit.canRedo() || !undoableEdit.isSignificant()) continue;
            vector.addElement(undoableEdit);
        }
        Object[] objectArray = new UndoableEdit[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        boolean bl = super.addEdit(undoableEdit);
        if (bl) {
            this.support.postEdit(undoableEdit);
        }
        return bl;
    }

    @Override
    public synchronized void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        this.source = undoableEditEvent.getSource();
        this.addEdit(undoableEdit);
    }

    public synchronized void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.support.addUndoableEditListener(undoableEditListener);
    }

    public synchronized void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.support.removeUndoableEditListener(undoableEditListener);
    }

    class ExtendedUndoableEditSupport
    extends UndoableEditSupport {
        ExtendedUndoableEditSupport() {
        }

        @Override
        public synchronized void postEdit(UndoableEdit undoableEdit) {
            this.realSource = ExtendedUndoManager.this.source;
            super.postEdit(undoableEdit);
        }
    }
}

