/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.glyph;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.objects.FontData;

public class PdfJavaGlyphs
implements PdfGlyphs,
Serializable {
    private Area[] cachedShapes = null;
    private AffineTransform[] cachedAt = null;
    public int[] CMAP_Translate;
    public boolean isFontInstalled = false;
    public String defaultFont = "Lucida Sans";
    public String fontName = "default";
    public String logicalfontName = "default";
    Map chars = new HashMap();
    Map displayValues = new HashMap();
    Map embeddedChars = new HashMap();
    private boolean isIdentity = false;
    private boolean isFontEmbedded = false;
    private boolean hasWidths = true;
    public String baseFontName = "";
    public boolean isSubsetted;
    public float[][] lastTrm = new float[3][3];
    private Font unscaledFont = null;
    public boolean isArialInstalledLocally;
    private int maxCharCount = 255;
    public boolean isCIDFont;
    public boolean remapFont = false;
    public String font_family_name;
    public int style;
    public static FontRenderContext frc = new FontRenderContext(null, true, true);
    public static String[] fontList;
    protected PdfGlyph[] cachedEmbeddedShapes = null;
    protected int localBias = 0;
    protected int globalBias = 0;

    public void flush() {
        this.cachedShapes = null;
        this.cachedAt = null;
    }

    public String getBaseFontName() {
        return this.baseFontName;
    }

    public void setBaseFontName(String string) {
        this.baseFontName = string;
    }

    public Area getStandardGlyph(float[][] fArray, int n, String string, float f, boolean bl) {
        Area area = this.getCachedShape(n);
        if (area == null) {
            AffineTransform affineTransform;
            double d = -1.0;
            double d2 = 1.0;
            double d3 = 0.0;
            if (fArray[1][0] < 0.0f && fArray[0][1] >= 0.0f || fArray[0][1] < 0.0f && fArray[1][0] >= 0.0f) {
                d2 = 1.0;
                d = -1.0;
            }
            if (bl) {
                area = this.getGlyph(n, string, f);
                if (area != null && n == 146 && this.isArialInstalledLocally) {
                    d3 = -(area.getBounds().height - area.getBounds().y);
                }
            } else {
                String string2 = string;
                if (this.remapFont && !this.getUnscaledFont().canDisplay(string2.charAt(0))) {
                    string2 = String.valueOf((char)(n + 61440));
                }
                GlyphVector glyphVector = null;
                if (!this.isCIDFont || this.isFontInstalled) {
                    glyphVector = this.getUnscaledFont().createGlyphVector(frc, string2);
                }
                if (glyphVector != null) {
                    double d4;
                    double d5;
                    area = new Area(glyphVector.getOutline());
                    double d6 = glyphVector.getOutline().getBounds2D().getX();
                    if (d6 < 0.0) {
                        d6 = -d6;
                        affineTransform = AffineTransform.getTranslateInstance(d6 * 2.0, 0.0);
                        area.transform(affineTransform);
                    }
                    if ((d5 = (double)f / (d4 = glyphVector.getVisualBounds().getWidth() + d6 * 2.0)) < 1.0) {
                        d2 *= d5;
                    }
                }
            }
            affineTransform = new AffineTransform(d2 * (double)fArray[0][0], d2 * (double)fArray[0][1], d * (double)fArray[1][0], d * (double)fArray[1][1], 0.0, d3);
            if (area != null) {
                area.transform(affineTransform);
            }
            this.setCachedShape(n, area, affineTransform);
        }
        return area;
    }

    public Area getGlyph(int n, String string, float f) {
        Object object;
        boolean bl = true;
        GlyphVector glyphVector = null;
        String string2 = string;
        if (this.remapFont && !this.getUnscaledFont().canDisplay(string2.charAt(0))) {
            string2 = String.valueOf((char)(n + 61440));
        }
        if (!this.getUnscaledFont().canDisplay(string2.charAt(0))) {
            string2 = string;
            bl = false;
        }
        if (this.isCIDFont && this.isFontEmbedded && bl) {
            glyphVector = null;
        } else if (bl) {
            glyphVector = this.getUnscaledFont().createGlyphVector(frc, string2);
        } else {
            object = new Font(this.defaultFont, 0, 1);
            if (!((Font)object).canDisplay(string2.charAt(0))) {
                object = new Font("lucida", 0, 1);
            }
            if (((Font)object).canDisplay(string2.charAt(0))) {
                glyphVector = ((Font)object).createGlyphVector(frc, string2);
            }
        }
        object = null;
        if (glyphVector != null) {
            object = new Area(glyphVector.getOutline());
            double d = glyphVector.getOutline().getBounds2D().getX();
            double d2 = glyphVector.getOutline().getBounds2D().getWidth();
            if (!this.hasWidths) {
                float f2 = (float)((double)f - (d2 + d + d)) / 2.0f;
                if (f2 > 0.0f) {
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(f2, 0.0);
                    ((Area)object).transform(affineTransform);
                }
            } else {
                double d3;
                AffineTransform affineTransform;
                if (d < 0.0) {
                    d = -d;
                    affineTransform = AffineTransform.getTranslateInstance(d, 0.0);
                    ((Area)object).transform(affineTransform);
                }
                if ((d3 = (double)f / ((Area)object).getBounds2D().getWidth()) < 1.0) {
                    affineTransform = AffineTransform.getScaleInstance(d3, 1.0);
                    ((Area)object).transform(affineTransform);
                }
            }
        }
        return object;
    }

    public final void setCachedShape(int n, Area area, AffineTransform affineTransform) {
        Area[] areaArray = this.cachedShapes;
        AffineTransform[] affineTransformArray = this.cachedAt;
        if (areaArray == null) {
            this.cachedShapes = areaArray = new Area[this.maxCharCount];
            this.cachedAt = affineTransformArray = new AffineTransform[this.maxCharCount];
        }
        areaArray[n] = area == null ? null : area;
        if (area != null && affineTransform != null) {
            affineTransformArray[n] = affineTransform;
        }
    }

    public final AffineTransform getCachedTransform(int n) {
        AffineTransform[] affineTransformArray = this.cachedAt;
        if (affineTransformArray == null) {
            return null;
        }
        return affineTransformArray[n];
    }

    public final Area getCachedShape(int n) {
        Area[] areaArray = this.cachedShapes;
        if (areaArray == null) {
            return null;
        }
        Area area = areaArray[n];
        if (area == null) {
            return null;
        }
        return area;
    }

    public void init(int n, boolean bl) {
        this.maxCharCount = n;
        this.isCIDFont = bl;
    }

    public final Font setFont(String string, int n) {
        int n2;
        Object object;
        if (PdfDecoder.Helper != null && (object = PdfDecoder.Helper.setFont(this, string, n)) != null) {
            this.style = ((Font)object).getStyle();
            this.font_family_name = ((Font)object).getFamily();
            this.unscaledFont = object;
            return object;
        }
        if (string.equals("Helv")) {
            string = "Helvetica";
        } else if (string.equals("HeBo")) {
            string = "Helvetica-BOLD";
        } else if (string.equals("ZaDb")) {
            string = "ZapfDingbats";
        }
        this.font_family_name = string;
        this.style = 0;
        object = null;
        String string2 = null;
        if (this.font_family_name == null) {
            this.font_family_name = this.fontName;
        }
        String string3 = this.font_family_name;
        if (this.font_family_name != null) {
            string3 = this.font_family_name.toLowerCase();
        }
        if ((n2 = this.font_family_name.indexOf(44)) == -1) {
            n2 = this.font_family_name.indexOf(45);
        }
        if (n2 != -1) {
            string2 = (String)FontMappings.fontSubstitutionAliasTable.get(string3);
            object = string3.substring(n2 + 1, string3.length());
            this.style = PdfJavaGlyphs.getWeight((String)object);
            this.font_family_name = this.font_family_name.substring(0, n2).toLowerCase();
            string3 = this.font_family_name;
            if (string3.endsWith("mt")) {
                string3 = string3.substring(0, string3.length() - 2);
            }
        }
        if (string2 == null) {
            string2 = (String)FontMappings.fontSubstitutionAliasTable.get(string3);
        }
        if (string2 != null && string2.equals("arialbd")) {
            string2 = "arial-bold";
        }
        if (string2 != null) {
            this.font_family_name = string2;
            n2 = this.font_family_name.indexOf(45);
            if (n2 != -1) {
                this.font_family_name = this.font_family_name.toLowerCase();
                object = this.font_family_name.substring(n2 + 1, this.font_family_name.length());
                this.style = PdfJavaGlyphs.getWeight((String)object);
                this.font_family_name = this.font_family_name.substring(0, n2);
            }
            if ((string3 = this.font_family_name.toLowerCase()).endsWith("mt")) {
                string3 = string3.substring(0, string3.length() - 2);
            }
        }
        if (fontList != null) {
            int n3;
            boolean bl = false;
            int n4 = fontList.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (!fontList[n3].equals(string3) && (object != null || !string3.startsWith(fontList[n3]))) continue;
                this.isFontInstalled = true;
                this.font_family_name = fontList[n3];
                n3 = n4;
                bl = true;
            }
            if (!bl) {
                n4 = fontList.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (!fontList[n3].equals(string3) && (object != null || !string3.startsWith(fontList[n3]))) continue;
                    this.isFontInstalled = true;
                    this.font_family_name = fontList[n3];
                    n3 = n4;
                }
            }
            if (this.isFontInstalled && this.font_family_name.equals("arial")) {
                this.isArialInstalledLocally = true;
            }
        }
        if (!this.isFontInstalled) {
            if (object == null) {
                String string4 = this.font_family_name.toLowerCase();
                this.style = PdfJavaGlyphs.getWeight(string4);
            }
            this.font_family_name = this.defaultFont;
        }
        this.unscaledFont = new Font(this.font_family_name, this.style, n);
        return this.unscaledFont;
    }

    private static int getWeight(String string) {
        int n = 0;
        if (string.endsWith("mt")) {
            string = string.substring(0, string.length() - 2);
        }
        if (string.indexOf("heavy") != -1) {
            n = 1;
        } else if (string.indexOf("bold") != -1) {
            n = 1;
        } else if (string.indexOf("roman") != -1) {
            n = 0;
        }
        if (string.indexOf("italic") != -1) {
            n += 2;
        } else if (string.indexOf("oblique") != -1) {
            n += 2;
        }
        return n;
    }

    public final Font getUnscaledFont() {
        if (this.unscaledFont == null) {
            this.unscaledFont = new Font(this.defaultFont, 0, 1);
        }
        return this.unscaledFont;
    }

    public final void setEmbeddedCachedShape(int n, PdfGlyph pdfGlyph) {
        PdfGlyph[] pdfGlyphArray = this.cachedEmbeddedShapes;
        if (pdfGlyphArray == null) {
            this.cachedEmbeddedShapes = pdfGlyphArray = new PdfGlyph[this.maxCharCount];
        }
        if (n < pdfGlyphArray.length) {
            pdfGlyphArray[n] = pdfGlyph;
        }
    }

    public final PdfGlyph getEmbeddedCachedShape(int n) {
        PdfGlyph[] pdfGlyphArray = this.cachedEmbeddedShapes;
        if (pdfGlyphArray == null) {
            return null;
        }
        if (n < pdfGlyphArray.length) {
            PdfGlyph pdfGlyph = pdfGlyphArray[n];
            if (pdfGlyph == null) {
                return null;
            }
            return pdfGlyph;
        }
        return null;
    }

    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        return null;
    }

    public void setGIDtoCID(int[] nArray) {
    }

    public void setEncodingToUse(boolean bl, int n, boolean bl2, boolean bl3) {
    }

    public int readEmbeddedFont(boolean bl, byte[] byArray, FontData fontData) {
        return 0;
    }

    public void setIsSubsetted(boolean bl) {
        this.isSubsetted = bl;
    }

    public void setT3Glyph(int n, int n2, PdfGlyph pdfGlyph) {
    }

    public void setCharString(String string, byte[] byArray) {
    }

    public int getNumber(FontData fontData, int n, double[] dArray, int n2, boolean bl) {
        return 0;
    }

    public int getNumber(byte[] byArray, int n, double[] dArray, int n2, boolean bl) {
        return 0;
    }

    public boolean is1C() {
        return false;
    }

    public void setis1C(boolean bl) {
    }

    public void setValuesForGlyph(int n, String string, String string2, String string3) {
        Integer n2 = new Integer(n);
        this.chars.put(n2, string);
        this.displayValues.put(n2, string2);
        this.embeddedChars.put(n2, string3);
    }

    public String getDisplayValue(Integer n) {
        return (String)this.displayValues.get(n);
    }

    public String getCharGlyph(Integer n) {
        return (String)this.chars.get(n);
    }

    public String getEmbeddedEnc(Integer n) {
        return (String)this.embeddedChars.get(n);
    }

    public Map getDisplayValues() {
        return this.displayValues;
    }

    public Map getCharGlyphs() {
        return this.chars;
    }

    public Map getEmbeddedEncs() {
        return this.embeddedChars;
    }

    public void setDisplayValues(Map map) {
        this.displayValues = map;
    }

    public void setCharGlyphs(Map map) {
        this.chars = map;
    }

    public void setEmbeddedEncs(Map map) {
        this.embeddedChars = map;
    }

    public void setLocalBias(int n) {
        this.localBias = n;
    }

    public void setGlobalBias(int n) {
        this.globalBias = n;
    }

    public float getTTWidth(String string, int n, String string2, boolean bl) {
        return 0.0f;
    }

    public static String getPostName(int n) {
        return "notdef";
    }

    public int getConvertedGlyph(int n) {
        return -1;
    }

    public void setIsIdentity(boolean bl) {
        this.isIdentity = bl;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public float[] getFontBoundingBox() {
        return new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    }

    public void setFontEmbedded(boolean bl) {
        this.isFontEmbedded = bl;
    }

    public int getType() {
        return 0;
    }

    public void setHasWidths(boolean bl) {
        this.hasWidths = bl;
    }

    public void setDiffValues(String[] stringArray) {
    }

    public int getCMAPValue(int n) {
        if (this.CMAP_Translate == null) {
            return -1;
        }
        return this.CMAP_Translate[n];
    }
}

