/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.labelvertical;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VerticalText
extends JPanel {
    private JLabel lblToCopy;
    private Dimension lblSize;
    private String text;

    public VerticalText(String text) {
        this.text = text;
        this.lblToCopy = new JLabel(" " + text);
        this.lblSize = this.lblToCopy.getPreferredSize();
        this.lblToCopy.setVisible(false);
        this.add(this.lblToCopy);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.lblSize.height, this.lblSize.width);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.lblToCopy = new JLabel(" " + this.text);
        this.lblSize = this.lblToCopy.getPreferredSize();
        Graphics2D g2 = (Graphics2D)g;
        BufferedImage img = new BufferedImage(this.lblSize.width, this.lblSize.height, 2);
        Graphics2D g2img = (Graphics2D)img.getGraphics();
        g2img.setColor(this.lblToCopy.getForeground());
        g2img.setFont(this.lblToCopy.getFont());
        int base = this.lblToCopy.getBaseline(this.lblSize.width, this.lblSize.height);
        g2img.drawString(this.lblToCopy.getText(), 0, base);
        AffineTransform t = new AffineTransform();
        t.translate(this.lblSize.height, this.lblSize.width);
        t.rotate(Math.toRadians(270.0));
        t.translate(0.0, -this.lblSize.height);
        g2.drawImage(img, t, this);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VerticalText.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        System.out.println("Created GUI on EDT? " + SwingUtilities.isEventDispatchThread());
        JFrame f = new JFrame("Swing Paint Demo");
        f.setDefaultCloseOperation(3);
        f.add(new VerticalText("Ciao"));
        f.pack();
        f.setVisible(true);
    }
}

