/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.mousedraggabletree;

import it.flavianopetrocchi.mousedraggabletree.MoveType;
import it.flavianopetrocchi.mousedraggabletree.TreeDoubleClickEvent;
import it.flavianopetrocchi.mousedraggabletree.TreeDoubleClickListener;
import it.flavianopetrocchi.mousedraggabletree.TreeNodeMovedEvent;
import it.flavianopetrocchi.mousedraggabletree.TreeNodeMovedListener;
import it.flavianopetrocchi.mousedraggabletree.UndoableMoveNodes;
import it.flavianopetrocchi.mousedraggabletree.Visitor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEditSupport;

public class MouseDraggableTree
extends JTree {
    boolean isDragging = false;
    private DefaultMutableTreeNode draggingNode;
    protected DefaultMutableTreeNode draggingOverNode;
    private JPopupMenu treePopupMenu;
    private DefaultTreeModel defaultTreeModel;
    protected MoveType moveType = MoveType.MOVE_AS_SIBLING_AFTER;
    private Timer expanderTimer;
    private TreePath draggingOverPath;
    private Cursor dragCursor;
    private Cursor nodropCursor;
    private MutableTreeNode targetParent;
    private MutableTreeNode sourceParent;
    private int targetPosition;
    private int sourcePosition;
    private UndoableEditSupport undoSupport;
    private List<TreeDoubleClickListener> treeDoubleClickListeners = new ArrayList<TreeDoubleClickListener>();
    private List<TreeNodeMovedListener> treeNodeMovedListeners = new ArrayList<TreeNodeMovedListener>();
    private TreeMouseListener mouseListener;
    private MouseListener[] listeners;

    public MouseDraggableTree() {
        this.removeUIMouseListeners();
        this.undoSupport = new UndoableEditSupport(this);
        this.dragCursor = DragSource.DefaultMoveDrop;
        this.nodropCursor = DragSource.DefaultMoveNoDrop;
        this.expanderTimer = new Timer(600, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!MouseDraggableTree.this.isExpanded(MouseDraggableTree.this.draggingOverPath)) {
                    MouseDraggableTree.this.expandPath(MouseDraggableTree.this.draggingOverPath);
                }
            }
        });
        this.expanderTimer.setRepeats(false);
        this.mouseListener = new TreeMouseListener();
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
        CustomRenderer treeRenderer = new CustomRenderer();
        this.setCellRenderer(treeRenderer);
        this.setEditable(false);
        this.setInvokesStopCellEditing(true);
    }

    private void removeUIMouseListeners() {
        for (MouseListener listener : this.listeners = this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
    }

    public Icon getExpanedIcon() {
        return (Icon)UIManager.get("Tree.expandedIcon");
    }

    public Icon getCollapsedIcon() {
        return (Icon)UIManager.get("Tree.collapsedIcon");
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        if (newModel instanceof DefaultTreeModel) {
            this.defaultTreeModel = (DefaultTreeModel)newModel;
        }
    }

    public JPopupMenu getTreePopupMenu() {
        return this.treePopupMenu;
    }

    public void setTreePopupMenu(JPopupMenu treePopupMenu) {
        this.treePopupMenu = treePopupMenu;
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoSupport.addUndoableEditListener(l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.undoSupport.removeUndoableEditListener(l);
    }

    public void addTreeDoubleClickListener(TreeDoubleClickListener listener) {
        this.treeDoubleClickListeners.add(listener);
    }

    public void removeTreeDoubleClickListener(TreeDoubleClickListener listener) {
        this.treeDoubleClickListeners.remove(listener);
    }

    public void addTreeNodeMovedListener(TreeNodeMovedListener listener) {
        this.treeNodeMovedListeners.add(listener);
    }

    public void removeTreeNodeMovedListener(TreeNodeMovedListener listener) {
        this.treeNodeMovedListeners.remove(listener);
    }

    public void visitAllNodes(Visitor visitor) {
        this.visitAllNodes((TreeNode)this.getModel().getRoot(), visitor);
    }

    public void visitAllNodes(TreeNode node, Visitor visitor) {
        visitor.process(node);
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                this.visitAllNodes(n, visitor);
            }
        }
    }

    private boolean isValidDropLocation() {
        boolean valid = this.draggingNode != null && this.draggingOverNode != null && !this.draggingNode.equals(this.draggingOverNode) && !MouseDraggableTree.isChildNode(this.draggingNode, this.draggingOverNode);
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                valid = valid && !MouseDraggableTree.isChildNode((TreeNode)path.getLastPathComponent(), this.draggingOverNode);
            }
        }
        return valid;
    }

    private boolean moveNode() {
        if (!this.isValidDropLocation()) {
            return false;
        }
        this.targetParent = this.moveType == MoveType.MOVE_AS_CHILD ? this.draggingOverNode : (MutableTreeNode)this.draggingOverNode.getParent();
        UndoableMoveNodes undoableMoveNodes = new UndoableMoveNodes(this, this.targetParent, this.draggingOverNode, this.moveType);
        undoableMoveNodes.doEdit();
        this.undoSupport.postEdit(undoableMoveNodes);
        if (SwingUtilities.isEventDispatchThread()) {
            this.fireTreeNodeMovedEvent(new TreeNodeMovedEvent(this, this.draggingNode, this.sourceParent, this.sourcePosition));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MouseDraggableTree.this.fireTreeNodeMovedEvent(new TreeNodeMovedEvent(this, MouseDraggableTree.this.draggingNode, MouseDraggableTree.this.sourceParent, MouseDraggableTree.this.sourcePosition));
                }
            });
        }
        return true;
    }

    public void updateTree(final MouseListener ... mouseListenersToRestore) {
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.updateComponentTreeUI(this);
            this.removeUIMouseListeners();
            this.addMouseListener(this.mouseListener);
            if (mouseListenersToRestore != null) {
                for (MouseListener l : mouseListenersToRestore) {
                    this.addMouseListener(l);
                }
            }
        } else {
            Runnable callUpdateTreeAndTable = new Runnable(){

                public void run() {
                    MouseDraggableTree.this.updateTree(mouseListenersToRestore);
                }
            };
            SwingUtilities.invokeLater(callUpdateTreeAndTable);
        }
    }

    private static boolean isChildNode(TreeNode parent, TreeNode node) {
        if (parent == null || node == null) {
            return false;
        }
        if (parent.equals(node)) {
            return true;
        }
        for (int k = 0; k < parent.getChildCount(); ++k) {
            TreeNode child = parent.getChildAt(k);
            if (!MouseDraggableTree.isChildNode(child, node)) continue;
            return true;
        }
        return false;
    }

    private void fireTreeDoubleClickEvent(TreeDoubleClickEvent e) {
        for (int i = this.treeDoubleClickListeners.size() - 1; i >= 0; --i) {
            this.treeDoubleClickListeners.get(i).treeDoubleClick(e);
        }
    }

    private void fireTreeNodeMovedEvent(TreeNodeMovedEvent e) {
        for (int i = this.treeNodeMovedListeners.size() - 1; i >= 0; --i) {
            this.treeNodeMovedListeners.get(i).treeNodeMoved(e);
        }
    }

    private boolean isDragNodeOverTree(int x, int y) {
        JLabel lbl;
        Icon icon;
        this.draggingOverPath = this.getPathForLocation(x, y);
        if (this.draggingOverPath == null) {
            this.draggingOverNode = null;
            this.repaint();
            return false;
        }
        Rectangle nodeRect = this.getPathBounds(this.draggingOverPath);
        this.draggingOverNode = (DefaultMutableTreeNode)this.draggingOverPath.getLastPathComponent();
        if (!this.draggingOverNode.isLeaf()) {
            this.expanderTimer.restart();
        }
        this.moveType = x < nodeRect.x + (icon = (lbl = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, this.draggingOverNode, false, this.isExpanded(this.draggingOverPath), this.getModel().isLeaf(this.draggingOverNode), 0, false)).getIcon()).getIconWidth() ? (y < nodeRect.y + nodeRect.height / 2 ? MoveType.MOVE_AS_SIBLING_BEFORE : MoveType.MOVE_AS_SIBLING_AFTER) : MoveType.MOVE_AS_CHILD;
        this.repaint();
        return true;
    }

    private TreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        TreeNode treeNode = null;
        try {
            treeNode = (TreeNode)path.getLastPathComponent();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return treeNode;
    }

    public class CustomRenderer
    extends JLabel
    implements TreeCellRenderer {
        private DefaultMutableTreeNode previous;
        private ImageIcon borderIcon;
        private boolean selected;
        private boolean focused;
        private Color backgroundSelectionColor;
        private Color textSelectionColor;
        private Color borderSelectionColor;

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
            this.backgroundSelectionColor = defaultRenderer.getBackgroundSelectionColor();
            this.textSelectionColor = defaultRenderer.getTextSelectionColor();
            this.borderSelectionColor = defaultRenderer.getBorderSelectionColor();
            this.setForeground(defaultRenderer.getTextNonSelectionColor());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.setText(node.toString());
            TreePath path = new TreePath(node.getPath());
            if (node.isLeaf()) {
                this.setIcon(defaultRenderer.getLeafIcon());
            } else if (tree.isCollapsed(path)) {
                this.setIcon(defaultRenderer.getClosedIcon());
            } else if (tree.isExpanded(path)) {
                this.setIcon(defaultRenderer.getOpenIcon());
            }
            if (sel) {
                this.setForeground(this.textSelectionColor);
            }
            this.setBorder(null);
            Color borderColor = defaultRenderer.getTextNonSelectionColor().brighter();
            for (int i = 0; i < 2; ++i) {
                borderColor = borderColor.brighter();
            }
            if (value.equals(MouseDraggableTree.this.draggingOverNode)) {
                switch (MouseDraggableTree.this.moveType) {
                    case MOVE_AS_CHILD: {
                        if (this.previous == null || node != this.previous) {
                            Rectangle rect = MouseDraggableTree.this.getPathBounds(path);
                            Icon lblIcon = this.getIcon();
                            int iconWidth = lblIcon.getIconWidth();
                            BufferedImage borderImage = new BufferedImage(rect.width, 3, 2);
                            Graphics2D g2 = (Graphics2D)borderImage.getGraphics();
                            g2.setColor(borderColor);
                            int childLineStart = iconWidth + this.getIconTextGap();
                            g2.fillRect(childLineStart, 0, rect.width - childLineStart, 3);
                            g2.dispose();
                            this.borderIcon = new ImageIcon(borderImage);
                            this.previous = node;
                        }
                        this.setBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, this.borderIcon));
                        break;
                    }
                    case MOVE_AS_SIBLING_BEFORE: {
                        this.setBorder(BorderFactory.createMatteBorder(3, 0, 0, 0, borderColor));
                        break;
                    }
                    case MOVE_AS_SIBLING_AFTER: {
                        this.setBorder(BorderFactory.createMatteBorder(0, 0, 3, 0, borderColor));
                    }
                }
            }
            this.selected = sel;
            this.focused = hasFocus;
            return this;
        }

        protected void paintComponent(Graphics g) {
            String currentLAF = UIManager.getLookAndFeel().getName();
            if (currentLAF.equals("Nimbus")) {
                super.paintComponent(g);
                return;
            }
            Icon icon = this.getIcon();
            int iconWidth = icon.getIconWidth();
            int gap = this.getIconTextGap();
            int labelGap = iconWidth + gap - gap / 2;
            Rectangle rect = new Rectangle(labelGap, 0, this.getWidth() - labelGap, this.getHeight());
            Graphics2D g2 = (Graphics2D)g;
            if (this.selected && !currentLAF.equals("GTK look and feel")) {
                g2.setColor(this.backgroundSelectionColor);
                g2.fill(rect);
            }
            if (this.focused) {
                g2.setColor(this.borderSelectionColor);
                --rect.width;
                --rect.height;
                boolean drawDashed = UIManager.getBoolean("Tree.drawDashedFocusIndicator");
                if (drawDashed) {
                    float[] dash1 = new float[]{1.0f};
                    BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 1.0f, dash1, 0.0f);
                    g2.setStroke(dashed);
                }
                g2.draw(rect);
            }
            super.paintComponent(g);
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private Timer startEditingTimer;
        private TreePath mousePressedPath;
        private TreePath firstShiftSelect;

        public TreeMouseListener() {
            this.startEditingTimer = new Timer(600, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (TreeMouseListener.this.mousePressedPath != null && !MouseDraggableTree.this.isDragging) {
                        MouseDraggableTree.this.startEditingAtPath(TreeMouseListener.this.mousePressedPath);
                    }
                }
            });
            this.startEditingTimer.setRepeats(false);
        }

        public void mousePressed(MouseEvent e) {
            MouseDraggableTree.this.requestFocus();
            if (MouseDraggableTree.this.isEditing()) {
                MouseDraggableTree.this.stopEditing();
            }
            if (this.checkAndShowPopup(e)) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            this.mousePressedPath = MouseDraggableTree.this.getPathForLocation(x, y);
            if (this.mousePressedPath != null) {
                this.startEditingTimer.restart();
            }
            if (this.mousePressedPath == null) {
                MouseDraggableTree.this.draggingNode = null;
            } else {
                MouseDraggableTree.this.draggingNode = (DefaultMutableTreeNode)this.mousePressedPath.getLastPathComponent();
            }
            MouseDraggableTree.this.draggingOverNode = null;
            MouseDraggableTree.this.repaint();
            if (e.getClickCount() == 2) {
                MouseDraggableTree.this.fireTreeDoubleClickEvent(new TreeDoubleClickEvent(MouseDraggableTree.this, e, MouseDraggableTree.this.draggingNode));
            }
            if (this.mousePressedPath == null) {
                this.checkExpandIconClick(x, y);
            }
        }

        private void checkExpandIconClick(int x, int y) {
            TreePath path = this.findNodeOnTheRight(x, y);
            if (path != null && !MouseDraggableTree.this.getModel().isLeaf(path.getLastPathComponent())) {
                if (MouseDraggableTree.this.isExpanded(path)) {
                    MouseDraggableTree.this.collapsePath(path);
                } else {
                    MouseDraggableTree.this.expandPath(path);
                }
            }
        }

        private TreePath findNodeOnTheRight(int x, int y) {
            int step = 4;
            int max_x = MouseDraggableTree.this.getWidth();
            TreePath path = null;
            while (x < max_x && (path = MouseDraggableTree.this.getPathForLocation(x, y)) == null) {
                x += step;
            }
            return path;
        }

        public void mouseReleased(MouseEvent e) {
            int y;
            int x;
            TreePath path;
            this.startEditingTimer.stop();
            if (this.checkAndShowPopup(e)) {
                return;
            }
            MouseDraggableTree.this.expanderTimer.stop();
            boolean moveDone = false;
            if (MouseDraggableTree.this.draggingNode != null) {
                MouseDraggableTree.this.setCursor(Cursor.getDefaultCursor());
                moveDone = MouseDraggableTree.this.moveNode();
                MouseDraggableTree.this.isDragging = false;
                MouseDraggableTree.this.draggingNode = null;
                MouseDraggableTree.this.draggingOverNode = null;
                MouseDraggableTree.this.repaint();
            }
            if (!moveDone && !MouseDraggableTree.this.isEditing() && SwingUtilities.isLeftMouseButton(e) && (path = MouseDraggableTree.this.getPathForLocation(x = e.getX(), y = e.getY())) != null && !MouseDraggableTree.this.isEditing()) {
                if (e.isControlDown()) {
                    if (MouseDraggableTree.this.isPathSelected(path)) {
                        MouseDraggableTree.this.removeSelectionPath(path);
                    } else {
                        MouseDraggableTree.this.addSelectionPath(path);
                    }
                    this.firstShiftSelect = path;
                } else if (e.isShiftDown()) {
                    this.makeShiftClickSelectJava(path);
                } else {
                    MouseDraggableTree.this.setSelectionPath(path);
                    this.firstShiftSelect = path;
                }
            }
        }

        private boolean checkAndShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && MouseDraggableTree.this.treePopupMenu != null) {
                MouseDraggableTree.this.treePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                return true;
            }
            return false;
        }

        public void mouseDragged(MouseEvent e) {
            Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
            MouseDraggableTree.this.scrollRectToVisible(r);
            if (MouseDraggableTree.this.draggingNode == null || MouseDraggableTree.this.isEditing()) {
                return;
            }
            TreePath draggingPath = new TreePath(MouseDraggableTree.this.draggingNode.getPath());
            if (!MouseDraggableTree.this.isPathSelected(draggingPath)) {
                MouseDraggableTree.this.setSelectionPath(draggingPath);
            }
            if (!MouseDraggableTree.this.isDragging) {
                MouseDraggableTree.this.isDragging = true;
                MouseDraggableTree.this.setCursor(MouseDraggableTree.this.dragCursor);
            }
            if (MouseDraggableTree.this.isDragNodeOverTree(e.getX(), e.getY()) && MouseDraggableTree.this.isValidDropLocation()) {
                MouseDraggableTree.this.setCursor(MouseDraggableTree.this.dragCursor);
            } else {
                MouseDraggableTree.this.setCursor(MouseDraggableTree.this.nodropCursor);
            }
        }

        private void makeShiftClickSelectWindows(TreePath path) {
            if (path == null) {
                return;
            }
            int clickedRow = MouseDraggableTree.this.getRowForPath(path);
            int[] selectedRows = MouseDraggableTree.this.getSelectionRows();
            if (selectedRows == null || selectedRows.length == 0) {
                MouseDraggableTree.this.setSelectionRow(clickedRow);
            } else {
                Arrays.sort(selectedRows);
                int firstSelectedRow = -1;
                int lastSelectedRow = -1;
                if (clickedRow <= selectedRows[0]) {
                    firstSelectedRow = clickedRow;
                    lastSelectedRow = selectedRows[selectedRows.length - 1];
                } else {
                    firstSelectedRow = selectedRows[0];
                    lastSelectedRow = Math.max(clickedRow, selectedRows[selectedRows.length - 1]);
                }
                MouseDraggableTree.this.addSelectionInterval(firstSelectedRow, lastSelectedRow);
            }
        }

        private void makeShiftClickSelectJava(TreePath path) {
            if (path == null) {
                return;
            }
            int clickedRow = MouseDraggableTree.this.getRowForPath(path);
            if (this.firstShiftSelect == null) {
                MouseDraggableTree.this.setSelectionRow(clickedRow);
                this.firstShiftSelect = path;
            } else {
                int firstShiftSelectRow = MouseDraggableTree.this.getRowForPath(this.firstShiftSelect);
                int firstSelectedRow = -1;
                int lastSelectedRow = -1;
                if (clickedRow <= firstShiftSelectRow) {
                    firstSelectedRow = clickedRow;
                    lastSelectedRow = firstShiftSelectRow;
                } else {
                    firstSelectedRow = firstShiftSelectRow;
                    lastSelectedRow = clickedRow;
                }
                MouseDraggableTree.this.setSelectionInterval(firstSelectedRow, lastSelectedRow);
            }
        }
    }
}

