/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.veticalbutton;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class VerticalButtonUI
extends BasicButtonUI {
    protected int angle;
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public VerticalButtonUI(int angle) {
        this.angle = angle;
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    public void paint(Graphics g, JComponent c) {
        Icon icon;
        JButton button = (JButton)c;
        String text = button.getText();
        Icon icon2 = icon = button.isEnabled() ? button.getIcon() : button.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        paintViewInsets = c.getInsets(paintViewInsets);
        VerticalButtonUI.paintViewR.x = VerticalButtonUI.paintViewInsets.left;
        VerticalButtonUI.paintViewR.y = VerticalButtonUI.paintViewInsets.top;
        VerticalButtonUI.paintViewR.height = c.getWidth() - (VerticalButtonUI.paintViewInsets.left + VerticalButtonUI.paintViewInsets.right);
        VerticalButtonUI.paintViewR.width = c.getHeight() - (VerticalButtonUI.paintViewInsets.top + VerticalButtonUI.paintViewInsets.bottom);
        VerticalButtonUI.paintIconR.height = 0;
        VerticalButtonUI.paintIconR.width = 0;
        VerticalButtonUI.paintIconR.y = 0;
        VerticalButtonUI.paintIconR.x = 0;
        VerticalButtonUI.paintTextR.height = 0;
        VerticalButtonUI.paintTextR.width = 0;
        VerticalButtonUI.paintTextR.y = 0;
        VerticalButtonUI.paintTextR.x = 0;
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (this.angle == 90) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
            VerticalButtonUI.paintViewR.x = c.getHeight() / 2 - (int)fm.getStringBounds(text, g).getWidth() / 2;
            VerticalButtonUI.paintViewR.y = c.getWidth() / 2 - (int)fm.getStringBounds(text, g).getHeight() / 2;
        } else if (this.angle == 270) {
            g2.rotate(-1.5707963267948966);
            g2.translate(-c.getHeight(), 0);
            VerticalButtonUI.paintViewR.x = c.getHeight() / 2 - (int)fm.getStringBounds(text, g).getWidth() / 2;
            VerticalButtonUI.paintViewR.y = c.getWidth() / 2 - (int)fm.getStringBounds(text, g).getHeight() / 2;
        }
        if (icon != null) {
            icon.paintIcon(c, g, VerticalButtonUI.paintIconR.x, VerticalButtonUI.paintIconR.y);
        }
        if (text != null) {
            int textX = VerticalButtonUI.paintTextR.x;
            int textY = VerticalButtonUI.paintTextR.y + fm.getAscent();
            if (button.isEnabled()) {
                this.paintText(g, c, new Rectangle(VerticalButtonUI.paintViewR.x, VerticalButtonUI.paintViewR.y, textX, textY), text);
            } else {
                this.paintText(g, c, new Rectangle(VerticalButtonUI.paintViewR.x, VerticalButtonUI.paintViewR.y, textX, textY), text);
            }
        }
        g2.setTransform(tr);
    }
}

