/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.HashSet;
import java.util.Vector;
import java.util.WeakHashMap;
import net.sf.jabref.export.layout.format.CreateDocBookAuthors;
import net.sf.jabref.util.Util;

public class AuthorList {
    private final Vector<Author> authors;
    private String authorsNatbib = null;
    private String authorsFirstFirstAnds = null;
    private String authorsAlph = null;
    private final String[] authorsFirstFirst = new String[4];
    private final String[] authorsLastOnly = new String[2];
    private final String[] authorLastFirstAnds = new String[2];
    private final String[] authorsLastFirst = new String[4];
    private final String[] authorsLastFirstFirstLast = new String[2];
    private String orig;
    private int token_start;
    private int token_end;
    private int token_abbr;
    private char token_term;
    private boolean token_case;
    private Vector<Object> tokens;
    private static final int TOKEN_GROUP_LENGTH = 4;
    private static final int OFFSET_TOKEN = 0;
    private static final int OFFSET_TOKEN_ABBR = 1;
    private static final int OFFSET_TOKEN_TERM = 2;
    private static final int TOKEN_EOF = 0;
    private static final int TOKEN_AND = 1;
    private static final int TOKEN_COMMA = 2;
    private static final int TOKEN_WORD = 3;
    private static final HashSet<String> tex_names = new HashSet();
    private static final WeakHashMap<String, AuthorList> authorCache;

    private AuthorList(String string) {
        this.authors = new Vector(5);
        this.orig = string;
        this.token_start = 0;
        this.token_end = 0;
        while (this.token_start < this.orig.length()) {
            Author author = this.getAuthor();
            if (author == null) continue;
            this.authors.add(author);
        }
        this.orig = null;
        this.tokens = null;
    }

    public static AuthorList getAuthorList(String string) {
        AuthorList authorList = authorCache.get(string);
        if (authorList == null) {
            authorList = new AuthorList(string);
            authorCache.put(string, authorList);
        }
        return authorList;
    }

    public static String fixAuthor_firstNameFirstCommas(String string, boolean bl, boolean bl2) {
        return AuthorList.getAuthorList(string).getAuthorsFirstFirst(bl, bl2);
    }

    public static String fixAuthor_firstNameFirst(String string) {
        return AuthorList.getAuthorList(string).getAuthorsFirstFirstAnds();
    }

    public static String fixAuthor_lastNameFirstCommas(String string, boolean bl, boolean bl2) {
        return AuthorList.getAuthorList(string).getAuthorsLastFirst(bl, bl2);
    }

    public static String fixAuthor_lastNameFirst(String string) {
        return AuthorList.getAuthorList(string).getAuthorsLastFirstAnds(false);
    }

    public static String fixAuthor_lastNameFirst(String string, boolean bl) {
        return AuthorList.getAuthorList(string).getAuthorsLastFirstAnds(bl);
    }

    public static String fixAuthor_lastNameOnlyCommas(String string, boolean bl) {
        return AuthorList.getAuthorList(string).getAuthorsLastOnly(bl);
    }

    public static String fixAuthorForAlphabetization(String string) {
        return AuthorList.getAuthorList(string).getAuthorsForAlphabetization();
    }

    public static String fixAuthor_Natbib(String string) {
        return AuthorList.getAuthorList(string).getAuthorsNatbib();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Author getAuthor() {
        String string;
        int n;
        boolean bl;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        block30: {
            int n9;
            int n10;
            int n11;
            int n12;
            block29: {
                this.tokens = new Vector();
                n12 = -1;
                n11 = -1;
                n10 = -1;
                n9 = -1;
                block5: while (true) {
                    n8 = this.getToken();
                    switch (n8) {
                        case 0: 
                        case 1: {
                            break block5;
                        }
                        case 2: {
                            if (n10 < 0) {
                                n10 = this.tokens.size();
                                break;
                            }
                            if (n9 >= 0) break;
                            n9 = this.tokens.size();
                            break;
                        }
                        case 3: {
                            this.tokens.add(this.orig.substring(this.token_start, this.token_end));
                            this.tokens.add(this.orig.substring(this.token_start, this.token_abbr));
                            this.tokens.add(Character.valueOf(this.token_term));
                            this.tokens.add(this.token_case);
                            if (n10 >= 0 || n11 >= 0) break;
                            if (n12 < 0) {
                                if (this.token_case) break;
                                n12 = this.tokens.size() - 4;
                                break;
                            }
                            if (n11 >= 0 || !this.token_case) break;
                            n11 = this.tokens.size() - 4;
                        }
                    }
                }
                if (this.tokens.isEmpty()) {
                    return null;
                }
                n8 = -1;
                n7 = -1;
                n6 = -1;
                n5 = -1;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                bl = false;
                if (n10 >= 0) break block29;
                if (n12 < 0) {
                    Character c;
                    n3 = this.tokens.size();
                    n6 = this.tokens.size() - 4;
                    int n13 = this.tokens.size() - 8 + 2;
                    if (n13 > 0 && (c = (Character)this.tokens.elementAt(n13)).charValue() == '-') {
                        n6 -= 4;
                    }
                    if ((n = n6) > 0) {
                        n8 = 0;
                    }
                    break block30;
                } else {
                    if (n11 >= 0) {
                        n3 = this.tokens.size();
                        n4 = n6 = n11;
                    } else {
                        n4 = this.tokens.size();
                    }
                    n = n7 = n12;
                    if (n > 0) {
                        n8 = 0;
                    }
                }
                break block30;
            }
            n = this.tokens.size();
            if (n9 < 0) {
                if (n10 < n) {
                    n8 = n10;
                }
            } else {
                if (n9 < n) {
                    n8 = n9;
                }
                if (n10 < (n2 = n9)) {
                    n5 = n10;
                }
            }
            if (n12 != 0) {
                n3 = n10;
                if (n3 > 0) {
                    n6 = 0;
                }
            } else {
                if (n11 < 0) {
                    n4 = n10;
                } else {
                    n3 = n10;
                    n4 = n6 = n11;
                }
                n7 = 0;
            }
        }
        if (n8 == -1 && n6 == -1 && n7 != -1) {
            n6 = n7;
            n3 = n4;
            n7 = -1;
            n4 = -1;
        }
        if (bl) {
            // empty if block
        }
        String string2 = n8 < 0 ? null : this.concatTokens(n8, n, 0, false);
        String string3 = n8 < 0 ? null : this.concatTokens(n8, n, 1, true);
        String string4 = n7 < 0 ? null : this.concatTokens(n7, n4, 0, false);
        String string5 = n6 < 0 ? null : this.concatTokens(n6, n3, 0, false);
        if (n5 < 0) {
            string = null;
            return new Author(string2, string3, string4, string5, string);
        }
        string = this.concatTokens(n5, n2, 0, false);
        return new Author(string2, string3, string4, string5, string);
    }

    private String concatTokens(int n, int n2, int n3, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)this.tokens.get(n + n3));
        if (bl) {
            stringBuilder.append('.');
        }
        n += 4;
        while (n < n2) {
            stringBuilder.append(this.tokens.get(n - 4 + 2));
            stringBuilder.append((String)this.tokens.get(n + n3));
            if (bl) {
                stringBuilder.append('.');
            }
            n += 4;
        }
        return stringBuilder.toString();
    }

    private int getToken() {
        int n;
        this.token_start = this.token_end;
        while (this.token_start < this.orig.length() && ((n = this.orig.charAt(this.token_start)) == 126 || n == 45 || Character.isWhitespace((char)n))) {
            ++this.token_start;
        }
        this.token_end = this.token_start;
        if (this.token_start >= this.orig.length()) {
            return 0;
        }
        if (this.orig.charAt(this.token_start) == ',') {
            ++this.token_end;
            return 2;
        }
        this.token_abbr = -1;
        this.token_term = (char)32;
        this.token_case = true;
        n = 0;
        int n2 = -1;
        boolean bl = false;
        while (this.token_end < this.orig.length()) {
            char c = this.orig.charAt(this.token_end);
            if (c == '{') {
                ++n;
            }
            if (n > 0 && c == '}') {
                --n;
            }
            if (bl && this.token_abbr < 0 && n == 0) {
                this.token_abbr = this.token_end;
            }
            if (!bl && n2 < 0 && Character.isLetter(c)) {
                this.token_case = n == 0 ? Character.isUpperCase(c) : true;
                bl = true;
            }
            if (n2 >= 0 && !Character.isLetter(c)) {
                String string;
                if (!bl && tex_names.contains(string = this.orig.substring(n2 + 1, this.token_end))) {
                    this.token_case = Character.isUpperCase(string.charAt(0));
                    bl = true;
                }
                n2 = -1;
            }
            if (c == '\\') {
                n2 = this.token_end;
            }
            if (n == 0 && (c == ',' || c == '~' || c == '-' || Character.isWhitespace(c))) break;
            ++this.token_end;
        }
        if (this.token_abbr < 0) {
            this.token_abbr = this.token_end;
        }
        if (this.token_end < this.orig.length() && this.orig.charAt(this.token_end) == '-') {
            this.token_term = (char)45;
        }
        if (this.orig.substring(this.token_start, this.token_end).equalsIgnoreCase("and")) {
            return 1;
        }
        return 3;
    }

    public int size() {
        return this.authors.size();
    }

    public Author getAuthor(int n) {
        return this.authors.get(n);
    }

    public String getAuthorsNatbib() {
        if (this.authorsNatbib != null) {
            return this.authorsNatbib;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.size() > 0) {
            stringBuilder.append(this.getAuthor(0).getLastOnly());
            if (this.size() == 2) {
                stringBuilder.append(" and ");
                stringBuilder.append(this.getAuthor(1).getLastOnly());
            } else if (this.size() > 2) {
                stringBuilder.append(" et al.");
            }
        }
        this.authorsNatbib = stringBuilder.toString();
        return this.authorsNatbib;
    }

    public String getAuthorsLastOnly(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.authorsLastOnly[n] != null) {
            return this.authorsLastOnly[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.size() > 0) {
            int n3;
            stringBuilder.append(this.getAuthor(0).getLastOnly());
            for (n3 = 1; n3 < this.size() - 1; ++n3) {
                stringBuilder.append(", ");
                stringBuilder.append(this.getAuthor(n3).getLastOnly());
            }
            if (this.size() > 2 && bl) {
                stringBuilder.append(',');
            }
            if (this.size() > 1) {
                stringBuilder.append(" and ");
                stringBuilder.append(this.getAuthor(n3).getLastOnly());
            }
        }
        this.authorsLastOnly[n] = stringBuilder.toString();
        return this.authorsLastOnly[n];
    }

    public String getAuthorsLastFirst(boolean bl, boolean bl2) {
        int n = bl ? 0 : 1;
        if (this.authorsLastFirst[n += bl2 ? 0 : 2] != null) {
            return this.authorsLastFirst[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.size() > 0) {
            int n2;
            stringBuilder.append(this.getAuthor(0).getLastFirst(bl));
            for (n2 = 1; n2 < this.size() - 1; ++n2) {
                stringBuilder.append(", ");
                stringBuilder.append(this.getAuthor(n2).getLastFirst(bl));
            }
            if (this.size() > 2 && bl2) {
                stringBuilder.append(',');
            }
            if (this.size() > 1) {
                stringBuilder.append(" and ");
                stringBuilder.append(this.getAuthor(n2).getLastFirst(bl));
            }
        }
        this.authorsLastFirst[n] = stringBuilder.toString();
        return this.authorsLastFirst[n];
    }

    public String toString() {
        return this.getAuthorsLastFirstAnds(false);
    }

    public String getAuthorsLastFirstAnds(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.authorLastFirstAnds[n] != null) {
            return this.authorLastFirstAnds[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.size() > 0) {
            stringBuilder.append(this.getAuthor(0).getLastFirst(bl));
            for (int i = 1; i < this.size(); ++i) {
                stringBuilder.append(" and ");
                stringBuilder.append(this.getAuthor(i).getLastFirst(bl));
            }
        }
        this.authorLastFirstAnds[n] = stringBuilder.toString();
        return this.authorLastFirstAnds[n];
    }

    public String getAuthorsLastFirstFirstLastAnds(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.authorsLastFirstFirstLast[n] != null) {
            return this.authorsLastFirstFirstLast[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.size() > 0) {
            stringBuilder.append(this.getAuthor(0).getLastFirst(bl));
            for (int i = 1; i < this.size(); ++i) {
                stringBuilder.append(" and ");
                stringBuilder.append(this.getAuthor(i).getFirstLast(bl));
            }
        }
        this.authorsLastFirstFirstLast[n] = stringBuilder.toString();
        return this.authorsLastFirstFirstLast[n];
    }

    public String getAuthorsFirstFirst(boolean bl, boolean bl2) {
        int n = bl ? 0 : 1;
        if (this.authorsFirstFirst[n += bl2 ? 0 : 2] != null) {
            return this.authorsFirstFirst[n];
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.size() > 0) {
            int n2;
            stringBuilder.append(this.getAuthor(0).getFirstLast(bl));
            for (n2 = 1; n2 < this.size() - 1; ++n2) {
                stringBuilder.append(", ");
                stringBuilder.append(this.getAuthor(n2).getFirstLast(bl));
            }
            if (this.size() > 2 && bl2) {
                stringBuilder.append(',');
            }
            if (this.size() > 1) {
                stringBuilder.append(" and ");
                stringBuilder.append(this.getAuthor(n2).getFirstLast(bl));
            }
        }
        this.authorsFirstFirst[n] = stringBuilder.toString();
        return this.authorsFirstFirst[n];
    }

    public boolean equals(Object object) {
        if (!(object instanceof AuthorList)) {
            return false;
        }
        AuthorList authorList = (AuthorList)object;
        return this.authors.equals(authorList.authors);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.authors == null ? 0 : this.authors.hashCode());
        return n;
    }

    public String getAuthorsFirstFirstAnds() {
        if (this.authorsFirstFirstAnds != null) {
            return this.authorsFirstFirstAnds;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.size() > 0) {
            stringBuilder.append(this.getAuthor(0).getFirstLast(false));
            for (int i = 1; i < this.size(); ++i) {
                stringBuilder.append(" and ");
                stringBuilder.append(this.getAuthor(i).getFirstLast(false));
            }
        }
        this.authorsFirstFirstAnds = stringBuilder.toString();
        return this.authorsFirstFirstAnds;
    }

    public String getAuthorsForAlphabetization() {
        if (this.authorsAlph != null) {
            return this.authorsAlph;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.size() > 0) {
            stringBuilder.append(this.getAuthor(0).getNameForAlphabetization());
            for (int i = 1; i < this.size(); ++i) {
                stringBuilder.append(" and ");
                stringBuilder.append(this.getAuthor(i).getNameForAlphabetization());
            }
        }
        this.authorsAlph = stringBuilder.toString();
        return this.authorsAlph;
    }

    public static void main(String[] stringArray) {
        String string = "Olaf von Nilsen, Jr.";
        AuthorList authorList = AuthorList.getAuthorList(string);
        for (int i = 0; i < authorList.size(); ++i) {
            Author author = authorList.getAuthor(i);
            System.out.println(i + 1 + ": first = '" + author.getFirst() + '\'');
            System.out.println(i + 1 + ": last = '" + author.getLast() + '\'');
            System.out.println(i + 1 + ": jr = '" + author.getJr() + '\'');
            System.out.println(i + 1 + ": von = '" + author.getVon() + '\'');
        }
        System.out.println(new CreateDocBookAuthors().format(string));
    }

    static {
        tex_names.add("aa");
        tex_names.add("ae");
        tex_names.add("l");
        tex_names.add("o");
        tex_names.add("oe");
        tex_names.add("i");
        tex_names.add("AA");
        tex_names.add("AE");
        tex_names.add("L");
        tex_names.add("O");
        tex_names.add("OE");
        tex_names.add("j");
        authorCache = new WeakHashMap();
    }

    public static class Author {
        private final String first_part;
        private final String first_abbr;
        private final String von_part;
        private final String last_part;
        private final String jr_part;

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.first_abbr == null ? 0 : this.first_abbr.hashCode());
            n = 31 * n + (this.first_part == null ? 0 : this.first_part.hashCode());
            n = 31 * n + (this.jr_part == null ? 0 : this.jr_part.hashCode());
            n = 31 * n + (this.last_part == null ? 0 : this.last_part.hashCode());
            n = 31 * n + (this.von_part == null ? 0 : this.von_part.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Author)) {
                return false;
            }
            Author author = (Author)object;
            return Util.equals(this.first_part, author.first_part) && Util.equals(this.first_abbr, author.first_abbr) && Util.equals(this.von_part, author.von_part) && Util.equals(this.last_part, author.last_part) && Util.equals(this.jr_part, author.jr_part);
        }

        public Author(String string, String string2, String string3, String string4, String string5) {
            this.first_part = this.removeStartAndEndBraces(string);
            this.first_abbr = this.removeStartAndEndBraces(string2);
            this.von_part = this.removeStartAndEndBraces(string3);
            this.last_part = this.removeStartAndEndBraces(string4);
            this.jr_part = this.removeStartAndEndBraces(string5);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean properBrackets(String string) {
            int n = 0;
            block4: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '{': {
                        ++n;
                        break;
                    }
                    case '}': {
                        if (--n == -1) break block4;
                    }
                }
            }
            if (n != 0) return false;
            return true;
        }

        private String removeStartAndEndBraces(String string) {
            if (string == null) {
                return null;
            }
            if (!string.contains("{")) {
                return string;
            }
            String[] stringArray = string.split(" ");
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : stringArray) {
                if (string2.length() > 2 && string2.startsWith("{") && string2.endsWith("}")) {
                    String string3 = string2.substring(1, string2.length() - 1);
                    if (string3.contains("}")) {
                        if (this.properBrackets(string3)) {
                            string2 = string3;
                        }
                    } else {
                        string2 = string3;
                    }
                }
                stringBuilder.append(string2);
                stringBuilder.append(' ');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            string = stringBuilder.toString();
            if (string.startsWith("{") && string.endsWith("}")) {
                String string4 = string.substring(1, string.length() - 1);
                if (this.properBrackets(string4)) {
                    return string4;
                }
                return string;
            }
            return string;
        }

        public String getFirst() {
            return this.first_part;
        }

        public String getFirstAbbr() {
            return this.first_abbr;
        }

        public String getVon() {
            return this.von_part;
        }

        public String getLast() {
            return this.last_part;
        }

        public String getJr() {
            return this.jr_part;
        }

        public String getLastOnly() {
            if (this.von_part == null) {
                return this.last_part == null ? "" : this.last_part;
            }
            return this.last_part == null ? this.von_part : this.von_part + ' ' + this.last_part;
        }

        public String getLastFirst(boolean bl) {
            String string = this.getLastOnly();
            if (this.jr_part != null) {
                string = string + ", " + this.jr_part;
            }
            if (bl) {
                if (this.first_abbr != null) {
                    string = string + ", " + this.first_abbr;
                }
            } else if (this.first_part != null) {
                string = string + ", " + this.first_part;
            }
            return string;
        }

        public String getFirstLast(boolean bl) {
            String string = this.getLastOnly();
            string = bl ? (this.first_abbr == null ? "" : this.first_abbr + ' ') + string : (this.first_part == null ? "" : this.first_part + ' ') + string;
            if (this.jr_part != null) {
                string = string + ", " + this.jr_part;
            }
            return string;
        }

        public String getNameForAlphabetization() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.last_part != null) {
                stringBuilder.append(this.last_part);
            }
            if (this.jr_part != null) {
                stringBuilder.append(", ");
                stringBuilder.append(this.jr_part);
            }
            if (this.first_abbr != null) {
                stringBuilder.append(", ");
                stringBuilder.append(this.first_abbr);
            }
            while (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '{') {
                stringBuilder.deleteCharAt(0);
            }
            return stringBuilder.toString();
        }
    }
}

