/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.util.Util;

class AutoLinkFilesAction
extends AbstractAction {
    public AutoLinkFilesAction() {
        this.putValue("SmallIcon", GUIGlobals.getImage("autoGroup"));
        this.putValue("Name", Globals.lang("Automatically set file links"));
        this.putValue("AcceleratorKey", Globals.prefs.getKey("Automatically link files"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        Collections.addAll(arrayList, JabRef.jrf.basePanel().getSelectedEntries());
        if (arrayList.isEmpty()) {
            JabRef.jrf.basePanel().output(Globals.lang("No entries selected."));
            return;
        }
        JDialog jDialog = new JDialog((Frame)JabRef.jrf, true);
        final NamedCompound namedCompound = new NamedCompound(Globals.lang("Automatically set file links"));
        Runnable runnable = Util.autoSetLinks(arrayList, namedCompound, null, null, JabRef.jrf.basePanel().metaData(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getID() > 0) {
                    if (namedCompound.hasEdits()) {
                        namedCompound.end();
                        JabRef.jrf.basePanel().undoManager.addEdit(namedCompound);
                        JabRef.jrf.basePanel().markBaseChanged();
                    }
                    JabRef.jrf.output(Globals.lang("Finished autosetting external links."));
                } else {
                    JabRef.jrf.output(Globals.lang("Finished autosetting external links.") + " " + Globals.lang("No files found."));
                }
            }
        }, jDialog);
        JabRefExecutorService.INSTANCE.execute(runnable);
    }
}

