/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;
import net.sf.jabref.EntrySorter;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.util.MonthUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BibtexDatabase {
    private final Map<String, BibtexEntry> _entries = new Hashtable<String, BibtexEntry>();
    private String _preamble = null;
    private final HashMap<String, BibtexString> _strings = new HashMap();
    private final Set<DatabaseChangeListener> changeListeners = new HashSet<DatabaseChangeListener>();
    private boolean followCrossrefs = true;
    private static final Log LOGGER = LogFactory.getLog(BibtexDatabase.class);
    private final HashMap<String, Integer> allKeys = new HashMap();
    private final VetoableChangeListener listener = new VetoableChangeListener(){

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName() == null) {
                BibtexDatabase.this.fireDatabaseChanged(new DatabaseChangeEvent(BibtexDatabase.this, DatabaseChangeEvent.ChangeType.CHANGING_ENTRY, (BibtexEntry)propertyChangeEvent.getSource()));
            } else if ("id".equals(propertyChangeEvent.getPropertyName())) {
                BibtexEntry bibtexEntry = (BibtexEntry)BibtexDatabase.this._entries.remove(propertyChangeEvent.getOldValue());
                if (bibtexEntry != propertyChangeEvent.getSource()) {
                    BibtexDatabase.this._entries.put((String)propertyChangeEvent.getOldValue(), bibtexEntry);
                    throw new PropertyVetoException("Wrong old ID", propertyChangeEvent);
                }
                if (BibtexDatabase.this._entries.get(propertyChangeEvent.getNewValue()) != null) {
                    BibtexDatabase.this._entries.put((String)propertyChangeEvent.getOldValue(), bibtexEntry);
                    throw new PropertyVetoException("New ID already in use, please choose another", propertyChangeEvent);
                }
                BibtexDatabase.this._entries.put((String)propertyChangeEvent.getNewValue(), (BibtexEntry)propertyChangeEvent.getSource());
            } else {
                BibtexDatabase.this.fireDatabaseChanged(new DatabaseChangeEvent(BibtexDatabase.this, DatabaseChangeEvent.ChangeType.CHANGED_ENTRY, (BibtexEntry)propertyChangeEvent.getSource()));
            }
        }
    };

    public synchronized int getEntryCount() {
        return this._entries.size();
    }

    public synchronized Set<String> getKeySet() {
        return this._entries.keySet();
    }

    public synchronized EntrySorter getSorter(Comparator<BibtexEntry> comparator) {
        EntrySorter entrySorter = new EntrySorter(this._entries, comparator);
        this.addDatabaseChangeListener(entrySorter);
        return entrySorter;
    }

    public Map<String, BibtexEntry> getEntryMap() {
        return this._entries;
    }

    public synchronized BibtexEntry getEntryById(String string) {
        return this._entries.get(string);
    }

    public synchronized Collection<BibtexEntry> getEntries() {
        return this._entries.values();
    }

    public synchronized BibtexEntry getEntryByKey(String string) {
        BibtexEntry bibtexEntry = null;
        int n = string.hashCode();
        Set<String> set = this._entries.keySet();
        for (String string2 : set) {
            String string3;
            BibtexEntry bibtexEntry2 = this.getEntryById(string2);
            if (bibtexEntry2 == null || bibtexEntry2.getCiteKey() == null || (string3 = bibtexEntry2.getCiteKey()) == null || n != string3.hashCode()) continue;
            bibtexEntry = bibtexEntry2;
        }
        return bibtexEntry;
    }

    public synchronized BibtexEntry[] getEntriesByKey(String string) {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        for (BibtexEntry bibtexEntry : this._entries.values()) {
            if (!string.equals(bibtexEntry.getCiteKey())) continue;
            arrayList.add(bibtexEntry);
        }
        return arrayList.toArray(new BibtexEntry[arrayList.size()]);
    }

    public synchronized boolean insertEntry(BibtexEntry bibtexEntry) throws KeyCollisionException {
        String string = bibtexEntry.getId();
        if (this.getEntryById(string) != null) {
            throw new KeyCollisionException("ID is already in use, please choose another");
        }
        bibtexEntry.addPropertyChangeListener(this.listener);
        this._entries.put(string, bibtexEntry);
        this.fireDatabaseChanged(new DatabaseChangeEvent(this, DatabaseChangeEvent.ChangeType.ADDED_ENTRY, bibtexEntry));
        return this.checkForDuplicateKeyAndAdd(null, bibtexEntry.getCiteKey(), false);
    }

    public synchronized BibtexEntry removeEntry(String string) {
        BibtexEntry bibtexEntry = this._entries.remove(string);
        if (bibtexEntry == null) {
            return null;
        }
        this.removeKeyFromSet(bibtexEntry.getCiteKey());
        bibtexEntry.removePropertyChangeListener(this.listener);
        this.fireDatabaseChanged(new DatabaseChangeEvent(this, DatabaseChangeEvent.ChangeType.REMOVED_ENTRY, bibtexEntry));
        return bibtexEntry;
    }

    public synchronized boolean setCiteKeyForEntry(String string, String string2) {
        if (!this._entries.containsKey(string)) {
            return false;
        }
        BibtexEntry bibtexEntry = this.getEntryById(string);
        String string3 = bibtexEntry.getCiteKey();
        if (string2 != null) {
            bibtexEntry.setField("bibtexkey", string2);
        } else {
            bibtexEntry.clearField("bibtexkey");
        }
        return this.checkForDuplicateKeyAndAdd(string3, bibtexEntry.getCiteKey(), false);
    }

    public synchronized void setPreamble(String string) {
        this._preamble = string;
    }

    public synchronized String getPreamble() {
        return this._preamble;
    }

    public synchronized void addString(BibtexString bibtexString) throws KeyCollisionException {
        if (this.hasStringLabel(bibtexString.getName())) {
            throw new KeyCollisionException(Globals.lang("A string with this label already exists"));
        }
        if (this._strings.containsKey(bibtexString.getId())) {
            throw new KeyCollisionException("Duplicate BibtexString id.");
        }
        this._strings.put(bibtexString.getId(), bibtexString);
    }

    public synchronized void removeString(String string) {
        this._strings.remove(string);
    }

    public Set<String> getStringKeySet() {
        return this._strings.keySet();
    }

    public Collection<BibtexString> getStringValues() {
        return this._strings.values();
    }

    public synchronized BibtexString getString(String string) {
        return this._strings.get(string);
    }

    public synchronized int getStringCount() {
        return this._strings.size();
    }

    public synchronized boolean hasStringLabel(String string) {
        for (BibtexString bibtexString : this._strings.values()) {
            if (!bibtexString.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String resolveForStrings(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Content for resolveForStrings must not be null.");
        }
        return this.resolveContent(string, new HashSet<String>());
    }

    public List<BibtexEntry> resolveForStrings(Collection<BibtexEntry> collection, boolean bl) {
        if (collection == null) {
            throw new NullPointerException();
        }
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>(collection.size());
        for (BibtexEntry bibtexEntry : collection) {
            arrayList.add(this.resolveForStrings(bibtexEntry, bl));
        }
        return arrayList;
    }

    public BibtexEntry resolveForStrings(BibtexEntry bibtexEntry, boolean bl) {
        if (!bl) {
            bibtexEntry = (BibtexEntry)bibtexEntry.clone();
        }
        for (String string : bibtexEntry.getAllFields()) {
            bibtexEntry.setField(string.toString(), this.resolveForStrings(bibtexEntry.getField(string.toString())));
        }
        return bibtexEntry;
    }

    private String resolveString(String string, HashSet<String> hashSet) {
        for (BibtexString bibtexString : this._strings.values()) {
            if (!bibtexString.getName().toLowerCase().equals(string.toLowerCase())) continue;
            if (hashSet.contains(bibtexString.getId())) {
                LOGGER.info("Stopped due to circular reference in strings: " + string);
                return string;
            }
            hashSet.add(bibtexString.getId());
            String string2 = bibtexString.getContent();
            string2 = this.resolveContent(string2, hashSet);
            hashSet.remove(bibtexString.getId());
            return string2;
        }
        MonthUtil.Month month = MonthUtil.getMonthByShortName(string);
        if (month.isValid()) {
            return month.fullName;
        }
        return null;
    }

    private String resolveContent(String string, HashSet<String> hashSet) {
        if (string.matches(".*#[^#]+#.*")) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while ((n = string.indexOf("#", n2)) >= 0) {
                int n3;
                if (n > 0) {
                    stringBuilder.append(string.substring(n2, n));
                }
                if ((n3 = string.indexOf("#", n + 1)) >= 0) {
                    String string2 = string.substring(n + 1, n3);
                    String string3 = this.resolveString(string2, hashSet);
                    if (string3 == null) {
                        stringBuilder.append(string.substring(n, n3 + 1));
                    } else {
                        stringBuilder.append(string3);
                    }
                    n2 = n3 + 1;
                    continue;
                }
                stringBuilder.append(string.substring(n));
                n2 = string.length();
                break;
            }
            if (n2 < string.length() - 1) {
                stringBuilder.append(string.substring(n2));
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private boolean checkForDuplicateKeyAndAdd(String string, String string2, boolean bl) {
        boolean bl2;
        if (string == null) {
            bl2 = this.addKeyToSet(string2);
        } else if (string.equals(string2)) {
            bl2 = false;
        } else {
            this.removeKeyFromSet(string);
            bl2 = this.addKeyToSet(string2);
        }
        if (bl2 && bl) {
            JOptionPane.showMessageDialog(null, Globals.lang("Warning there is a duplicate key") + ':' + string2, Globals.lang("Duplicate Key Warning"), 2);
        }
        return bl2;
    }

    public int getNumberOfKeyOccurences(String string) {
        Integer n = this.allKeys.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private boolean addKeyToSet(String string) {
        boolean bl = false;
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (this.allKeys.containsKey(string)) {
            bl = true;
            this.allKeys.put(string, this.allKeys.get(string) + 1);
        } else {
            this.allKeys.put(string, 1);
        }
        return bl;
    }

    private void removeKeyFromSet(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.allKeys.containsKey(string)) {
            Integer n = this.allKeys.get(string);
            if (n == 1) {
                this.allKeys.remove(string);
            } else {
                this.allKeys.put(string, n - 1);
            }
        }
    }

    private void fireDatabaseChanged(DatabaseChangeEvent databaseChangeEvent) {
        for (DatabaseChangeListener databaseChangeListener : this.changeListeners) {
            databaseChangeListener.databaseChanged(databaseChangeEvent);
        }
    }

    public void addDatabaseChangeListener(DatabaseChangeListener databaseChangeListener) {
        this.changeListeners.add(databaseChangeListener);
    }

    public void removeDatabaseChangeListener(DatabaseChangeListener databaseChangeListener) {
        this.changeListeners.remove(databaseChangeListener);
    }

    public static String getResolvedField(String string, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        BibtexEntry bibtexEntry2;
        String string2;
        if (string.equals("bibtextype")) {
            return bibtexEntry.getType().getName();
        }
        String string3 = bibtexEntry.getFieldOrAlias(string);
        if (string3 == null && bibtexDatabase != null && bibtexDatabase.followCrossrefs && !string.equals("bibtexkey") && (string2 = bibtexEntry.getField("crossref")) != null && (bibtexEntry2 = bibtexDatabase.getEntryByKey(string2)) != null) {
            string3 = bibtexEntry2.getField(string);
        }
        return BibtexDatabase.getText(string3, bibtexDatabase);
    }

    public static String getText(String string, BibtexDatabase bibtexDatabase) {
        if (string != null && bibtexDatabase != null) {
            return bibtexDatabase.resolveForStrings(string);
        }
        return string;
    }

    public void setFollowCrossrefs(boolean bl) {
        this.followCrossrefs = bl;
    }
}

