/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexEntryTypes;
import net.sf.jabref.BibtexEntryWriter;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.export.FieldFormatter;
import net.sf.jabref.util.MonthUtil;

public class BibtexEntry {
    private static final String ID_FIELD = "id";
    public static final Map<String, String> FieldAliasesOldToNew = new HashMap<String, String>();
    public static final Map<String, String> FieldAliasesNewToOld = new HashMap<String, String>();
    private String _id;
    private BibtexEntryType _type;
    private Map<String, String> _fields = new HashMap<String, String>();
    private final VetoableChangeSupport _changeSupport = new VetoableChangeSupport(this);
    private boolean searchHit;
    private boolean groupHit;

    public BibtexEntry() {
        this(IdGenerator.next());
    }

    public BibtexEntry(String string) {
        this(string, BibtexEntryTypes.OTHER);
    }

    public BibtexEntry(String string, BibtexEntryType bibtexEntryType) {
        if (string == null) {
            throw new NullPointerException("Every BibtexEntry must have an ID");
        }
        this._id = string;
        this.setType(bibtexEntryType);
    }

    public String[] getOptionalFields() {
        String[] stringArray = this._type.getOptionalFields();
        if (stringArray == null) {
            return stringArray;
        }
        return (String[])stringArray.clone();
    }

    public String[] getRequiredFields() {
        String[] stringArray = this._type.getRequiredFields();
        if (stringArray == null) {
            return stringArray;
        }
        return (String[])stringArray.clone();
    }

    public String[] getUserDefinedFields() {
        return Globals.prefs.getStringArray("writefieldUserdefinedOrder");
    }

    public Set<String> getAllFields() {
        return new TreeSet<String>(this._fields.keySet());
    }

    public String describeRequiredFields() {
        return this._type.describeRequiredFields();
    }

    public boolean hasAllRequiredFields(BibtexDatabase bibtexDatabase) {
        return this._type.hasAllRequiredFields(this, bibtexDatabase);
    }

    public BibtexEntryType getType() {
        return this._type;
    }

    public void setType(BibtexEntryType bibtexEntryType) {
        if (bibtexEntryType == null) {
            throw new NullPointerException("Every BibtexEntry must have a type.  Instead of null, use type OTHER");
        }
        BibtexEntryType bibtexEntryType2 = this._type;
        try {
            this._type = bibtexEntryType;
            this.firePropertyChangedEvent("entrytype", bibtexEntryType2 != null ? bibtexEntryType2.getName() : null, bibtexEntryType.getName());
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public boolean updateType() {
        BibtexEntryType bibtexEntryType = BibtexEntryType.getType(this._type.getName());
        if (bibtexEntryType != null) {
            this._type = bibtexEntryType;
            return true;
        }
        this._type = BibtexEntryTypes.TYPELESS;
        return false;
    }

    public void setId(String string) throws KeyCollisionException {
        if (string == null) {
            throw new NullPointerException("Every BibtexEntry must have an ID");
        }
        try {
            this.firePropertyChangedEvent(ID_FIELD, this._id, string);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new KeyCollisionException("Couldn't change ID: " + propertyVetoException);
        }
        this._id = string;
    }

    public String getId() {
        return this._id;
    }

    public String getField(String string) {
        return this._fields.get(string);
    }

    public String getFieldOrAlias(String string) {
        Object object;
        String string2;
        String string3 = this.getField(string);
        if (string3 != null && !string3.isEmpty()) {
            return string3;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(FieldAliasesOldToNew);
        hashMap.putAll(FieldAliasesNewToOld);
        String string4 = (String)hashMap.get(string);
        if (string4 != null) {
            return this.getField(string4);
        }
        if (string.equals("date")) {
            string2 = this.getField("year");
            object = MonthUtil.getMonth(this.getField("month"));
            if (string2 != null) {
                if (((MonthUtil.Month)object).isValid()) {
                    return string2 + '-' + ((MonthUtil.Month)object).twoDigitNumber;
                }
                return string2;
            }
        }
        if (string.equals("year") || string.equals("month")) {
            string2 = this.getField("date");
            if (string2 == null) {
                return null;
            }
            object = new DateFormat(){
                static final String FORMAT1 = "yyyy-MM-dd";
                static final String FORMAT2 = "yyyy-MM";
                final SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
                final SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM");

                @Override
                public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Date parse(String string, ParsePosition parsePosition) {
                    if (string.length() - parsePosition.getIndex() == FORMAT1.length()) {
                        return this.sdf1.parse(string, parsePosition);
                    }
                    return this.sdf2.parse(string, parsePosition);
                }
            };
            try {
                Date date = ((DateFormat)object).parse(string2);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                if (string.equals("year")) {
                    return Integer.toString(calendar.get(1));
                }
                if (string.equals("month")) {
                    return Integer.toString(calendar.get(2) + 1);
                }
            }
            catch (ParseException parseException) {
                object = new SimpleDateFormat("yyyy");
                try {
                    Date date = ((DateFormat)object).parse(string2);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    if (string.equals("year")) {
                        return Integer.toString(calendar.get(1));
                    }
                }
                catch (ParseException parseException2) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getCiteKey() {
        return this._fields.containsKey("bibtexkey") ? this._fields.get("bibtexkey") : null;
    }

    public void setField(Map<String, String> map) {
        this._fields.putAll(map);
    }

    public void setField(String string, String string2) {
        if (ID_FIELD.equals(string)) {
            throw new IllegalArgumentException("The field name '" + string + "' is reserved");
        }
        String string3 = this._fields.get(string);
        try {
            this._fields.put(string, string2);
            this.firePropertyChangedEvent(string, string3, string2);
        }
        catch (PropertyVetoException propertyVetoException) {
            this._fields.put(string, string3);
            throw new IllegalArgumentException("Change rejected: " + propertyVetoException);
        }
    }

    public void clearField(String string) {
        if (ID_FIELD.equals(string)) {
            throw new IllegalArgumentException("The field name '" + string + "' is reserved");
        }
        String string2 = this._fields.get(string);
        this._fields.remove(string);
        try {
            this.firePropertyChangedEvent(string, string2, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new IllegalArgumentException("Change rejected: " + propertyVetoException);
        }
    }

    boolean allFieldsPresent(String[] stringArray, BibtexDatabase bibtexDatabase) {
        for (String string : stringArray) {
            if (BibtexDatabase.getResolvedField(string, this, bibtexDatabase) != null) continue;
            return false;
        }
        return true;
    }

    boolean atLeastOnePresent(String[] stringArray, BibtexDatabase bibtexDatabase) {
        for (String string : stringArray) {
            String string2 = BibtexDatabase.getResolvedField(string, this, bibtexDatabase);
            if (string2 == null || string2.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void firePropertyChangedEvent(String string, Object object, Object object2) throws PropertyVetoException {
        this._changeSupport.fireVetoableChange(new PropertyChangeEvent(this, string, object, object2));
    }

    public void addPropertyChangeListener(VetoableChangeListener vetoableChangeListener) {
        this._changeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removePropertyChangeListener(VetoableChangeListener vetoableChangeListener) {
        this._changeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void write(Writer writer, FieldFormatter fieldFormatter, boolean bl) throws IOException {
        new BibtexEntryWriter(fieldFormatter, bl).write(this, writer);
    }

    public Object clone() {
        BibtexEntry bibtexEntry = new BibtexEntry(this._id, this._type);
        bibtexEntry._fields = new HashMap<String, String>(this._fields);
        return bibtexEntry;
    }

    public String toString() {
        return this.getType().getName() + ':' + this.getField("bibtexkey");
    }

    public boolean isSearchHit() {
        return this.searchHit;
    }

    public void setSearchHit(boolean bl) {
        this.searchHit = bl;
    }

    public boolean isGroupHit() {
        return this.groupHit;
    }

    public void setGroupHit(boolean bl) {
        this.groupHit = bl;
    }

    public String getAuthorTitleYear(int n) {
        String[] stringArray = new String[]{this.getField("author"), this.getField("title"), this.getField("year")};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            stringArray[i] = "N/A";
        }
        String string = stringArray[0] + ": \"" + stringArray[1] + "\" (" + stringArray[2] + ')';
        if (n <= 0 || string.length() <= n) {
            return string;
        }
        return string.substring(0, n + 1) + "...";
    }

    static {
        FieldAliasesOldToNew.put("address", "location");
        FieldAliasesNewToOld.put("location", "address");
        FieldAliasesOldToNew.put("annote", "annotation");
        FieldAliasesNewToOld.put("annotation", "annote");
        FieldAliasesOldToNew.put("archiveprefix", "eprinttype");
        FieldAliasesNewToOld.put("eprinttype", "archiveprefix");
        FieldAliasesOldToNew.put("journal", "journaltitle");
        FieldAliasesNewToOld.put("journaltitle", "journal");
        FieldAliasesOldToNew.put("key", "sortkey");
        FieldAliasesNewToOld.put("sortkey", "key");
        FieldAliasesOldToNew.put("pdf", "file");
        FieldAliasesNewToOld.put("file", "pdf");
        FieldAliasesOldToNew.put("primaryclass", "eprintclass");
        FieldAliasesNewToOld.put("eprintclass", "primaryclass");
        FieldAliasesOldToNew.put("school", "institution");
        FieldAliasesNewToOld.put("institution", "school");
    }
}

